/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicNamespace;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class GraphNamespaceRegistry
implements NamespaceRegistry {
    public static final Name DEFAULT_URI_PROPERTY_NAME = ModeShapeLexicon.NAMESPACE_URI;
    public static final String GENERATED_PREFIX = "ns";
    private SimpleNamespaceRegistry cache = new SimpleNamespaceRegistry();
    private final Graph store;
    private final Path parentOfNamespaceNodes;
    private final Name uriPropertyName;
    private final List<Property> namespaceProperties;

    public GraphNamespaceRegistry(Graph store, Path parentOfNamespaceNodes, Name uriPropertyName, Property ... additionalProperties) {
        this.store = store;
        this.parentOfNamespaceNodes = parentOfNamespaceNodes;
        this.uriPropertyName = uriPropertyName != null ? uriPropertyName : DEFAULT_URI_PROPERTY_NAME;
        List properties = Collections.emptyList();
        if (additionalProperties != null && additionalProperties.length != 0) {
            properties = new ArrayList(additionalProperties.length);
            HashSet propertyNames = new HashSet();
            for (Property property : additionalProperties) {
                if (propertyNames.contains(property.getName())) continue;
                properties.add(property);
            }
        }
        this.namespaceProperties = Collections.unmodifiableList(properties);
        this.createNamespaceParentIfNeeded();
        this.initializeCacheFromStore(this.cache);
    }

    private void createNamespaceParentIfNeeded() {
        try {
            this.store.getNodeAt(this.parentOfNamespaceNodes);
        }
        catch (PathNotFoundException pnfe) {
            this.store.create(this.parentOfNamespaceNodes).and();
            ((Graph.SetValuesTo)this.store.set(JcrLexicon.PRIMARY_TYPE).on(this.parentOfNamespaceNodes)).to(ModeShapeLexicon.NAMESPACES);
        }
    }

    @Override
    public String getNamespaceForPrefix(String prefix) {
        CheckArg.isNotNull((Object)prefix, (String)"prefix");
        String uri = this.cache.getNamespaceForPrefix(prefix);
        if (uri == null && (uri = this.readUriFor(prefix)) != null) {
            this.cache.register(prefix, uri);
        }
        return uri;
    }

    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        String prefix = this.cache.getPrefixForNamespaceUri(namespaceUri, false);
        if (prefix == null && generateIfMissing && (prefix = this.readPrefixFor(namespaceUri, generateIfMissing)) != null) {
            this.cache.register(prefix, namespaceUri);
        }
        return prefix;
    }

    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        if (this.cache.isRegisteredNamespaceUri(namespaceUri)) {
            return true;
        }
        String prefix = this.readPrefixFor(namespaceUri, false);
        if (prefix != null) {
            this.cache.register(prefix, namespaceUri);
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultNamespaceUri() {
        return this.getNamespaceForPrefix("");
    }

    @Override
    public String register(String prefix, String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        namespaceUri = namespaceUri.trim();
        String previousCachedUriForPrefix = this.cache.register(prefix, namespaceUri);
        String previousPersistentUriForPrefix = this.doRegister(prefix, namespaceUri);
        return previousCachedUriForPrefix != null ? previousPersistentUriForPrefix : previousPersistentUriForPrefix;
    }

    @Override
    public boolean unregister(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        namespaceUri = namespaceUri.trim();
        boolean found = this.cache.unregister(namespaceUri);
        return this.doUnregister(namespaceUri) || found;
    }

    @Override
    public Set<String> getRegisteredNamespaceUris() {
        return this.cache.getRegisteredNamespaceUris();
    }

    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        return this.cache.getNamespaces();
    }

    public void refresh() {
        SimpleNamespaceRegistry newCache = new SimpleNamespaceRegistry();
        this.initializeCacheFromStore(newCache);
        this.cache = newCache;
    }

    public String toString() {
        ArrayList<NamespaceRegistry.Namespace> namespaces = new ArrayList<NamespaceRegistry.Namespace>(this.getNamespaces());
        Collections.sort(namespaces);
        return ((Object)namespaces).toString();
    }

    protected void initializeCacheFromStore(NamespaceRegistry cache) {
        HashSet<NamespaceRegistry.Namespace> toRegister = new HashSet<NamespaceRegistry.Namespace>(this.store.getContext().getNamespaceRegistry().getNamespaces());
        try {
            String prefix;
            Subgraph nsGraph = this.store.getSubgraphOfDepth(2).at(this.parentOfNamespaceNodes);
            ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
            for (Location nsLocation : nsGraph.getRoot().getChildren()) {
                Object ns = nsGraph.getNode(nsLocation);
                String uri = stringFactory.create(ns.getProperty(this.uriPropertyName).getFirstValue());
                if (uri == null) continue;
                prefix = this.getPrefixFor(nsLocation.getPath());
                cache.register(prefix, uri);
                toRegister.remove(new BasicNamespace(prefix, uri));
            }
            cache.register("", "");
            toRegister.remove(cache.getNamespaceForPrefix(""));
            if (!toRegister.isEmpty()) {
                Graph.Batch batch = this.store.batch();
                PathFactory pathFactory = this.store.getContext().getValueFactories().getPathFactory();
                for (NamespaceRegistry.Namespace namespace : toRegister) {
                    prefix = namespace.getPrefix();
                    if (prefix.length() == 0) continue;
                    String uri = namespace.getNamespaceUri();
                    Path pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, prefix);
                    batch.create(pathToNamespaceNode).with(this.namespaceProperties).and(this.uriPropertyName, uri).and();
                }
                batch.execute();
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        for (NamespaceRegistry.Namespace namespace : this.store.getContext().getNamespaceRegistry().getNamespaces()) {
            this.register(namespace.getPrefix(), namespace.getNamespaceUri());
        }
    }

    protected String readUriFor(String prefix) {
        try {
            PathFactory pathFactory = this.store.getContext().getValueFactories().getPathFactory();
            Path pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, prefix);
            Property uri = (Property)this.store.getProperty(this.uriPropertyName).on(pathToNamespaceNode);
            ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
            return stringFactory.create(uri.getFirstValue());
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    protected String getPrefixFor(Path path) {
        Path.Segment lastSegment = path.getLastSegment();
        String localName = lastSegment.getName().getLocalName();
        int index = lastSegment.getIndex();
        if (index == 1) {
            if (GENERATED_PREFIX.equals(localName)) {
                return localName + "00" + index;
            }
            return localName;
        }
        if (index < 10) {
            return localName + "00" + index;
        }
        if (index < 100) {
            return localName + "0" + index;
        }
        return localName + index;
    }

    protected String readPrefixFor(String namespaceUri, boolean generateIfMissing) {
        try {
            Subgraph nsGraph = this.store.getSubgraphOfDepth(2).at(this.parentOfNamespaceNodes);
            ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
            for (Location nsLocation : nsGraph.getRoot().getChildren()) {
                Object ns = nsGraph.getNode(nsLocation);
                String prefix = this.getPrefixFor(nsLocation.getPath());
                String uri = stringFactory.create(ns.getProperty(this.uriPropertyName).getFirstValue());
                if (prefix == null || uri == null || !uri.equals(namespaceUri)) continue;
                return prefix;
            }
            if (generateIfMissing) {
                PathFactory pathFactory = this.store.getContext().getValueFactories().getPathFactory();
                Path pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, GENERATED_PREFIX);
                Property uriProperty = this.store.getContext().getPropertyFactory().create(this.uriPropertyName, namespaceUri);
                ArrayList<Property> props = new ArrayList<Property>(this.namespaceProperties);
                props.add(uriProperty);
                this.store.create(pathToNamespaceNode, props).ifAbsent().and();
                return this.getPrefixFor(pathToNamespaceNode);
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected String doRegister(String prefix, String uri) {
        assert (prefix != null);
        assert (uri != null);
        prefix = prefix.trim();
        uri = uri.trim();
        if (prefix.length() == 0) {
            return null;
        }
        String previousUri = null;
        ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
        PathFactory pathFactory = this.store.getContext().getValueFactories().getPathFactory();
        Path pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, prefix);
        try {
            Subgraph nsGraph = this.store.getSubgraphOfDepth(2).at(this.parentOfNamespaceNodes);
            Location nsNodeWithPrefix = null;
            boolean updateNode = true;
            HashSet<Location> locationsToRemove = new HashSet<Location>();
            for (Location nsLocation : nsGraph.getRoot().getChildren()) {
                Object ns = nsGraph.getNode(nsLocation);
                String actualPrefix = this.getPrefixFor(nsLocation.getPath());
                String actualUri = stringFactory.create(ns.getProperty(this.uriPropertyName).getFirstValue());
                if (actualPrefix == null || actualUri == null) continue;
                if (actualPrefix.equals(prefix)) {
                    nsNodeWithPrefix = nsLocation;
                    if (actualUri.equals(uri)) {
                        updateNode = false;
                        break;
                    }
                    previousUri = actualUri;
                }
                if (!actualUri.equals(uri)) continue;
                locationsToRemove.add(ns.getLocation());
            }
            Graph.Batch batch = this.store.batch();
            for (Location namespaceToRemove : locationsToRemove) {
                batch.delete(namespaceToRemove).and();
            }
            if (nsNodeWithPrefix == null) {
                batch.create(pathToNamespaceNode).with(this.namespaceProperties).and(this.uriPropertyName, uri).and();
            } else if (updateNode) {
                ((Graph.BatchConjunction)((Graph.On)batch.set(this.uriPropertyName).to(uri)).on(pathToNamespaceNode)).and();
            }
            batch.execute();
        }
        catch (PathNotFoundException e) {
            this.store.createAt(pathToNamespaceNode).with(this.namespaceProperties).and(this.uriPropertyName, uri).getLocation();
        }
        return previousUri;
    }

    protected boolean doUnregister(String uri) {
        ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
        boolean result = false;
        try {
            Subgraph nsGraph = this.store.getSubgraphOfDepth(2).at(this.parentOfNamespaceNodes);
            HashSet<Location> locationsToRemove = new HashSet<Location>();
            for (Location nsLocation : nsGraph.getRoot().getChildren()) {
                Object ns = nsGraph.getNode(nsLocation);
                String actualUri = stringFactory.create(ns.getProperty(this.uriPropertyName).getFirstValue());
                if (!actualUri.equals(uri)) continue;
                locationsToRemove.add(ns.getLocation());
                result = true;
            }
            Graph.Batch batch = this.store.batch();
            for (Location namespaceToRemove : locationsToRemove) {
                batch.delete(namespaceToRemove).and();
            }
            batch.execute();
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        return result;
    }
}

