/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.AbstractValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ObjectValueFactory
extends AbstractValueFactory<Object> {
    private final ValueFactory<Binary> binaryValueFactory;

    public ObjectValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory, ValueFactory<Binary> binaryValueFactory) {
        super(PropertyType.OBJECT, decoder, stringValueFactory);
        CheckArg.isNotNull(binaryValueFactory, (String)"binaryValueFactory");
        this.binaryValueFactory = binaryValueFactory;
    }

    protected ValueFactory<Binary> getBinaryValueFactory() {
        return this.binaryValueFactory;
    }

    @Override
    public Object create(String value) {
        return this.getStringValueFactory().create(value);
    }

    @Override
    public Object create(String value, TextDecoder decoder) {
        return this.getStringValueFactory().create(value, decoder);
    }

    @Override
    public Object create(int value) {
        return value;
    }

    @Override
    public Object create(long value) {
        return value;
    }

    @Override
    public Object create(boolean value) {
        return value;
    }

    @Override
    public Object create(float value) {
        return Float.valueOf(value);
    }

    @Override
    public Object create(double value) {
        return value;
    }

    @Override
    public Object create(BigDecimal value) {
        return value;
    }

    @Override
    public Object create(Calendar value) {
        return value;
    }

    @Override
    public Object create(Date value) {
        return value;
    }

    @Override
    public Object create(DateTime value) {
        return value;
    }

    @Override
    public Object create(Name value) {
        return value;
    }

    @Override
    public Object create(Path value) {
        return value;
    }

    @Override
    public Object create(Reference value) {
        return value;
    }

    @Override
    public Object create(URI value) {
        return value;
    }

    @Override
    public Object create(UUID value) {
        return value;
    }

    @Override
    public Object create(Object value) {
        return value;
    }

    @Override
    public Object[] create(Object[] values) {
        return values;
    }

    @Override
    public Object create(byte[] value) {
        return this.getBinaryValueFactory().create(value);
    }

    @Override
    public Object create(Binary value) throws ValueFormatException, IoException {
        return value;
    }

    @Override
    public Object create(InputStream stream, long approximateLength) {
        return this.getBinaryValueFactory().create(stream, approximateLength);
    }

    @Override
    public Object create(Reader reader, long approximateLength) {
        return this.getBinaryValueFactory().create(reader, approximateLength);
    }

    @Override
    protected Object[] createEmptyArray(int length) {
        return new Object[length];
    }
}

