/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;

@Immutable
public class UuidReference
implements Reference {
    private static final long serialVersionUID = 2299467578161645109L;
    private UUID uuid;

    public UuidReference(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getString() {
        return this.uuid.toString();
    }

    public String getString(TextEncoder encoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        return encoder.encode(this.getString());
    }

    public int compareTo(Reference that) {
        if (this == that) {
            return 0;
        }
        if (that instanceof UuidReference) {
            return this.uuid.compareTo(((UuidReference)that).getUuid());
        }
        return this.getString().compareTo(that.getString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UuidReference) {
            return this.uuid.equals(((UuidReference)obj).getUuid());
        }
        if (obj instanceof Reference) {
            return this.getString().equals(((Reference)obj).getString());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.uuid.toString();
    }
}

