/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class Between
extends Constraint {
    private static final long serialVersionUID = 1L;
    private final DynamicOperand operand;
    private final StaticOperand lowerBound;
    private final StaticOperand upperBound;
    private final boolean includeLowerBound;
    private final boolean includeUpperBound;
    private final int hc;

    public Between(DynamicOperand operand, StaticOperand lowerBound, StaticOperand upperBound) {
        this(operand, lowerBound, upperBound, true, true);
    }

    public Between(DynamicOperand operand, StaticOperand lowerBound, StaticOperand upperBound, boolean includeLowerBound, boolean includeUpperBound) {
        CheckArg.isNotNull((Object)operand, (String)"operand");
        CheckArg.isNotNull((Object)lowerBound, (String)"lowerBound");
        CheckArg.isNotNull((Object)upperBound, (String)"upperBound");
        this.operand = operand;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.includeLowerBound = includeLowerBound;
        this.includeUpperBound = includeUpperBound;
        this.hc = HashCode.compute((Object[])new Object[]{this.operand, this.lowerBound, this.upperBound});
    }

    public final DynamicOperand getOperand() {
        return this.operand;
    }

    public StaticOperand getLowerBound() {
        return this.lowerBound;
    }

    public StaticOperand getUpperBound() {
        return this.upperBound;
    }

    public boolean isLowerBoundIncluded() {
        return this.includeLowerBound;
    }

    public boolean isUpperBoundIncluded() {
        return this.includeUpperBound;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Between) {
            Between that = (Between)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.operand.equals(that.operand)) {
                return false;
            }
            if (!this.lowerBound.equals(that.lowerBound)) {
                return false;
            }
            if (!this.upperBound.equals(that.upperBound)) {
                return false;
            }
            if (this.includeLowerBound != that.includeLowerBound) {
                return false;
            }
            return this.includeUpperBound == that.includeUpperBound;
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

