/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.parse.FullTextSearchParser;

@Immutable
public class FullTextSearch
extends Constraint {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String propertyName;
    private final String fullTextSearchExpression;
    private Term term;
    private final int hc;

    public FullTextSearch(SelectorName selectorName, String propertyName, String fullTextSearchExpression, Term term) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotEmpty((String)fullTextSearchExpression, (String)"fullTextSearchExpression");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.fullTextSearchExpression = fullTextSearchExpression;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.fullTextSearchExpression});
    }

    public FullTextSearch(SelectorName selectorName, String propertyName, String fullTextSearchExpression) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotEmpty((String)fullTextSearchExpression, (String)"fullTextSearchExpression");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.fullTextSearchExpression = fullTextSearchExpression;
        this.term = null;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.fullTextSearchExpression});
    }

    public FullTextSearch(SelectorName selectorName, String fullTextSearchExpression) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotEmpty((String)fullTextSearchExpression, (String)"fullTextSearchExpression");
        this.selectorName = selectorName;
        this.propertyName = null;
        this.fullTextSearchExpression = fullTextSearchExpression;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName, this.fullTextSearchExpression});
    }

    public final SelectorName getSelectorName() {
        return this.selectorName;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final String getFullTextSearchExpression() {
        return this.fullTextSearchExpression;
    }

    public Term getTerm() {
        if (this.term == null) {
            this.term = new FullTextSearchParser().parse(this.fullTextSearchExpression);
        }
        return this.term;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FullTextSearch) {
            FullTextSearch that = (FullTextSearch)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.propertyName, (Object)that.propertyName)) {
                return false;
            }
            return this.fullTextSearchExpression.equals(that.fullTextSearchExpression);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Conjunction
    extends CompoundTerm {
        public Conjunction(List<Term> terms) {
            super(terms);
        }

        public String toString() {
            return this.toString("AND");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Disjunction
    extends CompoundTerm {
        public Disjunction(List<Term> terms) {
            super(terms);
        }

        public String toString() {
            return this.toString("OR");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CompoundTerm
    implements Term,
    Iterable<Term> {
        private final List<Term> terms;

        protected CompoundTerm(List<Term> terms) {
            this.terms = terms;
        }

        public List<Term> getTerms() {
            return this.terms;
        }

        @Override
        public Iterator<Term> iterator() {
            return this.terms.iterator();
        }

        public int hashCode() {
            return ((Object)this.terms).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (this.getClass().isInstance(obj)) {
                CompoundTerm that = (CompoundTerm)obj;
                return ((Object)this.getTerms()).equals(that.getTerms());
            }
            return false;
        }

        protected String toString(String delimiter) {
            if (this.terms.size() == 1) {
                return this.terms.iterator().next().toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("( ");
            boolean first = true;
            for (Term term : this.terms) {
                if (first) {
                    first = false;
                } else {
                    sb.append(' ').append(delimiter).append(' ');
                }
                sb.append(term);
            }
            sb.append(" )");
            return sb.toString();
        }
    }

    public static class SimpleTerm
    implements Term {
        private final String value;
        private final boolean quoted;

        public SimpleTerm(String value) {
            assert (value != null);
            assert (value.trim().length() > 0);
            this.value = value;
            this.quoted = this.value.indexOf(32) != -1;
        }

        public String getValue() {
            return this.value;
        }

        public String[] getValues() {
            return this.value.split("/w");
        }

        public boolean isQuotingRequired() {
            return this.quoted;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SimpleTerm) {
                SimpleTerm that = (SimpleTerm)obj;
                return this.getValue().equals(that.getValue());
            }
            return false;
        }

        public String toString() {
            return this.quoted ? "\"" + this.value + "\"" : this.value;
        }
    }

    public static class NegationTerm
    implements Term {
        private final Term negated;

        public NegationTerm(Term negatedTerm) {
            assert (negatedTerm != null);
            this.negated = negatedTerm;
        }

        public Term getNegatedTerm() {
            return this.negated;
        }

        public int hashCode() {
            return this.negated.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NegationTerm) {
                NegationTerm that = (NegationTerm)obj;
                return this.getNegatedTerm().equals(that.getNegatedTerm());
            }
            return false;
        }

        public String toString() {
            return "-" + this.negated.toString();
        }
    }

    public static interface Term {
    }
}

