/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.Readable;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SetQuery
extends QueryCommand {
    private static final long serialVersionUID = 1L;
    private final QueryCommand left;
    private final QueryCommand right;
    private final Operation operation;
    private final boolean all;
    private final int hc;

    public SetQuery(QueryCommand left, Operation operation, QueryCommand right, boolean all) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)right, (String)"right");
        CheckArg.isNotNull((Object)operation, (String)"operation");
        this.left = left;
        this.right = right;
        this.operation = operation;
        this.all = all;
        this.hc = HashCode.compute((Object[])new Object[]{this.left, this.right, this.operation});
    }

    public SetQuery(QueryCommand left, Operation operation, QueryCommand right, boolean all, List<Ordering> orderings, Limit limit) {
        super(orderings, limit);
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)right, (String)"right");
        CheckArg.isNotNull((Object)operation, (String)"operation");
        this.left = left;
        this.right = right;
        this.operation = operation;
        this.all = all;
        this.hc = HashCode.compute((Object[])new Object[]{this.left, this.right, this.operation});
    }

    public final QueryCommand getLeft() {
        return this.left;
    }

    public final QueryCommand getRight() {
        return this.right;
    }

    public final Operation getOperation() {
        return this.operation;
    }

    public final boolean isAll() {
        return this.all;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SetQuery) {
            SetQuery that = (SetQuery)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (this.operation != that.operation) {
                return false;
            }
            if (!this.left.equals(that.left)) {
                return false;
            }
            if (!this.right.equals(that.right)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.getLimits(), (Object)that.getLimits())) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls(this.getOrderings(), that.getOrderings());
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public SetQuery withLimit(int rowLimit) {
        return new SetQuery(this.left, this.operation, this.right, this.all, this.getOrderings(), this.getLimits().withRowLimit(rowLimit));
    }

    public SetQuery withOffset(int offset) {
        return new SetQuery(this.left, this.operation, this.right, this.all, this.getOrderings(), this.getLimits().withOffset(offset));
    }

    public SetQuery adding(Ordering ... orderings) {
        List<Ordering> newOrderings = null;
        if (this.getOrderings() != null) {
            newOrderings = new ArrayList<Ordering>(this.getOrderings());
            for (Ordering ordering : orderings) {
                newOrderings.add(ordering);
            }
        } else {
            newOrderings = Arrays.asList(orderings);
        }
        return new SetQuery(this.left, this.operation, this.right, this.all, newOrderings, this.getLimits());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation implements Readable
    {
        UNION("UNION"),
        INTERSECT("INTERSECT"),
        EXCEPT("EXCEPT");

        private static final Map<String, Operation> OPERATIONS_BY_SYMBOL;
        private final String symbol;

        private Operation(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toString() {
            return this.symbol;
        }

        public static Operation forSymbol(String symbol) {
            CheckArg.isNotNull((Object)symbol, (String)"symbol");
            return OPERATIONS_BY_SYMBOL.get(symbol.toUpperCase());
        }

        @Override
        public String getString() {
            return this.getSymbol();
        }

        static {
            HashMap<String, Operation> opsBySymbol = new HashMap<String, Operation>();
            for (Operation op : Operation.values()) {
                opsBySymbol.put(op.getSymbol(), op);
            }
            OPERATIONS_BY_SYMBOL = Collections.unmodifiableMap(opsBySymbol);
        }
    }
}

