/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.ChildNodeJoinCondition;
import org.modeshape.graph.query.model.DescendantNodeJoinCondition;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.plan.JoinAlgorithm;
import org.modeshape.graph.query.plan.PlanNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ChooseJoinAlgorithm
implements OptimizerRule {
    public static final ChooseJoinAlgorithm USE_ONLY_NESTED_JOIN_ALGORITHM = new ChooseJoinAlgorithm(true);
    public static final ChooseJoinAlgorithm USE_BEST_JOIN_ALGORITHM = new ChooseJoinAlgorithm(false);
    private final boolean useOnlyNested;

    protected ChooseJoinAlgorithm(boolean useOnlyNested) {
        this.useOnlyNested = useOnlyNested;
    }

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode joinNode : plan.findAllAtOrBelow(PlanNode.Type.JOIN)) {
            JoinCondition condition = joinNode.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
            if (this.useOnlyNested) {
                joinNode.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
                break;
            }
            if (condition instanceof DescendantNodeJoinCondition) {
                joinNode.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
                continue;
            }
            joinNode.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.MERGE);
            assert (joinNode.getChildCount() == 2);
            Set<SelectorName> leftSelectors = joinNode.getFirstChild().getSelectors();
            Set<SelectorName> rightSelectors = joinNode.getLastChild().getSelectors();
            LinkedList<Object> leftSortBy = new LinkedList<Object>();
            LinkedList<Object> rightSortBy = new LinkedList<Object>();
            this.createOrderBysForJoinCondition(condition, leftSelectors, leftSortBy, rightSelectors, rightSortBy);
            PlanNode leftSort = new PlanNode(PlanNode.Type.SORT, leftSelectors);
            leftSort.setProperty(PlanNode.Property.SORT_ORDER_BY, leftSortBy);
            joinNode.getFirstChild().insertAsParent(leftSort);
            if (joinNode.getFirstChild().findAllAtOrBelow(PlanNode.Type.DUP_REMOVE).isEmpty()) {
                PlanNode leftDupRemoval = new PlanNode(PlanNode.Type.DUP_REMOVE, leftSelectors);
                joinNode.getFirstChild().insertAsParent(leftDupRemoval);
            }
            PlanNode rightSort = new PlanNode(PlanNode.Type.SORT, rightSelectors);
            rightSort.setProperty(PlanNode.Property.SORT_ORDER_BY, rightSortBy);
            joinNode.getLastChild().insertAsParent(rightSort);
            if (!joinNode.getLastChild().findAllAtOrBelow(PlanNode.Type.DUP_REMOVE).isEmpty()) continue;
            PlanNode rightDupRemoval = new PlanNode(PlanNode.Type.DUP_REMOVE, rightSelectors);
            joinNode.getLastChild().insertAsParent(rightDupRemoval);
        }
        return plan;
    }

    protected void createOrderBysForJoinCondition(JoinCondition condition, Set<SelectorName> leftSelectors, List<Object> leftSortBy, Set<SelectorName> rightSelectors, List<Object> rightSortBy) {
        if (condition instanceof SameNodeJoinCondition) {
            SameNodeJoinCondition joinCondition = (SameNodeJoinCondition)condition;
            SelectorName name1 = joinCondition.getSelector1Name();
            SelectorName name2 = joinCondition.getSelector2Name();
            if (leftSelectors.contains(name1)) {
                leftSortBy.add(name1);
                rightSortBy.add(name2);
            } else {
                leftSortBy.add(name2);
                rightSortBy.add(name1);
            }
        } else if (condition instanceof ChildNodeJoinCondition) {
            ChildNodeJoinCondition joinCondition = (ChildNodeJoinCondition)condition;
            SelectorName childName = joinCondition.getChildSelectorName();
            SelectorName parentName = joinCondition.getParentSelectorName();
            if (leftSelectors.contains(childName)) {
                leftSortBy.add(childName);
                rightSortBy.add(parentName);
            } else {
                leftSortBy.add(parentName);
                rightSortBy.add(childName);
            }
        } else if (condition instanceof EquiJoinCondition) {
            EquiJoinCondition joinCondition = (EquiJoinCondition)condition;
            SelectorName selector1 = joinCondition.getSelector1Name();
            SelectorName selector2 = joinCondition.getSelector2Name();
            String property1 = joinCondition.getProperty1Name();
            String property2 = joinCondition.getProperty2Name();
            PropertyValue operand1 = new PropertyValue(selector1, property1);
            Ordering ordering1 = new Ordering(operand1, Order.ASCENDING);
            PropertyValue operand2 = new PropertyValue(selector2, property2);
            Ordering ordering2 = new Ordering(operand2, Order.ASCENDING);
            if (leftSelectors.contains(selector1)) {
                leftSortBy.add(ordering1);
                rightSortBy.add(ordering2);
            } else {
                leftSortBy.add(ordering2);
                rightSortBy.add(ordering1);
            }
        } else {
            assert (false);
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

