/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.plan.PlanUtil;
import org.modeshape.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ReplaceAliases
implements OptimizerRule {
    public static final ReplaceAliases INSTANCE = new ReplaceAliases();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        Schemata schemata = context.getSchemata();
        for (PlanNode sourceNode : plan.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
            SelectorName tableName = sourceNode.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
            SelectorName tableAlias = sourceNode.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class);
            if (tableAlias == null) continue;
            Schemata.Table table = schemata.getTable(tableName);
            PlanUtil.ColumnMapping aliasMappings = PlanUtil.createMappingForAliased(tableAlias, table, sourceNode);
            PlanUtil.replaceViewReferences(context, sourceNode.getParent(), aliasMappings);
            sourceNode.removeProperty((Object)PlanNode.Property.SOURCE_ALIAS);
            sourceNode.getSelectors().remove(tableAlias);
            sourceNode.addSelector(tableName);
        }
        return plan;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

