/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.ArithmeticOperand;
import org.modeshape.graph.query.model.ArithmeticOperator;
import org.modeshape.graph.query.model.Between;
import org.modeshape.graph.query.model.ChildNode;
import org.modeshape.graph.query.model.ChildNodeJoinCondition;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DescendantNode;
import org.modeshape.graph.query.model.DescendantNodeJoinCondition;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.LowerCase;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.SameNode;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.UpperCase;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanUtil {
    public static List<Column> findRequiredColumns(QueryContext context, PlanNode planNode) {
        List<Column> columns = null;
        PlanNode node = planNode;
        do {
            switch (node.getType()) {
                case PROJECT: {
                    columns = node.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                    node = null;
                    break;
                }
                default: {
                    node = node.getParent();
                }
            }
        } while (node != null);
        HashSet<SelectorName> names = new HashSet<SelectorName>();
        for (PlanNode source : planNode.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
            names.add(source.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class));
            SelectorName alias = source.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class);
            if (alias == null) continue;
            names.add(alias);
        }
        RequiredColumnVisitor collectionVisitor = new RequiredColumnVisitor(names);
        if (columns != null) {
            for (Column projectedColumn : columns) {
                collectionVisitor.visit(projectedColumn);
            }
        }
        node = planNode;
        block12: do {
            switch (node.getType()) {
                case JOIN: {
                    Constraint criteria = node.getProperty(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class);
                    JoinCondition joinCondition = node.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
                    Visitors.visitAll(criteria, collectionVisitor);
                    Visitors.visitAll(joinCondition, collectionVisitor);
                    break;
                }
                case SELECT: {
                    Constraint criteria = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                    Visitors.visitAll(criteria, collectionVisitor);
                    break;
                }
                case SORT: {
                    List<Object> orderBys = node.getPropertyAsList(PlanNode.Property.SORT_ORDER_BY, Object.class);
                    if (orderBys == null || orderBys.isEmpty() || !(orderBys.get(0) instanceof Ordering)) continue block12;
                    for (int i = 0; i != orderBys.size(); ++i) {
                        Ordering ordering = (Ordering)orderBys.get(i);
                        Visitors.visitAll(ordering, collectionVisitor);
                    }
                    continue block12;
                }
                case PROJECT: {
                    if (node == planNode) break;
                    return collectionVisitor.getRequiredColumns();
                }
            }
        } while ((node = node.getParent()) != null);
        return collectionVisitor.getRequiredColumns();
    }

    public static void replaceReferencesToRemovedSource(QueryContext context, PlanNode planNode, Map<SelectorName, SelectorName> rewrittenSelectors) {
        switch (planNode.getType()) {
            case PROJECT: {
                List<Column> columns = planNode.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                for (int i = 0; i != columns.size(); ++i) {
                    Column column = columns.get(i);
                    SelectorName replacement = rewrittenSelectors.get(column.getSelectorName());
                    if (replacement == null) continue;
                    columns.set(i, new Column(replacement, column.getPropertyName(), column.getColumnName()));
                }
                break;
            }
            case SELECT: {
                Constraint constraint = planNode.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                Constraint newConstraint = PlanUtil.replaceReferencesToRemovedSource(context, constraint, rewrittenSelectors);
                if (constraint == newConstraint) break;
                planNode.setProperty(PlanNode.Property.SELECT_CRITERIA, newConstraint);
                break;
            }
            case SORT: {
                List<Object> orderBys = planNode.getPropertyAsList(PlanNode.Property.SORT_ORDER_BY, Object.class);
                if (orderBys == null || orderBys.isEmpty()) break;
                if (orderBys.get(0) instanceof SelectorName) {
                    for (int i = 0; i != orderBys.size(); ++i) {
                        SelectorName selectorName = (SelectorName)orderBys.get(i);
                        SelectorName replacement = rewrittenSelectors.get(selectorName);
                        if (replacement == null) continue;
                        orderBys.set(i, replacement);
                    }
                } else {
                    for (int i = 0; i != orderBys.size(); ++i) {
                        Ordering ordering = (Ordering)orderBys.get(i);
                        DynamicOperand operand = ordering.getOperand();
                        orderBys.set(i, PlanUtil.replaceReferencesToRemovedSource(context, operand, rewrittenSelectors));
                    }
                }
                break;
            }
            case JOIN: {
                List<Constraint> constraints;
                JoinCondition joinCondition = planNode.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
                JoinCondition newCondition = PlanUtil.replaceReferencesToRemovedSource(context, joinCondition, rewrittenSelectors);
                if (joinCondition != newCondition) {
                    planNode.setProperty(PlanNode.Property.JOIN_CONDITION, newCondition);
                }
                if ((constraints = planNode.getPropertyAsList(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class)) == null || constraints.isEmpty()) break;
                for (int i = 0; i != constraints.size(); ++i) {
                    Constraint old = constraints.get(i);
                    Constraint replacement = PlanUtil.replaceReferencesToRemovedSource(context, old, rewrittenSelectors);
                    if (replacement == old) continue;
                    constraints.set(i, replacement);
                }
                break;
            }
        }
        HashSet<SelectorName> selectorsToAdd = null;
        Iterator<SelectorName> iter = planNode.getSelectors().iterator();
        while (iter.hasNext()) {
            SelectorName replacement = rewrittenSelectors.get(iter.next());
            if (replacement == null) continue;
            iter.remove();
            if (selectorsToAdd == null) {
                selectorsToAdd = new HashSet<SelectorName>();
            }
            selectorsToAdd.add(replacement);
        }
        if (selectorsToAdd != null) {
            planNode.getSelectors().addAll(selectorsToAdd);
        }
        for (PlanNode child : planNode) {
            PlanUtil.replaceReferencesToRemovedSource(context, child, rewrittenSelectors);
        }
    }

    public static DynamicOperand replaceReferencesToRemovedSource(QueryContext context, DynamicOperand operand, Map<SelectorName, SelectorName> rewrittenSelectors) {
        if (operand instanceof FullTextSearchScore) {
            FullTextSearchScore score = (FullTextSearchScore)operand;
            SelectorName replacement = rewrittenSelectors.get(score.getSelectorName());
            if (replacement == null) {
                return score;
            }
            return new FullTextSearchScore(replacement);
        }
        if (operand instanceof Length) {
            Length operation = (Length)operand;
            PropertyValue wrapped = operation.getPropertyValue();
            SelectorName replacement = rewrittenSelectors.get(wrapped.getSelectorName());
            if (replacement == null) {
                return operand;
            }
            return new Length(new PropertyValue(replacement, wrapped.getPropertyName()));
        }
        if (operand instanceof LowerCase) {
            LowerCase operation = (LowerCase)operand;
            SelectorName replacement = rewrittenSelectors.get(operation.getSelectorName());
            if (replacement == null) {
                return operand;
            }
            return new LowerCase(PlanUtil.replaceReferencesToRemovedSource(context, operation.getOperand(), rewrittenSelectors));
        }
        if (operand instanceof UpperCase) {
            UpperCase operation = (UpperCase)operand;
            SelectorName replacement = rewrittenSelectors.get(operation.getSelectorName());
            if (replacement == null) {
                return operand;
            }
            return new UpperCase(PlanUtil.replaceReferencesToRemovedSource(context, operation.getOperand(), rewrittenSelectors));
        }
        if (operand instanceof NodeName) {
            NodeName name = (NodeName)operand;
            SelectorName replacement = rewrittenSelectors.get(name.getSelectorName());
            if (replacement == null) {
                return name;
            }
            return new NodeName(replacement);
        }
        if (operand instanceof NodeLocalName) {
            NodeLocalName name = (NodeLocalName)operand;
            SelectorName replacement = rewrittenSelectors.get(name.getSelectorName());
            if (replacement == null) {
                return name;
            }
            return new NodeLocalName(replacement);
        }
        if (operand instanceof PropertyValue) {
            PropertyValue value = (PropertyValue)operand;
            SelectorName replacement = rewrittenSelectors.get(value.getSelectorName());
            if (replacement == null) {
                return operand;
            }
            return new PropertyValue(replacement, value.getPropertyName());
        }
        if (operand instanceof NodeDepth) {
            NodeDepth depth = (NodeDepth)operand;
            SelectorName replacement = rewrittenSelectors.get(depth.getSelectorName());
            if (replacement == null) {
                return operand;
            }
            return new NodeDepth(replacement);
        }
        if (operand instanceof NodePath) {
            NodePath path = (NodePath)operand;
            SelectorName replacement = rewrittenSelectors.get(path.getSelectorName());
            if (replacement == null) {
                return operand;
            }
            return new NodePath(replacement);
        }
        return operand;
    }

    public static Constraint replaceReferencesToRemovedSource(QueryContext context, Constraint constraint, Map<SelectorName, SelectorName> rewrittenSelectors) {
        if (constraint instanceof And) {
            And and = (And)constraint;
            Constraint left = PlanUtil.replaceReferencesToRemovedSource(context, and.getLeft(), rewrittenSelectors);
            Constraint right = PlanUtil.replaceReferencesToRemovedSource(context, and.getRight(), rewrittenSelectors);
            if (left == and.getLeft() && right == and.getRight()) {
                return and;
            }
            return new And(left, right);
        }
        if (constraint instanceof Or) {
            Or or = (Or)constraint;
            Constraint left = PlanUtil.replaceReferencesToRemovedSource(context, or.getLeft(), rewrittenSelectors);
            Constraint right = PlanUtil.replaceReferencesToRemovedSource(context, or.getRight(), rewrittenSelectors);
            if (left == or.getLeft() && right == or.getRight()) {
                return or;
            }
            return new Or(left, right);
        }
        if (constraint instanceof Not) {
            Not not = (Not)constraint;
            Constraint wrapped = PlanUtil.replaceReferencesToRemovedSource(context, not.getConstraint(), rewrittenSelectors);
            if (wrapped == not.getConstraint()) {
                return not;
            }
            return new Not(wrapped);
        }
        if (constraint instanceof SameNode) {
            SameNode sameNode = (SameNode)constraint;
            SelectorName replacement = rewrittenSelectors.get(sameNode.getSelectorName());
            if (replacement == null) {
                return sameNode;
            }
            return new SameNode(replacement, sameNode.getPath());
        }
        if (constraint instanceof ChildNode) {
            ChildNode childNode = (ChildNode)constraint;
            SelectorName replacement = rewrittenSelectors.get(childNode.getSelectorName());
            if (replacement == null) {
                return childNode;
            }
            return new ChildNode(replacement, childNode.getParentPath());
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode descendantNode = (DescendantNode)constraint;
            SelectorName replacement = rewrittenSelectors.get(descendantNode.getSelectorName());
            if (replacement == null) {
                return descendantNode;
            }
            return new DescendantNode(replacement, descendantNode.getAncestorPath());
        }
        if (constraint instanceof PropertyExistence) {
            PropertyExistence existence = (PropertyExistence)constraint;
            SelectorName replacement = rewrittenSelectors.get(existence.getSelectorName());
            if (replacement == null) {
                return existence;
            }
            return new PropertyExistence(replacement, existence.getPropertyName());
        }
        if (constraint instanceof FullTextSearch) {
            FullTextSearch search = (FullTextSearch)constraint;
            SelectorName replacement = rewrittenSelectors.get(search.getSelectorName());
            if (replacement == null) {
                return search;
            }
            return new FullTextSearch(replacement, search.getPropertyName(), search.getFullTextSearchExpression());
        }
        if (constraint instanceof Between) {
            Between between = (Between)constraint;
            DynamicOperand lhs = between.getOperand();
            StaticOperand lower = between.getLowerBound();
            StaticOperand upper = between.getUpperBound();
            DynamicOperand newLhs = PlanUtil.replaceReferencesToRemovedSource(context, lhs, rewrittenSelectors);
            if (lhs == newLhs) {
                return between;
            }
            return new Between(newLhs, lower, upper, between.isLowerBoundIncluded(), between.isUpperBoundIncluded());
        }
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            DynamicOperand lhs = comparison.getOperand1();
            StaticOperand rhs = comparison.getOperand2();
            DynamicOperand newLhs = PlanUtil.replaceReferencesToRemovedSource(context, lhs, rewrittenSelectors);
            if (lhs == newLhs) {
                return comparison;
            }
            return new Comparison(newLhs, comparison.getOperator(), rhs);
        }
        return constraint;
    }

    public static JoinCondition replaceReferencesToRemovedSource(QueryContext context, JoinCondition joinCondition, Map<SelectorName, SelectorName> rewrittenSelectors) {
        if (joinCondition instanceof EquiJoinCondition) {
            EquiJoinCondition condition = (EquiJoinCondition)joinCondition;
            SelectorName replacement1 = rewrittenSelectors.get(condition.getSelector1Name());
            SelectorName replacement2 = rewrittenSelectors.get(condition.getSelector2Name());
            if (replacement1 == condition.getSelector1Name() && replacement2 == condition.getSelector2Name()) {
                return condition;
            }
            return new EquiJoinCondition(replacement1, condition.getProperty1Name(), replacement2, condition.getProperty2Name());
        }
        if (joinCondition instanceof SameNodeJoinCondition) {
            SameNodeJoinCondition condition = (SameNodeJoinCondition)joinCondition;
            SelectorName replacement1 = rewrittenSelectors.get(condition.getSelector1Name());
            SelectorName replacement2 = rewrittenSelectors.get(condition.getSelector2Name());
            if (replacement1 == condition.getSelector1Name() && replacement2 == condition.getSelector2Name()) {
                return condition;
            }
            return new SameNodeJoinCondition(replacement1, replacement2, condition.getSelector2Path());
        }
        if (joinCondition instanceof ChildNodeJoinCondition) {
            ChildNodeJoinCondition condition = (ChildNodeJoinCondition)joinCondition;
            SelectorName childSelector = rewrittenSelectors.get(condition.getChildSelectorName());
            SelectorName parentSelector = rewrittenSelectors.get(condition.getParentSelectorName());
            if (childSelector == condition.getChildSelectorName() && parentSelector == condition.getParentSelectorName()) {
                return condition;
            }
            return new ChildNodeJoinCondition(parentSelector, childSelector);
        }
        if (joinCondition instanceof DescendantNodeJoinCondition) {
            DescendantNodeJoinCondition condition = (DescendantNodeJoinCondition)joinCondition;
            SelectorName ancestor = rewrittenSelectors.get(condition.getAncestorSelectorName());
            SelectorName descendant = rewrittenSelectors.get(condition.getDescendantSelectorName());
            if (ancestor == condition.getAncestorSelectorName() && descendant == condition.getDescendantSelectorName()) {
                return condition;
            }
            return new ChildNodeJoinCondition(ancestor, descendant);
        }
        return joinCondition;
    }

    public static void replaceViewReferences(QueryContext context, PlanNode topOfViewInPlan, ColumnMapping mappings) {
        assert (topOfViewInPlan != null);
        SelectorName viewName = mappings.getOriginalName();
        PlanNode node = topOfViewInPlan;
        LinkedList<PlanNode> potentiallyRemovableSources = new LinkedList<PlanNode>();
        block8: do {
            if (!node.getSelectors().remove(viewName)) continue;
            switch (node.getType()) {
                case PROJECT: {
                    List<Column> columns = node.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                    if (columns == null) break;
                    for (int i = 0; i != columns.size(); ++i) {
                        Column column = columns.get(i);
                        if (column.getSelectorName().equals(viewName)) {
                            String columnName = column.getPropertyName();
                            String columnAlias = column.getColumnName();
                            Column sourceColumn = mappings.getMappedColumn(columnName);
                            if (sourceColumn != null) {
                                SelectorName sourceName = sourceColumn.getSelectorName();
                                columns.set(i, new Column(sourceName, sourceColumn.getPropertyName(), columnAlias));
                                node.addSelector(sourceName);
                                continue;
                            }
                            node.addSelector(column.getSelectorName());
                            continue;
                        }
                        node.addSelector(column.getSelectorName());
                    }
                    continue block8;
                }
                case SELECT: {
                    Constraint constraint = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                    Constraint newConstraint = PlanUtil.replaceReferences(context, constraint, mappings, node);
                    if (constraint == newConstraint) break;
                    node.getSelectors().clear();
                    node.addSelectors(Visitors.getSelectorsReferencedBy(newConstraint));
                    node.setProperty(PlanNode.Property.SELECT_CRITERIA, newConstraint);
                    break;
                }
                case SOURCE: {
                    SelectorName sourceName = node.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
                    assert (sourceName.equals(sourceName));
                    potentiallyRemovableSources.add(node);
                    break;
                }
                case JOIN: {
                    Constraint newConstraint;
                    JoinCondition joinCondition = node.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
                    JoinCondition newJoinCondition = PlanUtil.replaceViewReferences(context, joinCondition, mappings, node);
                    node.getSelectors().clear();
                    node.setProperty(PlanNode.Property.JOIN_CONDITION, newJoinCondition);
                    node.addSelectors(Visitors.getSelectorsReferencedBy(newJoinCondition));
                    List<Constraint> joinConstraints = node.getPropertyAsList(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class);
                    if (joinConstraints == null || joinConstraints.isEmpty()) continue block8;
                    ArrayList<Constraint> newConstraints = new ArrayList<Constraint>(joinConstraints.size());
                    for (Constraint joinConstraint : joinConstraints) {
                        newConstraint = PlanUtil.replaceReferences(context, joinConstraint, mappings, node);
                        newConstraints.add(newConstraint);
                        node.addSelectors(Visitors.getSelectorsReferencedBy(newConstraint));
                    }
                    node.setProperty(PlanNode.Property.JOIN_CONSTRAINTS, newConstraints);
                    break;
                }
                case ACCESS: {
                    for (PlanNode child : node) {
                        node.addSelectors(child.getSelectors());
                    }
                    continue block8;
                }
                case SORT: {
                    List<Ordering> orderings = node.getPropertyAsList(PlanNode.Property.SORT_ORDER_BY, Ordering.class);
                    ArrayList<Ordering> newOrderings = new ArrayList<Ordering>(orderings.size());
                    node.getSelectors().clear();
                    for (Ordering ordering : orderings) {
                        DynamicOperand operand = ordering.getOperand();
                        DynamicOperand newOperand = PlanUtil.replaceViewReferences(context, operand, mappings, node);
                        if (newOperand != operand) {
                            ordering = new Ordering(newOperand, ordering.getOrder());
                        }
                        node.addSelectors(Visitors.getSelectorsReferencedBy(ordering));
                        newOrderings.add(ordering);
                    }
                    node.setProperty(PlanNode.Property.SORT_ORDER_BY, newOrderings);
                    break;
                }
            }
        } while ((node = node.getParent()) != null);
        for (PlanNode sourceNode : potentiallyRemovableSources) {
            boolean stillRequired = false;
            for (node = sourceNode.getParent(); node != null; node = node.getParent()) {
                if (!node.getSelectors().contains(viewName)) continue;
                stillRequired = true;
                break;
            }
            if (stillRequired) continue;
            assert (sourceNode.getParent() != null);
            sourceNode.extractFromParent();
        }
    }

    public static Constraint replaceReferences(QueryContext context, Constraint constraint, ColumnMapping mapping, PlanNode node) {
        if (constraint instanceof And) {
            And and = (And)constraint;
            Constraint left = PlanUtil.replaceReferences(context, and.getLeft(), mapping, node);
            Constraint right = PlanUtil.replaceReferences(context, and.getRight(), mapping, node);
            if (left == and.getLeft() && right == and.getRight()) {
                return and;
            }
            return new And(left, right);
        }
        if (constraint instanceof Or) {
            Or or = (Or)constraint;
            Constraint left = PlanUtil.replaceReferences(context, or.getLeft(), mapping, node);
            Constraint right = PlanUtil.replaceReferences(context, or.getRight(), mapping, node);
            if (left == or.getLeft() && right == or.getRight()) {
                return or;
            }
            return new Or(left, right);
        }
        if (constraint instanceof Not) {
            Not not = (Not)constraint;
            Constraint wrapped = PlanUtil.replaceReferences(context, not.getConstraint(), mapping, node);
            return wrapped == not.getConstraint() ? not : new Not(wrapped);
        }
        if (constraint instanceof SameNode) {
            SameNode sameNode = (SameNode)constraint;
            if (!mapping.getOriginalName().equals(sameNode.getSelectorName())) {
                return sameNode;
            }
            if (!mapping.isMappedToSingleSelector()) {
                return sameNode;
            }
            SelectorName selector = mapping.getSingleMappedSelectorName();
            node.addSelector(selector);
            return new SameNode(selector, sameNode.getPath());
        }
        if (constraint instanceof ChildNode) {
            ChildNode childNode = (ChildNode)constraint;
            if (!mapping.getOriginalName().equals(childNode.getSelectorName())) {
                return childNode;
            }
            if (!mapping.isMappedToSingleSelector()) {
                return childNode;
            }
            SelectorName selector = mapping.getSingleMappedSelectorName();
            node.addSelector(selector);
            return new ChildNode(selector, childNode.getParentPath());
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode descendantNode = (DescendantNode)constraint;
            if (!mapping.getOriginalName().equals(descendantNode.getSelectorName())) {
                return descendantNode;
            }
            if (!mapping.isMappedToSingleSelector()) {
                return descendantNode;
            }
            SelectorName selector = mapping.getSingleMappedSelectorName();
            node.addSelector(selector);
            return new DescendantNode(selector, descendantNode.getAncestorPath());
        }
        if (constraint instanceof PropertyExistence) {
            PropertyExistence existence = (PropertyExistence)constraint;
            if (!mapping.getOriginalName().equals(existence.getSelectorName())) {
                return existence;
            }
            Column sourceColumn = mapping.getMappedColumn(existence.getPropertyName());
            if (sourceColumn == null) {
                return existence;
            }
            node.addSelector(sourceColumn.getSelectorName());
            return new PropertyExistence(sourceColumn.getSelectorName(), sourceColumn.getPropertyName());
        }
        if (constraint instanceof FullTextSearch) {
            FullTextSearch search = (FullTextSearch)constraint;
            if (!mapping.getOriginalName().equals(search.getSelectorName())) {
                return search;
            }
            Column sourceColumn = mapping.getMappedColumn(search.getPropertyName());
            if (sourceColumn == null) {
                return search;
            }
            node.addSelector(sourceColumn.getSelectorName());
            return new FullTextSearch(sourceColumn.getSelectorName(), sourceColumn.getPropertyName(), search.getFullTextSearchExpression());
        }
        if (constraint instanceof Between) {
            Between between = (Between)constraint;
            DynamicOperand lhs = between.getOperand();
            StaticOperand lower = between.getLowerBound();
            StaticOperand upper = between.getUpperBound();
            DynamicOperand newLhs = PlanUtil.replaceViewReferences(context, lhs, mapping, node);
            if (lhs == newLhs) {
                return between;
            }
            return new Between(newLhs, lower, upper, between.isLowerBoundIncluded(), between.isUpperBoundIncluded());
        }
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            DynamicOperand lhs = comparison.getOperand1();
            StaticOperand rhs = comparison.getOperand2();
            DynamicOperand newLhs = PlanUtil.replaceViewReferences(context, lhs, mapping, node);
            if (lhs == newLhs) {
                return comparison;
            }
            return new Comparison(newLhs, comparison.getOperator(), rhs);
        }
        return constraint;
    }

    public static DynamicOperand replaceViewReferences(QueryContext context, DynamicOperand operand, ColumnMapping mapping, PlanNode node) {
        if (operand instanceof ArithmeticOperand) {
            ArithmeticOperand arith = (ArithmeticOperand)operand;
            DynamicOperand newLeft = PlanUtil.replaceViewReferences(context, arith.getLeft(), mapping, node);
            DynamicOperand newRight = PlanUtil.replaceViewReferences(context, arith.getRight(), mapping, node);
            return new ArithmeticOperand(newLeft, arith.getOperator(), newRight);
        }
        if (operand instanceof FullTextSearchScore) {
            FullTextSearchScore score = (FullTextSearchScore)operand;
            if (!mapping.getOriginalName().equals(score.getSelectorName())) {
                return score;
            }
            if (mapping.isMappedToSingleSelector()) {
                return new FullTextSearchScore(mapping.getSingleMappedSelectorName());
            }
            DynamicOperand composite = null;
            for (SelectorName name : mapping.getMappedSelectorNames()) {
                FullTextSearchScore mappedScore = new FullTextSearchScore(name);
                if (composite == null) {
                    composite = mappedScore;
                    continue;
                }
                composite = new ArithmeticOperand(composite, ArithmeticOperator.ADD, (DynamicOperand)mappedScore);
            }
            return composite;
        }
        if (operand instanceof Length) {
            Length operation = (Length)operand;
            return new Length((PropertyValue)PlanUtil.replaceViewReferences(context, operation.getPropertyValue(), mapping, node));
        }
        if (operand instanceof LowerCase) {
            LowerCase operation = (LowerCase)operand;
            return new LowerCase(PlanUtil.replaceViewReferences(context, operation.getOperand(), mapping, node));
        }
        if (operand instanceof UpperCase) {
            UpperCase operation = (UpperCase)operand;
            return new UpperCase(PlanUtil.replaceViewReferences(context, operation.getOperand(), mapping, node));
        }
        if (operand instanceof NodeName) {
            NodeName name = (NodeName)operand;
            if (!mapping.getOriginalName().equals(name.getSelectorName())) {
                return name;
            }
            if (!mapping.isMappedToSingleSelector()) {
                return name;
            }
            node.addSelector(mapping.getSingleMappedSelectorName());
            return new NodeName(mapping.getSingleMappedSelectorName());
        }
        if (operand instanceof NodeLocalName) {
            NodeLocalName name = (NodeLocalName)operand;
            if (!mapping.getOriginalName().equals(name.getSelectorName())) {
                return name;
            }
            if (!mapping.isMappedToSingleSelector()) {
                return name;
            }
            node.addSelector(mapping.getSingleMappedSelectorName());
            return new NodeLocalName(mapping.getSingleMappedSelectorName());
        }
        if (operand instanceof PropertyValue) {
            PropertyValue value = (PropertyValue)operand;
            if (!mapping.getOriginalName().equals(value.getSelectorName())) {
                return value;
            }
            Column sourceColumn = mapping.getMappedColumn(value.getPropertyName());
            if (sourceColumn == null) {
                return value;
            }
            node.addSelector(sourceColumn.getSelectorName());
            return new PropertyValue(sourceColumn.getSelectorName(), sourceColumn.getPropertyName());
        }
        if (operand instanceof NodeDepth) {
            NodeDepth depth = (NodeDepth)operand;
            if (!mapping.getOriginalName().equals(depth.getSelectorName())) {
                return depth;
            }
            if (!mapping.isMappedToSingleSelector()) {
                return depth;
            }
            node.addSelector(mapping.getSingleMappedSelectorName());
            return new NodeDepth(mapping.getSingleMappedSelectorName());
        }
        if (operand instanceof NodePath) {
            NodePath path = (NodePath)operand;
            if (!mapping.getOriginalName().equals(path.getSelectorName())) {
                return path;
            }
            if (!mapping.isMappedToSingleSelector()) {
                return path;
            }
            node.addSelector(mapping.getSingleMappedSelectorName());
            return new NodePath(mapping.getSingleMappedSelectorName());
        }
        return operand;
    }

    public static JoinCondition replaceViewReferences(QueryContext context, JoinCondition joinCondition, ColumnMapping mapping, PlanNode node) {
        if (joinCondition instanceof EquiJoinCondition) {
            Column sourceColumn;
            EquiJoinCondition condition = (EquiJoinCondition)joinCondition;
            SelectorName replacement1 = condition.getSelector1Name();
            SelectorName replacement2 = condition.getSelector2Name();
            String property1 = condition.getProperty1Name();
            String property2 = condition.getProperty2Name();
            if (replacement1.equals(mapping.getOriginalName()) && (sourceColumn = mapping.getMappedColumn(property1)) != null) {
                replacement1 = sourceColumn.getSelectorName();
                property1 = sourceColumn.getPropertyName();
            }
            if (replacement2.equals(mapping.getOriginalName()) && (sourceColumn = mapping.getMappedColumn(property2)) != null) {
                replacement2 = sourceColumn.getSelectorName();
                property2 = sourceColumn.getPropertyName();
            }
            if (replacement1 == condition.getSelector1Name() && replacement2 == condition.getSelector2Name()) {
                return condition;
            }
            node.addSelector(replacement1, replacement2);
            return new EquiJoinCondition(replacement1, property1, replacement2, property2);
        }
        if (!mapping.isMappedToSingleSelector()) {
            return joinCondition;
        }
        SelectorName viewName = mapping.getOriginalName();
        SelectorName sourceName = mapping.getSingleMappedSelectorName();
        if (joinCondition instanceof SameNodeJoinCondition) {
            SameNodeJoinCondition condition = (SameNodeJoinCondition)joinCondition;
            SelectorName replacement1 = condition.getSelector1Name();
            SelectorName replacement2 = condition.getSelector2Name();
            if (replacement1.equals(viewName)) {
                replacement1 = sourceName;
            }
            if (replacement2.equals(viewName)) {
                replacement2 = sourceName;
            }
            if (replacement1 == condition.getSelector1Name() && replacement2 == condition.getSelector2Name()) {
                return condition;
            }
            node.addSelector(replacement1, replacement2);
            if (condition.getSelector2Path() == null) {
                return new SameNodeJoinCondition(replacement1, replacement2);
            }
            return new SameNodeJoinCondition(replacement1, replacement2, condition.getSelector2Path());
        }
        if (joinCondition instanceof ChildNodeJoinCondition) {
            ChildNodeJoinCondition condition = (ChildNodeJoinCondition)joinCondition;
            SelectorName childSelector = condition.getChildSelectorName();
            SelectorName parentSelector = condition.getParentSelectorName();
            if (childSelector.equals(viewName)) {
                childSelector = sourceName;
            }
            if (parentSelector.equals(viewName)) {
                parentSelector = sourceName;
            }
            if (childSelector == condition.getChildSelectorName() && parentSelector == condition.getParentSelectorName()) {
                return condition;
            }
            node.addSelector(childSelector, parentSelector);
            return new ChildNodeJoinCondition(parentSelector, childSelector);
        }
        if (joinCondition instanceof DescendantNodeJoinCondition) {
            DescendantNodeJoinCondition condition = (DescendantNodeJoinCondition)joinCondition;
            SelectorName ancestor = condition.getAncestorSelectorName();
            SelectorName descendant = condition.getDescendantSelectorName();
            if (ancestor.equals(viewName)) {
                ancestor = sourceName;
            }
            if (descendant.equals(viewName)) {
                descendant = sourceName;
            }
            if (ancestor == condition.getAncestorSelectorName() && descendant == condition.getDescendantSelectorName()) {
                return condition;
            }
            node.addSelector(ancestor, descendant);
            return new ChildNodeJoinCondition(ancestor, descendant);
        }
        return joinCondition;
    }

    public static ColumnMapping createMappingFor(Schemata.View view, PlanNode viewPlan) {
        ColumnMapping mapping = new ColumnMapping(view.getName());
        PlanNode project = viewPlan.findAtOrBelow(PlanNode.Type.PROJECT);
        assert (project != null);
        List<Column> projectedColumns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
        List<Schemata.Column> viewColumns = view.getColumns();
        assert (viewColumns.size() == projectedColumns.size());
        for (int i = 0; i != viewColumns.size(); ++i) {
            Column projectedColunn = projectedColumns.get(i);
            String viewColumnName = viewColumns.get(i).getName();
            mapping.map(viewColumnName, projectedColunn);
        }
        return mapping;
    }

    public static ColumnMapping createMappingForAliased(SelectorName viewAlias, Schemata.View view, PlanNode viewPlan) {
        ColumnMapping mapping = new ColumnMapping(viewAlias);
        PlanNode project = viewPlan.findAtOrBelow(PlanNode.Type.PROJECT);
        assert (project != null);
        List<Column> projectedColumns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
        List<Schemata.Column> viewColumns = view.getColumns();
        assert (viewColumns.size() == projectedColumns.size());
        for (int i = 0; i != viewColumns.size(); ++i) {
            Column projectedColunn = projectedColumns.get(i);
            String viewColumnName = viewColumns.get(i).getName();
            mapping.map(viewColumnName, projectedColunn);
        }
        return mapping;
    }

    public static ColumnMapping createMappingForAliased(SelectorName tableAlias, Schemata.Table table, PlanNode tableSourceNode) {
        ColumnMapping mapping = new ColumnMapping(tableAlias);
        PlanNode project = tableSourceNode.findAncestor(PlanNode.Type.PROJECT);
        assert (project != null);
        List<Column> projectedColumns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
        for (int i = 0; i != projectedColumns.size(); ++i) {
            Column projectedColumn = projectedColumns.get(i);
            Column projectedColumnInTable = projectedColumns.get(i).with(table.getName());
            Schemata.Column column = table.getColumn(projectedColumnInTable.getPropertyName());
            mapping.map(column.getName(), projectedColumnInTable);
            if (projectedColumn.getColumnName() == null) continue;
            mapping.map(projectedColumn.getColumnName(), projectedColumnInTable);
        }
        return mapping;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnMapping {
        private final SelectorName originalName;
        private final Map<String, Column> mappedColumnsByOriginalColumnName = new HashMap<String, Column>();
        private final Set<SelectorName> mappedSelectorNames = new LinkedHashSet<SelectorName>();

        public ColumnMapping(SelectorName originalName) {
            this.originalName = originalName;
        }

        public void map(String originalColumnName, Column projectedColumn) {
            this.mappedColumnsByOriginalColumnName.put(originalColumnName, projectedColumn);
            this.mappedSelectorNames.add(projectedColumn.getSelectorName());
        }

        public SelectorName getOriginalName() {
            return this.originalName;
        }

        public Column getMappedColumn(String viewColumnName) {
            return this.mappedColumnsByOriginalColumnName.get(viewColumnName);
        }

        public boolean isMappedToSingleSelector() {
            return this.mappedSelectorNames.size() == 1;
        }

        public Set<SelectorName> getMappedSelectorNames() {
            return this.mappedSelectorNames;
        }

        public SelectorName getSingleMappedSelectorName() {
            return this.isMappedToSingleSelector() ? this.mappedSelectorNames.iterator().next() : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RequiredColumnVisitor
    extends Visitors.AbstractVisitor {
        private final Set<SelectorName> names;
        private final List<Column> columns = new LinkedList<Column>();
        private final Set<String> requiredColumnNames = new HashSet<String>();

        protected RequiredColumnVisitor(Set<SelectorName> names) {
            this.names = names;
        }

        @Override
        public void visit(PropertyExistence existence) {
            this.requireColumn(existence.getSelectorName(), existence.getPropertyName());
        }

        @Override
        public void visit(PropertyValue value) {
            this.requireColumn(value.getSelectorName(), value.getPropertyName());
        }

        @Override
        public void visit(EquiJoinCondition condition) {
            this.requireColumn(condition.getSelector1Name(), condition.getProperty1Name());
            this.requireColumn(condition.getSelector2Name(), condition.getProperty2Name());
        }

        @Override
        public void visit(Column column) {
            this.requireColumn(column.getSelectorName(), column.getPropertyName(), column.getColumnName());
        }

        protected void requireColumn(SelectorName selector, String propertyName) {
            this.requireColumn(selector, propertyName, null);
        }

        protected void requireColumn(SelectorName selector, String propertyName, String alias) {
            if (this.names.contains(selector)) {
                if (alias != null && !alias.equals(propertyName)) {
                    if (this.requiredColumnNames.add(propertyName) && this.requiredColumnNames.add(alias)) {
                        this.columns.add(new Column(selector, propertyName, alias));
                    }
                } else if (this.requiredColumnNames.add(propertyName)) {
                    alias = propertyName;
                    this.columns.add(new Column(selector, propertyName, alias));
                }
            }
        }

        public List<Column> getRequiredColumns() {
            return this.columns;
        }
    }
}

