/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.modeshape.graph.Location;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.BindVariableName;
import org.modeshape.graph.query.model.ChildNode;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DescendantNode;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.SameNode;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.process.DelegatingComponent;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectComponent
extends DelegatingComponent {
    private final Constraint constraint;
    private final ConstraintChecker checker;
    private final Map<String, Object> variables;

    public SelectComponent(ProcessingComponent delegate, Constraint constraint, Map<String, Object> variables) {
        this(delegate, constraint, variables, null);
    }

    public SelectComponent(ProcessingComponent delegate, Constraint constraint, Map<String, Object> variables, Analyzer analyzer) {
        super(delegate);
        this.constraint = constraint;
        this.variables = variables != null ? variables : Collections.emptyMap();
        TypeSystem types = delegate.getContext().getTypeSystem();
        Schemata schemata = delegate.getContext().getSchemata();
        this.checker = this.createChecker(types, schemata, delegate.getColumns(), this.constraint, this.variables, analyzer);
    }

    @Override
    public List<Object[]> execute() {
        List<Object[]> tuples = this.delegate().execute();
        if (!tuples.isEmpty()) {
            Iterator<Object[]> iter = tuples.iterator();
            while (iter.hasNext()) {
                if (this.checker.satisfiesConstraints(iter.next())) continue;
                iter.remove();
            }
        }
        return tuples;
    }

    protected ConstraintChecker createChecker(TypeSystem types, Schemata schemata, QueryResults.Columns columns, Constraint constraint, Map<String, Object> variables, final Analyzer analyzer) {
        if (constraint instanceof Or) {
            Or orConstraint = (Or)constraint;
            final ConstraintChecker left = this.createChecker(types, schemata, columns, orConstraint.getLeft(), variables, analyzer);
            final ConstraintChecker right = this.createChecker(types, schemata, columns, orConstraint.getRight(), variables, analyzer);
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    return left.satisfiesConstraints(tuple) || right.satisfiesConstraints(tuple);
                }
            };
        }
        if (constraint instanceof Not) {
            Not notConstraint = (Not)constraint;
            final ConstraintChecker original = this.createChecker(types, schemata, columns, notConstraint.getConstraint(), variables, analyzer);
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    return !original.satisfiesConstraints(tuple);
                }
            };
        }
        if (constraint instanceof And) {
            And andConstraint = (And)constraint;
            final ConstraintChecker left = this.createChecker(types, schemata, columns, andConstraint.getLeft(), variables, analyzer);
            final ConstraintChecker right = this.createChecker(types, schemata, columns, andConstraint.getRight(), variables, analyzer);
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    return left.satisfiesConstraints(tuple) && right.satisfiesConstraints(tuple);
                }
            };
        }
        if (constraint instanceof ChildNode) {
            ChildNode childConstraint = (ChildNode)constraint;
            final int locationIndex = columns.getLocationIndex(childConstraint.getSelectorName().getName());
            final String parentPath = childConstraint.getParentPath();
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    Location location = (Location)tuple[locationIndex];
                    assert (location.hasPath());
                    return location.getPath().getParent().equals(parentPath);
                }
            };
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode descendantNode = (DescendantNode)constraint;
            final int locationIndex = columns.getLocationIndex(descendantNode.getSelectorName().getName());
            final String ancestorPath = descendantNode.getAncestorPath();
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    Location location = (Location)tuple[locationIndex];
                    assert (location.hasPath());
                    return analyzer.isDescendantOf(location, ancestorPath);
                }
            };
        }
        if (constraint instanceof SameNode) {
            SameNode sameNode = (SameNode)constraint;
            final int locationIndex = columns.getLocationIndex(sameNode.getSelectorName().getName());
            final String path = sameNode.getPath();
            if (analyzer != null) {
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuple) {
                        Location location = (Location)tuple[locationIndex];
                        return analyzer.isSameNode(location, path);
                    }
                };
            }
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    Location location = (Location)tuple[locationIndex];
                    assert (location.hasPath());
                    return location.toString().equals(path);
                }
            };
        }
        if (constraint instanceof PropertyExistence) {
            PropertyExistence propertyExistance = (PropertyExistence)constraint;
            String selectorName = propertyExistance.getSelectorName().getName();
            final String propertyName = propertyExistance.getPropertyName();
            if (analyzer != null) {
                final int locationIndex = columns.getLocationIndex(selectorName);
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuple) {
                        Location location = (Location)tuple[locationIndex];
                        return analyzer.hasProperty(location, propertyName);
                    }
                };
            }
            final int columnIndex = columns.getColumnIndexForProperty(selectorName, propertyName);
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    return tuple[columnIndex] != null;
                }
            };
        }
        if (constraint instanceof FullTextSearch) {
            if (analyzer != null) {
                FullTextSearch search = (FullTextSearch)constraint;
                String selectorName = search.getSelectorName().getName();
                final int locationIndex = columns.getLocationIndex(selectorName);
                final String expression = search.getFullTextSearchExpression();
                if (expression == null) {
                    return new ConstraintChecker(){

                        public boolean satisfiesConstraints(Object[] tuple) {
                            return false;
                        }
                    };
                }
                final String propertyName = search.getPropertyName();
                final int scoreIndex = columns.getFullTextSearchScoreIndexFor(selectorName);
                assert (scoreIndex >= 0) : "Columns do not have room for the search scores";
                if (propertyName != null) {
                    return new ConstraintChecker(){

                        public boolean satisfiesConstraints(Object[] tuple) {
                            Location location = (Location)tuple[locationIndex];
                            if (location == null) {
                                return false;
                            }
                            double score = analyzer.hasFullText(location, propertyName, expression);
                            Double existing = (Double)tuple[scoreIndex];
                            if (existing != null) {
                                score = Math.max(existing, score);
                            }
                            tuple[scoreIndex] = new Double(score);
                            return true;
                        }
                    };
                }
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuple) {
                        Location location = (Location)tuple[locationIndex];
                        if (location == null) {
                            return false;
                        }
                        double score = analyzer.hasFullText(location, expression);
                        Double existing = (Double)tuple[scoreIndex];
                        if (existing != null) {
                            score = Math.max(existing, score);
                        }
                        tuple[scoreIndex] = new Double(score);
                        return true;
                    }
                };
            }
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    return true;
                }
            };
        }
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            ProcessingComponent.DynamicOperation dynamicOperation = this.createDynamicOperation(types, schemata, columns, comparison.getOperand1());
            Operator operator = comparison.getOperator();
            StaticOperand staticOperand = comparison.getOperand2();
            return this.createChecker(types, schemata, columns, dynamicOperation, operator, staticOperand);
        }
        if (constraint instanceof SetCriteria) {
            SetCriteria setCriteria = (SetCriteria)constraint;
            ProcessingComponent.DynamicOperation dynamicOperation = this.createDynamicOperation(types, schemata, columns, setCriteria.getLeftOperand());
            Operator operator = Operator.EQUAL_TO;
            final LinkedList<ConstraintChecker> checkers = new LinkedList<ConstraintChecker>();
            for (StaticOperand setValue : setCriteria.getRightOperands()) {
                ConstraintChecker rightChecker = this.createChecker(types, schemata, columns, dynamicOperation, operator, setValue);
                assert (rightChecker != null);
                checkers.add(rightChecker);
            }
            if (checkers.isEmpty()) {
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuple) {
                        return false;
                    }
                };
            }
            return new ConstraintChecker(){

                public boolean satisfiesConstraints(Object[] tuple) {
                    for (ConstraintChecker checker : checkers) {
                        if (!checker.satisfiesConstraints(tuple)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        assert (false);
        return null;
    }

    protected ConstraintChecker createChecker(final TypeSystem types, Schemata schemata, QueryResults.Columns columns, final ProcessingComponent.DynamicOperation dynamicOperation, Operator operator, StaticOperand staticOperand) {
        String expectedType = dynamicOperation.getExpectedType();
        Object literalValue = null;
        if (staticOperand instanceof BindVariableName) {
            BindVariableName bindVariable = (BindVariableName)staticOperand;
            String variableName = bindVariable.getVariableName();
            literalValue = this.variables.get(variableName);
        } else {
            Literal literal = (Literal)staticOperand;
            literalValue = literal.getValue();
        }
        TypeSystem.TypeFactory<?> typeFactory = types.getTypeFactory(expectedType);
        assert (typeFactory != null);
        final Comparator<?> comparator = typeFactory.getComparator();
        assert (comparator != null);
        TypeSystem.TypeFactory<?> literalFactory = types.getTypeFactory(expectedType);
        final Object rhs = literalFactory.create(literalValue);
        switch (operator) {
            case EQUAL_TO: {
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) == 0;
                    }
                };
            }
            case GREATER_THAN: {
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) > 0;
                    }
                };
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) >= 0;
                    }
                };
            }
            case LESS_THAN: {
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) < 0;
                    }
                };
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) <= 0;
                    }
                };
            }
            case NOT_EQUAL_TO: {
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuples) {
                        return comparator.compare(dynamicOperation.evaluate(tuples), rhs) != 0;
                    }
                };
            }
            case LIKE: {
                final Pattern pattern = SelectComponent.createRegexFromLikeExpression(types.asString(rhs));
                return new ConstraintChecker(){

                    public boolean satisfiesConstraints(Object[] tuples) {
                        Object tupleValue = dynamicOperation.evaluate(tuples);
                        if (tupleValue == null) {
                            return false;
                        }
                        String value = types.asString(tupleValue);
                        return pattern.matcher(value).matches();
                    }
                };
            }
        }
        assert (false);
        return null;
    }

    protected static Pattern createRegexFromLikeExpression(String likeExpression) {
        return null;
    }

    protected static interface CompareOperation {
        public boolean evaluate(Object var1, Object var2);
    }

    public static interface Analyzer {
        public int length(Object var1);

        public boolean isSameNode(Location var1, String var2);

        public boolean isDescendantOf(Location var1, String var2);

        public boolean hasProperty(Location var1, String var2);

        public double hasFullText(Location var1, String var2);

        public double hasFullText(Location var1, String var2, String var3);
    }

    public static interface ConstraintChecker {
        public boolean satisfiesConstraints(Object[] var1);
    }
}

