/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;

public class LockBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private final LockScope isDeep;
    private final long lockTimeoutInMillis;
    private Location actualLocation;

    public LockBranchRequest(Location at, String workspaceName, LockScope isDeep, long lockTimeoutInMillis) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
        this.isDeep = isDeep;
        this.lockTimeoutInMillis = lockTimeoutInMillis;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public LockScope lockScope() {
        return this.isDeep;
    }

    public long lockTimeoutInMillis() {
        return this.lockTimeoutInMillis;
    }

    public void setActualLocation(Location actualLocation) {
        this.checkNotFrozen();
        if (!this.at.equals(actualLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{actualLocation, this.at}));
        }
        assert (actualLocation != null);
        if (!actualLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{actualLocation}));
        }
        this.actualLocation = actualLocation;
    }

    public Location getActualLocation() {
        return this.actualLocation;
    }

    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.at.hasPath() && this.at.getPath().getParent().isAtOrBelow(path);
    }

    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.at;
    }

    public String changedWorkspace() {
        return this.workspaceName;
    }

    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.at, this.workspaceName, this.lockScope(), this.lockTimeoutInMillis});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            LockBranchRequest that = (LockBranchRequest)obj;
            if (this.lockTimeoutInMillis() != that.lockTimeoutInMillis()) {
                return false;
            }
            if (!this.at().isSame(that.at())) {
                return false;
            }
            if (this.lockScope() != that.lockScope()) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "lock " + (LockScope.SELF_AND_DESCENDANTS == this.lockScope() ? "branch rooted" : "node") + " at " + this.at() + " in the \"" + this.workspaceName + "\" workspace";
    }

    public LockBranchRequest clone() {
        LockBranchRequest request = new LockBranchRequest(this.actualLocation != null ? this.actualLocation : this.at, this.workspaceName, this.isDeep, this.lockTimeoutInMillis);
        request.setActualLocation(this.actualLocation);
        return request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockScope {
        SELF_ONLY,
        SELF_AND_DESCENDANTS;

    }
}

