/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request.processor;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.UpdateValuesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

@Immutable
public class LoggingRequestProcessor
extends RequestProcessor {
    private final RequestProcessor delegate;
    private final Logger logger;
    private final Logger.Level level;

    public LoggingRequestProcessor(RequestProcessor delegate, Logger logger, Logger.Level level) {
        super(delegate.getSourceName(), delegate.getExecutionContext(), null);
        CheckArg.isNotNull((Object)logger, (String)"logger");
        this.delegate = delegate;
        this.logger = logger;
        this.level = level != null ? level : Logger.Level.TRACE;
    }

    public void process(VerifyWorkspaceRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
    }

    public void process(GetWorkspacesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CreateWorkspaceRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CloneBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CloneWorkspaceRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(DestroyWorkspaceRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CopyBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CreateNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(DeleteBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(DeleteChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(MoveBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(VerifyNodeExistsRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadAllChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadAllPropertiesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(UpdatePropertiesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(UpdateValuesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CompositeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadBlockOfChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadPropertyRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(SetPropertyRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(RemovePropertyRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(RenameNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(LockBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(UnlockBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(AccessQueryRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(FullTextSearchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(Request request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void close() {
        this.logger.log(this.level, GraphI18n.closingRequestProcessor, new Object[0]);
        this.delegate.close();
        this.logger.log(this.level, GraphI18n.closedRequestProcessor, new Object[0]);
    }
}

