/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.ReferenceValue;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.plan.PlanUtil;

@Immutable
public class RaiseSelectCriteria
implements OptimizerRule {
    public static final RaiseSelectCriteria INSTANCE = new RaiseSelectCriteria();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        HashSet<PlanNode> copiedSelectNodes = new HashSet<PlanNode>();
        for (PlanNode join : plan.findAllAtOrBelow(PlanNode.Type.JOIN)) {
            JoinCondition joinCondition = join.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
            if (!(joinCondition instanceof EquiJoinCondition)) continue;
            EquiJoinCondition equiJoinCondition = (EquiJoinCondition)joinCondition;
            SelectorName selector1 = equiJoinCondition.getSelector1Name();
            SelectorName selector2 = equiJoinCondition.getSelector2Name();
            String property1 = equiJoinCondition.getProperty1Name();
            String property2 = equiJoinCondition.getProperty2Name();
            for (PlanNode node = join.getParent(); node != null; node = node.getParent()) {
                if (copiedSelectNodes.contains(node)) continue;
                PlanNode copy = this.copySelectNode(context, node, selector1, property1, selector2, property2);
                if (copy != null) {
                    node.insertAsParent(copy);
                    copiedSelectNodes.add(node);
                    copiedSelectNodes.add(copy);
                    continue;
                }
                copy = this.copySelectNode(context, node, selector2, property2, selector1, property1);
                if (copy == null) continue;
                node.insertAsParent(copy);
                copiedSelectNodes.add(node);
                copiedSelectNodes.add(copy);
            }
        }
        return plan;
    }

    protected PlanNode copySelectNode(QueryContext context, PlanNode selectNode, SelectorName selectorName, String propertyName, SelectorName copySelectorName, String copyPropertyName) {
        if (selectNode.isNot(PlanNode.Type.SELECT)) {
            return null;
        }
        if (selectNode.getSelectors().size() != 1 || !selectNode.getSelectors().contains(selectorName)) {
            return null;
        }
        Constraint constraint = selectNode.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
        Set<Column> columns = RaiseSelectCriteria.getColumnsReferencedBy(constraint);
        if (columns.size() != 1) {
            return null;
        }
        Column column = columns.iterator().next();
        if (!column.getSelectorName().equals(selectorName)) {
            return null;
        }
        if (!column.getPropertyName().equals(propertyName)) {
            return null;
        }
        PlanNode copy = new PlanNode(PlanNode.Type.SELECT, copySelectorName);
        PlanUtil.ColumnMapping mappings = new PlanUtil.ColumnMapping(selectorName);
        mappings.map(propertyName, new Column(copySelectorName, copyPropertyName, copyPropertyName));
        Constraint newCriteria = PlanUtil.replaceReferences(context, constraint, mappings, copy);
        copy.setProperty(PlanNode.Property.SELECT_CRITERIA, newCriteria);
        return copy;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static Set<Column> getColumnsReferencedBy(Visitable visitable) {
        if (visitable == null) {
            return Collections.emptySet();
        }
        final HashSet<Column> symbols = new HashSet<Column>();
        Visitors.visitAll(visitable, new Visitors.AbstractVisitor(){

            protected void addColumnFor(SelectorName selectorName, String property) {
                symbols.add(new Column(selectorName, property, property));
            }

            @Override
            public void visit(Column column) {
                symbols.add(column);
            }

            @Override
            public void visit(EquiJoinCondition joinCondition) {
                this.addColumnFor(joinCondition.getSelector1Name(), joinCondition.getProperty1Name());
                this.addColumnFor(joinCondition.getSelector2Name(), joinCondition.getProperty2Name());
            }

            @Override
            public void visit(PropertyExistence prop) {
                this.addColumnFor(prop.getSelectorName(), prop.getPropertyName());
            }

            @Override
            public void visit(PropertyValue prop) {
                this.addColumnFor(prop.getSelectorName(), prop.getPropertyName());
            }

            @Override
            public void visit(ReferenceValue ref) {
                String propertyName = ref.getPropertyName();
                if (propertyName != null) {
                    this.addColumnFor(ref.getSelectorName(), propertyName);
                }
            }
        });
        return symbols;
    }
}

