/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.validate;

import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.ArithmeticOperand;
import org.modeshape.graph.query.model.ChildNode;
import org.modeshape.graph.query.model.ChildNodeJoinCondition;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.DescendantNode;
import org.modeshape.graph.query.model.DescendantNodeJoinCondition;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.LowerCase;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.ReferenceValue;
import org.modeshape.graph.query.model.SameNode;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.validate.Schemata;

public class Validator
extends Visitors.AbstractVisitor {
    private final QueryContext context;
    private final Problems problems;
    private final Map<SelectorName, Schemata.Table> selectorsByNameOrAlias;
    private final Map<SelectorName, Schemata.Table> selectorsByName;
    private final Map<String, Schemata.Column> columnsByAlias;
    private final boolean validateColumnExistence;

    public Validator(QueryContext context, Map<SelectorName, Schemata.Table> selectorsByName) {
        this.context = context;
        this.problems = this.context.getProblems();
        this.selectorsByNameOrAlias = selectorsByName;
        this.selectorsByName = new HashMap<SelectorName, Schemata.Table>();
        for (Schemata.Table table : selectorsByName.values()) {
            this.selectorsByName.put(table.getName(), table);
        }
        this.columnsByAlias = new HashMap<String, Schemata.Column>();
        this.validateColumnExistence = context.getHints().validateColumnExistance;
    }

    @Override
    public void visit(AllNodes obj) {
        this.verifyTable(obj.getName());
    }

    @Override
    public void visit(ArithmeticOperand obj) {
        this.verifyArithmeticOperand(obj.getLeft());
        this.verifyArithmeticOperand(obj.getRight());
    }

    protected void verifyArithmeticOperand(DynamicOperand operand) {
        if (!(operand instanceof NodeDepth || operand instanceof Length || operand instanceof ArithmeticOperand || operand instanceof FullTextSearchScore)) {
            if (operand instanceof PropertyValue) {
                String propertyName;
                PropertyValue value = (PropertyValue)operand;
                SelectorName selector = value.getSelectorName();
                Schemata.Column column = this.verify(selector, propertyName = value.getPropertyName(), this.validateColumnExistence);
                if (column != null) {
                    String columnType = column.getPropertyType();
                    TypeSystem types = this.context.getTypeSystem();
                    String longType = types.getLongFactory().getTypeName();
                    String doubleType = types.getDoubleFactory().getTypeName();
                    if (!longType.equals(types.getCompatibleType(columnType, longType)) && !doubleType.equals(types.getCompatibleType(columnType, doubleType))) {
                        I18n msg = GraphI18n.columnTypeCannotBeUsedInArithmeticOperation;
                        this.problems.addError(msg, new Object[]{selector, propertyName, columnType});
                    }
                }
            } else {
                I18n msg = GraphI18n.dynamicOperandCannotBeUsedInArithmeticOperation;
                this.problems.addError(msg, new Object[]{operand});
            }
        }
    }

    @Override
    public void visit(ChildNode obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(ChildNodeJoinCondition obj) {
        this.verify(obj.getParentSelectorName());
        this.verify(obj.getChildSelectorName());
    }

    @Override
    public void visit(Column obj) {
        this.verify(obj.getSelectorName(), obj.getPropertyName(), true);
    }

    @Override
    public void visit(DescendantNode obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(DescendantNodeJoinCondition obj) {
        this.verify(obj.getAncestorSelectorName());
        this.verify(obj.getDescendantSelectorName());
    }

    @Override
    public void visit(EquiJoinCondition obj) {
        this.verify(obj.getSelector1Name(), obj.getProperty1Name(), true);
        this.verify(obj.getSelector2Name(), obj.getProperty2Name(), true);
    }

    @Override
    public void visit(FullTextSearch obj) {
        SelectorName selectorName = obj.getSelectorName();
        if (obj.getPropertyName() != null) {
            Schemata.Column column = this.verify(selectorName, obj.getPropertyName(), this.validateColumnExistence);
            if (column != null && !column.isFullTextSearchable()) {
                this.problems.addError(GraphI18n.columnIsNotFullTextSearchable, new Object[]{column.getName(), selectorName});
            }
        } else {
            Schemata.Table table = this.verify(selectorName);
            if (table != null && !AllNodes.ALL_NODES_NAME.equals(table.getName())) {
                boolean searchable = false;
                for (Schemata.Column column : table.getColumns()) {
                    if (!column.isFullTextSearchable()) continue;
                    searchable = true;
                    break;
                }
                if (!searchable) {
                    this.problems.addError(GraphI18n.tableIsNotFullTextSearchable, new Object[]{selectorName});
                }
            }
        }
    }

    @Override
    public void visit(FullTextSearchScore obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(Length obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(LowerCase obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(NamedSelector obj) {
        this.verify(obj.getAliasOrName());
    }

    @Override
    public void visit(NodeDepth obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(NodeLocalName obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(NodeName obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(NodePath obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(PropertyExistence obj) {
        this.verify(obj.getSelectorName(), obj.getPropertyName(), this.validateColumnExistence);
    }

    @Override
    public void visit(PropertyValue obj) {
        this.verify(obj.getSelectorName(), obj.getPropertyName(), this.validateColumnExistence);
    }

    @Override
    public void visit(ReferenceValue obj) {
        String propName = obj.getPropertyName();
        if (propName != null) {
            this.verify(obj.getSelectorName(), propName, this.validateColumnExistence);
        } else {
            this.verify(obj.getSelectorName());
        }
    }

    @Override
    public void visit(Query obj) {
        this.columnsByAlias.clear();
        for (Column column : obj.getColumns()) {
            Schemata.Column tableColumn;
            Schemata.Table table = this.tableWithNameOrAlias(column.getSelectorName());
            if (table == null || (tableColumn = table.getColumn(column.getPropertyName())) == null) continue;
            this.columnsByAlias.put(column.getColumnName(), tableColumn);
        }
        super.visit(obj);
    }

    @Override
    public void visit(SameNode obj) {
        this.verify(obj.getSelectorName());
    }

    @Override
    public void visit(SameNodeJoinCondition obj) {
        this.verify(obj.getSelector1Name());
        this.verify(obj.getSelector2Name());
    }

    protected Schemata.Table tableWithNameOrAlias(SelectorName tableName) {
        Schemata.Table table = this.selectorsByNameOrAlias.get(tableName);
        if (table == null) {
            table = this.selectorsByName.get(tableName);
        }
        return table;
    }

    protected Schemata.Table verify(SelectorName selectorName) {
        Schemata.Table table = this.tableWithNameOrAlias(selectorName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{selectorName.getName()});
        }
        return table;
    }

    protected Schemata.Table verifyTable(SelectorName tableName) {
        Schemata.Table table = this.tableWithNameOrAlias(tableName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{tableName.getName()});
        }
        return table;
    }

    protected Schemata.Column verify(SelectorName selectorName, String propertyName, boolean columnIsRequired) {
        Schemata.Table table = this.tableWithNameOrAlias(selectorName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{selectorName.getName()});
            return null;
        }
        Schemata.Column column = table.getColumn(propertyName);
        if (column == null && (column = this.columnsByAlias.get(propertyName)) == null && columnIsRequired) {
            this.problems.addError(GraphI18n.columnDoesNotExistOnTable, new Object[]{propertyName, selectorName.getName()});
        }
        return column;
    }
}

