/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;

public class RenameNodeRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private final Name newName;
    private Location actualOldLocation;
    private Location actualNewLocation;

    public RenameNodeRequest(Location at, String workspaceName, Name newName) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)newName, (String)"newName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
        this.newName = newName;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name toName() {
        return this.newName;
    }

    public void setActualLocations(Location oldLocation, Location newLocation) {
        this.checkNotFrozen();
        if (!this.at.equals(oldLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{oldLocation, this.at}));
        }
        assert (oldLocation != null);
        if (newLocation == null) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{newLocation, this.at}));
        }
        if (!oldLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{oldLocation}));
        }
        if (!newLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(new Object[]{newLocation}));
        }
        Path newPath = newLocation.getPath();
        if (!newPath.getParent().equals(oldLocation.getPath().getParent())) {
            String msg = GraphI18n.actualNewLocationMustHaveSameParentAsOldLocation.text(new Object[]{newLocation, oldLocation});
            throw new IllegalArgumentException(msg);
        }
        if (!newPath.getLastSegment().getName().equals(this.toName())) {
            String msg = GraphI18n.actualNewLocationMustHaveSameNameAsRequest.text(new Object[]{newLocation, this.toName()});
            throw new IllegalArgumentException(msg);
        }
        this.actualOldLocation = oldLocation;
        this.actualNewLocation = newLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualOldLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualNewLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.at.hasPath() && this.at.getPath().getParent().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.actualNewLocation != null ? this.actualNewLocation : this.at;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualNewLocation = null;
        this.actualOldLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.at, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            RenameNodeRequest that = (RenameNodeRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            if (!this.toName().equals(that.toName())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "rename node at " + this.at() + " in the \"" + this.workspaceName + "\" workspace to " + this.toName();
    }

    @Override
    public RenameNodeRequest clone() {
        RenameNodeRequest request = new RenameNodeRequest(this.actualOldLocation != null ? this.actualOldLocation : this.at, this.workspaceName, this.newName);
        request.setActualLocations(this.actualOldLocation, this.actualNewLocation);
        return request;
    }
}

