/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.Readable;

public enum Order implements Readable
{
    ASCENDING("ASC"),
    DESCENDING("DESC");

    private final String symbol;

    private Order(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static Order forSymbol(String symbol) {
        CheckArg.isNotNull((Object)symbol, (String)"symbol");
        if (ASCENDING.getSymbol().equalsIgnoreCase(symbol)) {
            return ASCENDING;
        }
        if (DESCENDING.getSymbol().equalsIgnoreCase(symbol)) {
            return DESCENDING;
        }
        return null;
    }

    @Override
    public String getString() {
        return this.getSymbol();
    }
}

