/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class ReferenceValue
extends DynamicOperand {
    private static final long serialVersionUID = 1L;
    private final String propertyName;
    private final int hc;

    public ReferenceValue(SelectorName selectorName) {
        super(selectorName);
        this.propertyName = null;
        this.hc = HashCode.compute((Object[])new Object[]{selectorName, this.propertyName});
    }

    public ReferenceValue(SelectorName selectorName, String propertyName) {
        super(selectorName);
        this.propertyName = propertyName;
        this.hc = HashCode.compute((Object[])new Object[]{selectorName, this.propertyName});
    }

    public SelectorName getSelectorName() {
        return this.getSelectorNames().iterator().next();
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReferenceValue) {
            ReferenceValue that = (ReferenceValue)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!((Object)this.getSelectorNames()).equals(that.getSelectorNames())) {
                return false;
            }
            if (this.propertyName != null) {
                return this.propertyName.equals(that.propertyName);
            }
            return that.propertyName == null;
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

