/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.validate.ImmutableColumn;
import org.modeshape.graph.query.validate.ImmutableKey;
import org.modeshape.graph.query.validate.Schemata;

@Immutable
class ImmutableTable
implements Schemata.Table {
    private final SelectorName name;
    private final Map<String, Schemata.Column> columnsByName;
    private final List<Schemata.Column> columns;
    private final Set<Schemata.Key> keys;

    protected ImmutableTable(SelectorName name, Iterable<Schemata.Column> columns) {
        this(name, columns, (Iterable[])null);
    }

    protected ImmutableTable(SelectorName name, Iterable<Schemata.Column> columns, Iterable<Schemata.Column> ... keyColumns) {
        this.name = name;
        LinkedList<Schemata.Column> columnList = new LinkedList<Schemata.Column>();
        HashMap<String, Schemata.Column> columnMap = new HashMap<String, Schemata.Column>();
        for (Schemata.Column column : columns) {
            Schemata.Column old = columnMap.put(column.getName(), column);
            if (old != null) {
                columnList.set(columnList.indexOf(old), column);
                continue;
            }
            columnList.add(column);
        }
        this.columnsByName = Collections.unmodifiableMap(columnMap);
        this.columns = Collections.unmodifiableList(columnList);
        if (keyColumns != null) {
            HashSet<ImmutableKey> keys = new HashSet<ImmutableKey>();
            for (Iterable<Schemata.Column> keyColumnSet : keyColumns) {
                if (keyColumnSet == null) continue;
                ImmutableKey key = new ImmutableKey(keyColumnSet);
                keys.add(key);
            }
            this.keys = Collections.unmodifiableSet(keys);
        } else {
            this.keys = Collections.emptySet();
        }
    }

    protected ImmutableTable(SelectorName name, Map<String, Schemata.Column> columnsByName, List<Schemata.Column> columns, Set<Schemata.Key> keys) {
        this.name = name;
        this.columns = columns;
        this.columnsByName = columnsByName;
        this.keys = keys;
    }

    @Override
    public SelectorName getName() {
        return this.name;
    }

    @Override
    public Schemata.Column getColumn(String name) {
        return this.columnsByName.get(name);
    }

    @Override
    public List<Schemata.Column> getColumns() {
        return this.columns;
    }

    @Override
    public Map<String, Schemata.Column> getColumnsByName() {
        return this.columnsByName;
    }

    @Override
    public Collection<Schemata.Key> getKeys() {
        return this.keys;
    }

    @Override
    public Schemata.Key getKey(Schemata.Column ... columns) {
        for (Schemata.Key key : this.keys) {
            if (!key.hasColumns(columns)) continue;
            return key;
        }
        return null;
    }

    @Override
    public Schemata.Key getKey(Iterable<Schemata.Column> columns) {
        for (Schemata.Key key : this.keys) {
            if (!key.hasColumns(columns)) continue;
            return key;
        }
        return null;
    }

    @Override
    public boolean hasKey(Schemata.Column ... columns) {
        return this.getKey(columns) != null;
    }

    @Override
    public boolean hasKey(Iterable<Schemata.Column> columns) {
        return this.getKey(columns) != null;
    }

    public ImmutableTable withColumn(String name, String type) {
        LinkedList<Schemata.Column> newColumns = new LinkedList<Schemata.Column>(this.columns);
        newColumns.add(new ImmutableColumn(name, type));
        return new ImmutableTable(this.getName(), newColumns);
    }

    public ImmutableTable withColumn(String name, String type, boolean fullTextSearchable) {
        LinkedList<Schemata.Column> newColumns = new LinkedList<Schemata.Column>(this.columns);
        newColumns.add(new ImmutableColumn(name, type, fullTextSearchable));
        return new ImmutableTable(this.getName(), newColumns);
    }

    public ImmutableTable withColumns(Iterable<Schemata.Column> columns) {
        LinkedList<Schemata.Column> newColumns = new LinkedList<Schemata.Column>(this.getColumns());
        for (Schemata.Column column : columns) {
            newColumns.add(new ImmutableColumn(column.getName(), column.getPropertyType(), column.isFullTextSearchable()));
        }
        return new ImmutableTable(this.getName(), newColumns);
    }

    public ImmutableTable with(SelectorName name) {
        return new ImmutableTable(name, this.columnsByName, this.columns, this.keys);
    }

    public ImmutableTable withKey(Iterable<Schemata.Column> keyColumns) {
        HashSet<Schemata.Key> keys = new HashSet<Schemata.Key>(this.keys);
        for (Schemata.Column keyColumn : keyColumns) {
            assert (this.columns.contains(keyColumn));
        }
        if (!keys.add(new ImmutableKey(keyColumns))) {
            return this;
        }
        return new ImmutableTable(this.name, this.columnsByName, this.columns, keys);
    }

    public ImmutableTable withKey(Schemata.Column ... keyColumns) {
        return this.withKey(Arrays.asList(keyColumns));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name.getName());
        sb.append('(');
        boolean first = true;
        for (Schemata.Column column : this.columns) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(')');
        if (!this.keys.isEmpty()) {
            sb.append(" with keys ");
            first = true;
            for (Schemata.Key key : this.keys) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(key);
            }
        }
        return sb.toString();
    }
}

