/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;

public final class CreateWorkspaceRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    public static final CreateConflictBehavior DEFAULT_CREATE_CONFLICT_BEHAVIOR = CreateConflictBehavior.DO_NOT_CREATE;
    private final String desiredNameOfNewWorkspace;
    private final CreateConflictBehavior createConflictBehavior;
    private String actualWorkspaceName;
    private Location actualLocationOfRoot;

    public CreateWorkspaceRequest(String desiredNameOfNewWorkspace, CreateConflictBehavior createConflictBehavior) {
        CheckArg.isNotNull((Object)desiredNameOfNewWorkspace, (String)"desiredNameOfNewWorkspace");
        this.desiredNameOfNewWorkspace = desiredNameOfNewWorkspace;
        this.createConflictBehavior = createConflictBehavior != null ? createConflictBehavior : DEFAULT_CREATE_CONFLICT_BEHAVIOR;
    }

    public String desiredNameOfNewWorkspace() {
        return this.desiredNameOfNewWorkspace;
    }

    public CreateConflictBehavior conflictBehavior() {
        return this.createConflictBehavior;
    }

    public String getActualWorkspaceName() {
        return this.actualWorkspaceName;
    }

    public void setActualWorkspaceName(String actualWorkspaceName) {
        this.checkNotFrozen();
        this.actualWorkspaceName = actualWorkspaceName;
    }

    public Location getActualLocationOfRoot() {
        return this.actualLocationOfRoot;
    }

    public void setActualRootLocation(Location actualLocationOfRoot) {
        this.checkNotFrozen();
        this.actualLocationOfRoot = actualLocationOfRoot;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualWorkspaceName = null;
        this.actualLocationOfRoot = null;
    }

    public int hashCode() {
        return this.desiredNameOfNewWorkspace.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CreateWorkspaceRequest that = (CreateWorkspaceRequest)obj;
            return this.desiredNameOfNewWorkspace.equals(that.desiredNameOfNewWorkspace());
        }
        return false;
    }

    public String toString() {
        return "create new workspace \"" + this.desiredNameOfNewWorkspace() + "\"";
    }

    @Override
    public Location changedLocation() {
        return this.actualLocationOfRoot;
    }

    @Override
    public String changedWorkspace() {
        return this.actualWorkspaceName;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.actualWorkspaceName != null && this.actualWorkspaceName.equals(workspace);
    }

    @Override
    public CreateWorkspaceRequest clone() {
        CreateWorkspaceRequest request = new CreateWorkspaceRequest(this.actualWorkspaceName != null ? this.actualWorkspaceName : this.desiredNameOfNewWorkspace, this.createConflictBehavior);
        request.setActualWorkspaceName(this.actualWorkspaceName);
        request.setActualRootLocation(this.actualLocationOfRoot);
        return request;
    }

    public static enum CreateConflictBehavior {
        DO_NOT_CREATE,
        CREATE_WITH_ADJUSTED_NAME;

    }
}

