/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;

public class MoveBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    public static final NodeConflictBehavior DEFAULT_CONFLICT_BEHAVIOR = NodeConflictBehavior.APPEND;
    private final Location from;
    private final Location into;
    private final Location before;
    private final String workspaceName;
    private final Name desiredNameForNode;
    private final NodeConflictBehavior conflictBehavior;
    private Location actualOldLocation;
    private Location actualNewLocation;

    public MoveBranchRequest(Location from, Location into, String workspaceName) {
        this(from, into, null, workspaceName, null, DEFAULT_CONFLICT_BEHAVIOR);
    }

    public MoveBranchRequest(Location from, Location into, String workspaceName, Name newNameForMovedNode) {
        this(from, into, null, workspaceName, newNameForMovedNode, DEFAULT_CONFLICT_BEHAVIOR);
    }

    public MoveBranchRequest(Location from, Location into, String workspaceName, NodeConflictBehavior conflictBehavior) {
        this(from, into, null, workspaceName, null, conflictBehavior);
    }

    public MoveBranchRequest(Location from, Location into, Location before, String workspaceName, Name newNameForMovedNode, NodeConflictBehavior conflictBehavior) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        this.from = from;
        this.into = into;
        this.before = before;
        this.workspaceName = workspaceName;
        this.desiredNameForNode = newNameForMovedNode;
        this.conflictBehavior = conflictBehavior;
    }

    public Location from() {
        return this.from;
    }

    public Location into() {
        return this.into;
    }

    public Location before() {
        return this.before;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name desiredName() {
        return this.desiredNameForNode;
    }

    public NodeConflictBehavior conflictBehavior() {
        return this.conflictBehavior;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean hasNoEffect() {
        if (this.into != null && this.into.hasPath() && !this.into.hasIdProperties() && this.from.hasPath()) {
            if (!this.from.getPath().getParent().equals(this.into.getPath())) {
                return false;
            }
            if (this.desiredName() != null && !this.desiredName().equals(this.from.getPath().getLastSegment().getName())) {
                return false;
            }
            return this.before == null;
        }
        return false;
    }

    public void setActualLocations(Location oldLocation, Location newLocation) {
        Name expectedNewName;
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)oldLocation, (String)"oldLocation");
        CheckArg.isNotNull((Object)newLocation, (String)"newLocation");
        if (!this.from.equals(oldLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{oldLocation, this.from}));
        }
        if (!oldLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{oldLocation}));
        }
        if (!newLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(new Object[]{newLocation}));
        }
        if (this.into() != null && this.into().hasPath() && !newLocation.getPath().getParent().isSameAs(this.into.getPath())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{newLocation, this.into}));
        }
        Name actualNewName = newLocation.getPath().getLastSegment().getName();
        Name name = expectedNewName = this.desiredName() != null ? this.desiredName() : oldLocation.getPath().getLastSegment().getName();
        if (!actualNewName.equals(expectedNewName)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{newLocation, this.into}));
        }
        this.actualOldLocation = oldLocation;
        this.actualNewLocation = newLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualOldLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualNewLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        if (this.into() != null) {
            return this.workspaceName.equals(workspace) && (this.into.hasPath() && this.into.getPath().isAtOrBelow(path) || this.from.hasPath() && this.from.getPath().isAtOrBelow(path));
        }
        assert (this.before() != null);
        return this.workspaceName.equals(workspace) && (this.before.hasPath() && this.before.getPath().getParent().isAtOrBelow(path) || this.from.hasPath() && this.from.getPath().isAtOrBelow(path));
    }

    @Override
    public Location changedLocation() {
        return this.actualNewLocation != null ? this.actualNewLocation : (this.into != null ? this.into : this.before);
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualOldLocation = null;
        this.actualNewLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.from, this.workspaceName, this.into});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            MoveBranchRequest that = (MoveBranchRequest)obj;
            if (!this.from().isSame(that.from())) {
                return false;
            }
            if (!this.into().isSame(that.into())) {
                return false;
            }
            if (!this.conflictBehavior().equals((Object)that.conflictBehavior())) {
                return false;
            }
            return this.workspaceName.equals(that.workspaceName);
        }
        return false;
    }

    public String toString() {
        if (this.desiredName() != null) {
            return "move branch " + this.from() + " in the \"" + this.inWorkspace() + "\" workspace " + (this.into() == null ? "before " + this.before() : "into " + this.into()) + " with name " + this.desiredName();
        }
        return "move branch " + this.from() + " in the \"" + this.inWorkspace() + "\" workspace into " + (this.into() == null ? "before " + this.before() : "into " + this.into());
    }

    @Override
    public MoveBranchRequest clone() {
        MoveBranchRequest request = new MoveBranchRequest(this.actualOldLocation != null ? this.actualOldLocation : this.from, this.into, this.before, this.workspaceName, this.desiredNameForNode, this.conflictBehavior);
        request.setActualLocations(this.actualOldLocation, this.actualNewLocation);
        return request;
    }
}

