/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.LinkedList;
import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CacheableRequest;

public class ReadNextBlockOfChildrenRequest
extends CacheableRequest {
    public static final int INDEX_NOT_USED = -1;
    private static final long serialVersionUID = 1L;
    private final List<Location> children = new LinkedList<Location>();
    private final Location startingAfter;
    private final String workspaceName;
    private final int count;
    private Location actualStartingAfter;

    public ReadNextBlockOfChildrenRequest(Location startingAfter, String workspaceName, int count) {
        CheckArg.isNotNull((Object)startingAfter, (String)"startingAfter");
        CheckArg.isPositive((int)count, (String)"count");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.startingAfter = startingAfter;
        this.count = count;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public int count() {
        return this.count;
    }

    public Location startingAfter() {
        return this.startingAfter;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public List<Location> getChildren() {
        return this.children;
    }

    public void addChildren(Iterable<Location> children) {
        this.checkNotFrozen();
        CheckArg.isNotNull(children, (String)"children");
        for (Location child : children) {
            if (child == null) continue;
            this.children.add(child);
        }
    }

    public void addChild(Location child) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)child, (String)"child");
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, firstIdProperty, remainingIdProperties);
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property idProperty) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, idProperty);
        this.children.add(child);
    }

    public void setActualLocationOfStartingAfterNode(Location actual) {
        this.checkNotFrozen();
        if (!this.startingAfter.equals(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{actual, this.startingAfter}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualStartingAfter = actual;
    }

    public Location getActualLocationOfStartingAfterNode() {
        return this.actualStartingAfter;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualStartingAfter = null;
        this.children.clear();
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.startingAfter, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadNextBlockOfChildrenRequest that = (ReadNextBlockOfChildrenRequest)obj;
            if (!this.startingAfter().isSame(that.startingAfter())) {
                return false;
            }
            if (this.count() != that.count()) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        if (this.count() == 1) {
            return "read the next child after " + this.startingAfter() + " in the \"" + this.workspaceName + "\" workspace";
        }
        return "read the next " + this.count() + " children after " + this.startingAfter() + " in the \"" + this.workspaceName + "\" workspace";
    }
}

