/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.Reflection;
import org.modeshape.graph.SecurityContext;

@NotThreadSafe
public final class JaasSecurityContext
implements SecurityContext {
    private static final Logger LOGGER = Logger.getLogger(JaasSecurityContext.class);
    private final LoginContext loginContext;
    private final String userName;
    private final Set<String> entitlements;
    private boolean loggedIn;

    public JaasSecurityContext(String realmName) throws LoginException {
        this(new LoginContext(realmName));
    }

    public JaasSecurityContext(String realmName, Subject subject) throws LoginException {
        this(new LoginContext(realmName, subject));
    }

    public JaasSecurityContext(String realmName, String userId, char[] password) throws LoginException {
        this(new LoginContext(realmName, new UserPasswordCallbackHandler(userId, password)));
    }

    public JaasSecurityContext(String realmName, CallbackHandler callbackHandler) throws LoginException {
        this(new LoginContext(realmName, callbackHandler));
    }

    public JaasSecurityContext(LoginContext loginContext) throws LoginException {
        CheckArg.isNotNull((Object)loginContext, (String)"loginContext");
        this.entitlements = new HashSet<String>();
        this.loginContext = loginContext;
        if (this.loginContext.getSubject() == null) {
            this.loginContext.login();
        }
        this.userName = this.initialize(loginContext.getSubject());
        this.loggedIn = true;
    }

    public JaasSecurityContext(Subject subject) {
        CheckArg.isNotNull((Object)subject, (String)"subject");
        this.loginContext = null;
        this.entitlements = new HashSet<String>();
        this.userName = this.initialize(subject);
        this.loggedIn = true;
    }

    private String initialize(Subject subject) {
        String userName = null;
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                if (principal instanceof Group) {
                    Group group = (Group)principal;
                    Enumeration roles = group.members();
                    while (roles.hasMoreElements()) {
                        Principal role = (Principal)roles.nextElement();
                        this.entitlements.add(role.getName());
                    }
                    continue;
                }
                userName = principal.getName();
                LOGGER.debug("Adding principal user name: " + userName, new Object[0]);
            }
        }
        return userName;
    }

    @Override
    public String getUserName() {
        return this.loggedIn ? this.userName : null;
    }

    @Override
    public boolean hasRole(String roleName) {
        return this.loggedIn ? this.entitlements.contains(roleName) : false;
    }

    @Override
    public void logout() {
        try {
            this.loggedIn = false;
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (LoginException le) {
            LOGGER.info((Throwable)le, null, new Object[0]);
        }
    }

    public static final class UserPasswordCallbackHandler
    implements CallbackHandler {
        private static final boolean LOG_TO_CONSOLE = false;
        private final String userId;
        private final char[] password;

        public UserPasswordCallbackHandler(String userId, char[] password) {
            this.userId = userId;
            this.password = (char[])password.clone();
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
            boolean userSet = false;
            boolean passwordSet = false;
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof TextOutputCallback) {
                    TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.userId);
                    userSet = true;
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.password);
                    passwordSet = true;
                    continue;
                }
                try {
                    if (!userSet) {
                        new Reflection(callbacks[i].getClass()).invokeSetterMethodOnTarget("object", (Object)callbacks[i], (Object)this.userId);
                        userSet = true;
                        continue;
                    }
                    if (passwordSet) continue;
                    new Reflection(callbacks[i].getClass()).invokeSetterMethodOnTarget("object", (Object)callbacks[i], (Object)new String(this.password));
                    passwordSet = true;
                    continue;
                }
                catch (Exception ex) {
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback: " + callbacks[i].getClass().getName());
                }
            }
        }
    }
}

