/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;

@Immutable
public class BasicPathSegment
implements Path.Segment {
    private static final long serialVersionUID = 4367349287846075157L;
    private final Name name;
    private final int index;
    private final int hc;

    public BasicPathSegment(Name name) {
        assert (name != null);
        this.name = name;
        this.index = 1;
        this.hc = HashCode.compute((Object[])new Object[]{name, this.index});
    }

    public BasicPathSegment(Name name, int index) {
        assert (name != null);
        assert (index >= 1);
        this.name = name;
        this.index = this.isSelfReference() || this.isParentReference() ? 1 : index;
        this.hc = HashCode.compute((Object[])new Object[]{name, index});
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public boolean hasIndex() {
        return this.index != 1;
    }

    @Override
    public boolean isParentReference() {
        return this.name.getLocalName().equals("..") && this.name.getNamespaceUri().length() == 0;
    }

    @Override
    public boolean isSelfReference() {
        return this.name.getLocalName().equals(".") && this.name.getNamespaceUri().length() == 0;
    }

    @Override
    public int compareTo(Path.Segment that) {
        if (this == that) {
            return 0;
        }
        int diff = this.getName().compareTo(that.getName());
        if (diff != 0) {
            return diff;
        }
        return this.getIndex() - that.getIndex();
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path.Segment) {
            Path.Segment that = (Path.Segment)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            return Math.abs(this.getIndex()) == Math.abs(that.getIndex());
        }
        return false;
    }

    public String toString() {
        if (this.hasIndex()) {
            return this.getName().toString() + "[" + this.getIndex() + "]";
        }
        return this.getName().toString();
    }

    @Override
    public String getUnencodedString() {
        return this.getString(Path.NO_OP_ENCODER);
    }

    @Override
    public String getString() {
        return this.getString(Path.DEFAULT_ENCODER);
    }

    @Override
    public String getString(TextEncoder encoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        String encodedName = this.getName().getString(encoder);
        if (this.hasIndex()) {
            return encodedName + "[" + this.getIndex() + "]";
        }
        return encodedName;
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry) {
        return this.getString(namespaceRegistry, Path.DEFAULT_ENCODER);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        return this.getString(namespaceRegistry, encoder, null);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        String encodedName = this.getName().getString(namespaceRegistry, encoder, delimiterEncoder);
        if (this.hasIndex()) {
            return encodedName + "[" + this.getIndex() + "]";
        }
        return encodedName;
    }
}

