/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.optimize.PushSelectCriteria;
import org.modeshape.graph.query.optimize.RaiseSelectCriteria;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.plan.PlanUtil;
import org.modeshape.graph.query.validate.Schemata;

@Immutable
public class ReplaceViews
implements OptimizerRule {
    public static final ReplaceViews INSTANCE = new ReplaceViews();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        HashMap<SelectorName, PlanNode> viewPlanCache = new HashMap<SelectorName, PlanNode>();
        CanonicalPlanner planner = new CanonicalPlanner();
        Schemata schemata = context.getSchemata();
        HashSet<PlanNode> processedSources = new HashSet<PlanNode>();
        boolean foundViews = false;
        do {
            foundViews = false;
            for (PlanNode sourceNode : plan.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
                if (processedSources.contains(sourceNode)) continue;
                processedSources.add(sourceNode);
                SelectorName tableName = sourceNode.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
                SelectorName tableAlias = sourceNode.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class);
                Schemata.Table table = schemata.getTable(tableName);
                if (!(table instanceof Schemata.View)) continue;
                Schemata.View view = (Schemata.View)table;
                PlanNode viewPlan = (PlanNode)viewPlanCache.get(tableName);
                if (viewPlan == null && (viewPlan = planner.createPlan(context, view.getDefinition())) != null) {
                    viewPlanCache.put(tableName, viewPlan);
                }
                if (viewPlan == null) continue;
                viewPlan = viewPlan.clone();
                sourceNode.addLastChild(viewPlan);
                PlanUtil.ColumnMapping viewMappings = PlanUtil.createMappingFor(view, viewPlan);
                PlanUtil.replaceViewReferences(context, viewPlan, viewMappings);
                if (tableAlias != null) {
                    PlanUtil.ColumnMapping aliasMappings = PlanUtil.createMappingForAliased(tableAlias, view, viewPlan);
                    PlanUtil.replaceViewReferences(context, viewPlan, aliasMappings);
                }
                if (viewPlan.is(PlanNode.Type.PROJECT)) {
                    for (PlanNode node = viewPlan.getParent(); node != null && !node.isOneOf(PlanNode.Type.JOIN, new PlanNode.Type[0]); node = node.getParent()) {
                        if (!node.is(PlanNode.Type.PROJECT) || !viewPlan.getSelectors().containsAll(node.getSelectors())) continue;
                        viewPlan.extractFromParent();
                        break;
                    }
                }
                foundViews = true;
            }
        } while (foundViews);
        if (foundViews) {
            if (!(ruleStack.getFirst() instanceof RaiseSelectCriteria)) {
                ruleStack.addFirst(RaiseSelectCriteria.INSTANCE);
                ruleStack.addFirst(PushSelectCriteria.INSTANCE);
            }
            ruleStack.addFirst(this);
        }
        return plan;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

