/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Reference;

@Immutable
public class ReferentialIntegrityException
extends RuntimeException {
    private static final long serialVersionUID = -3703984046286975978L;
    private final Map<Location, List<Reference>> invalidReferences;

    public ReferentialIntegrityException(Location location, Reference ... invalidReferences) {
        this.invalidReferences = new HashMap<Location, List<Reference>>();
        List<Object> invalidRefList = null;
        if (invalidReferences == null || invalidReferences.length == 0) {
            invalidRefList = Collections.emptyList();
        } else if (invalidReferences.length == 1) {
            invalidRefList = Collections.singletonList(invalidReferences[0]);
        } else {
            invalidRefList = new ArrayList();
            for (Reference ref : invalidReferences) {
                invalidRefList.add(ref);
            }
        }
        this.invalidReferences.put(location, invalidRefList);
    }

    public ReferentialIntegrityException(Map<Location, List<Reference>> invalidReferences) {
        this.invalidReferences = invalidReferences;
    }

    public ReferentialIntegrityException(Map<Location, List<Reference>> invalidReferences, String message) {
        super(message);
        this.invalidReferences = invalidReferences;
    }

    public ReferentialIntegrityException(Map<Location, List<Reference>> invalidReferences, Throwable cause) {
        super(cause);
        this.invalidReferences = invalidReferences;
    }

    public ReferentialIntegrityException(Map<Location, List<Reference>> invalidReferences, String message, Throwable cause) {
        super(message, cause);
        this.invalidReferences = invalidReferences;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public Map<Location, List<Reference>> getInvalidReferences() {
        return this.invalidReferences;
    }
}

