/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.validate;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.validate.ImmutableTable;
import org.modeshape.graph.query.validate.Schemata;

@Immutable
class ImmutableView
extends ImmutableTable
implements Schemata.View {
    private final QueryCommand definition;

    protected ImmutableView(SelectorName name, Iterable<Schemata.Column> columns, QueryCommand definition) {
        super(name, columns);
        this.definition = definition;
    }

    protected ImmutableView(SelectorName name, Iterable<Schemata.Column> columns, QueryCommand definition, Iterable<Schemata.Column> ... keyColumns) {
        super(name, columns, keyColumns);
        this.definition = definition;
    }

    protected ImmutableView(SelectorName name, Map<String, Schemata.Column> columnsByName, List<Schemata.Column> columns, QueryCommand definition, Set<Schemata.Key> keys) {
        super(name, columnsByName, columns, keys);
        this.definition = definition;
    }

    @Override
    public QueryCommand getDefinition() {
        return this.definition;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName().name());
        sb.append('(');
        boolean first = true;
        for (Schemata.Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(") AS '");
        sb.append(Visitors.readable(this.definition));
        sb.append('\'');
        if (!this.getKeys().isEmpty()) {
            sb.append(" with keys ");
            first = true;
            for (Schemata.Key key : this.getKeys()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(key);
            }
        }
        return sb.toString();
    }
}

