/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Arrays;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class SetPropertyRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location on;
    private final String workspaceName;
    private final Property property;
    private Location actualLocation;
    private boolean actualCreation;

    public SetPropertyRequest(Location on, String workspaceName, Property property) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotNull((Object)property, (String)"property");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.on = on;
        this.property = property;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Location on() {
        return this.on;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Property property() {
        return this.property;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        if (!this.on.equals(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{actual, this.on}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public void setNewProperty(boolean created) {
        this.actualCreation = created;
    }

    public boolean isNewProperty() {
        return this.actualCreation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.on.hasPath() && this.on.getPath().isAtOrBelow(path);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.on, this.workspaceName, this.property.getName()});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            SetPropertyRequest that = (SetPropertyRequest)obj;
            if (!this.on().isSame(that.on())) {
                return false;
            }
            if (!this.property().equals(that.property())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    @Override
    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.on;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    public String toString() {
        Object[] values = this.property().getValuesAsArray();
        return "set property " + this.property().getName() + " on " + this.on() + " in the \"" + this.workspaceName + "\" workspace to " + (values == null ? "null" : Arrays.asList(values).toString());
    }

    @Override
    public SetPropertyRequest clone() {
        SetPropertyRequest request = new SetPropertyRequest(this.actualLocation != null ? this.actualLocation : this.on, this.workspaceName, this.property);
        request.setActualLocationOfNode(this.actualLocation);
        request.setNewProperty(this.actualCreation);
        return request;
    }

    @Override
    public RequestType getType() {
        return RequestType.SET_PROPERTY;
    }
}

