/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class UnlockBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private Location actualLocation;

    public UnlockBranchRequest(Location at, String workspaceName) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public void setActualLocation(Location actualLocation) {
        this.checkNotFrozen();
        if (!this.at.equals(actualLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{actualLocation, this.at}));
        }
        assert (actualLocation != null);
        if (!actualLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{actualLocation}));
        }
        this.actualLocation = actualLocation;
    }

    public Location getActualLocation() {
        return this.actualLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.at.hasPath() && this.at.getPath().getParent().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.at;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.at, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            UnlockBranchRequest that = (UnlockBranchRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "unlock branch at " + this.at() + " in the \"" + this.workspaceName + "\" workspace";
    }

    @Override
    public UnlockBranchRequest clone() {
        UnlockBranchRequest request = new UnlockBranchRequest(this.actualLocation != null ? this.actualLocation : this.at, this.workspaceName);
        request.setActualLocation(this.actualLocation);
        return request;
    }

    @Override
    public RequestType getType() {
        return RequestType.UNLOCK_BRANCH;
    }
}

