/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Collections;
import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class UpdateValuesRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final String workspaceName;
    private final Location on;
    private final Name propertyName;
    private final List<Object> addedValues;
    private final List<Object> removedValues;
    private Location actualLocation;
    private List<Object> actualAddedValues;
    private List<Object> actualRemovedValues;
    private boolean actualCreation;
    private Property actualProperty;

    public UpdateValuesRequest(String workspaceName, Location on, Name propertyName, List<Object> addedValues, List<Object> removedValues) {
        assert (workspaceName != null);
        assert (on != null);
        assert (propertyName != null);
        this.workspaceName = workspaceName;
        this.on = on;
        this.propertyName = propertyName;
        this.addedValues = addedValues == null ? Collections.emptyList() : addedValues;
        this.removedValues = removedValues == null ? Collections.emptyList() : removedValues;
    }

    public Location on() {
        return this.on;
    }

    public Name property() {
        return this.propertyName;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public List<Object> addedValues() {
        return this.addedValues;
    }

    public List<Object> removedValues() {
        return this.removedValues;
    }

    @Override
    public Location changedLocation() {
        return this.on;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.on.hasPath() && this.on.getPath().equals(path);
    }

    @Override
    public boolean isReadOnly() {
        return this.addedValues.isEmpty() && this.removedValues.isEmpty();
    }

    public void setActualLocation(Location actual, List<Object> actualAddedValues, List<Object> actualRemovedValues) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)actual, (String)"actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
        assert (this.actualLocation != null);
        assert (actualAddedValues != null);
        assert (actualAddedValues.size() <= this.addedValues.size());
        assert (actualRemovedValues != null);
        assert (actualRemovedValues.size() <= actualRemovedValues.size());
        this.actualAddedValues = actualAddedValues;
        this.actualRemovedValues = actualRemovedValues;
    }

    public void setActualProperty(Property property, boolean created) {
        CheckArg.isNotNull((Object)property, (String)"property");
        this.checkNotFrozen();
        this.actualProperty = property;
        this.actualCreation = created;
    }

    public Property getActualProperty() {
        return this.actualProperty;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public List<Object> getActualAddedValues() {
        return this.actualAddedValues;
    }

    public List<Object> getActualRemovedValues() {
        return this.actualRemovedValues;
    }

    public boolean isNewProperty() {
        return this.actualCreation;
    }

    @Override
    public UpdateValuesRequest clone() {
        UpdateValuesRequest request = new UpdateValuesRequest(this.workspaceName, this.actualLocation != null ? this.actualLocation : this.on, this.propertyName, this.addedValues, this.removedValues);
        request.setActualLocation(this.actualLocation, this.actualAddedValues, this.actualRemovedValues);
        request.actualProperty = this.actualProperty;
        request.actualCreation = this.actualCreation;
        return request;
    }

    @Override
    public RequestType getType() {
        return RequestType.UPDATE_VALUES;
    }
}

