/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.collection.EmptyIterator;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Locations;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.Results;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.Workspace;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.io.GraphImporter;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryEngine;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.optimize.Optimizer;
import org.modeshape.graph.query.optimize.RuleBasedOptimizer;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.process.AbstractAccessComponent;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.process.QueryProcessor;
import org.modeshape.graph.query.process.QueryResults;
import org.modeshape.graph.query.process.SelectComponent;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.BatchRequestBuilder;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestBuilder;
import org.modeshape.graph.request.RequestType;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.xml.sax.SAXException;

@NotThreadSafe
public class Graph {
    protected static final Iterator<Property> EMPTY_PROPERTIES = new EmptyIterator();
    protected static final Iterable<Property> NO_PROPERTIES = new Iterable<Property>(){

        @Override
        public final Iterator<Property> iterator() {
            return EMPTY_PROPERTIES;
        }
    };
    private final String sourceName;
    private final RepositoryConnectionFactory connectionFactory;
    protected final ExecutionContext context;
    protected final RequestBuilder requests;
    protected final Conjunction<Graph> nextGraph;
    private Workspace currentWorkspace;
    private QueryEngine queryEngine;
    protected static final List<Location> NO_CHILDREN = Collections.emptyList();

    public static Graph create(String sourceName, RepositoryConnectionFactory connectionFactory, ExecutionContext context) {
        return new Graph(sourceName, connectionFactory, context);
    }

    public static Graph create(final RepositoryConnection connection, ExecutionContext context) {
        CheckArg.isNotNull((Object)connection, (String)"connection");
        final String connectorSourceName = connection.getSourceName();
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            @Override
            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (connectorSourceName.equals(sourceName)) {
                    return connection;
                }
                return null;
            }
        };
        return new Graph(connectorSourceName, connectionFactory, context);
    }

    public static Graph create(final RepositorySource source, ExecutionContext context) {
        CheckArg.isNotNull((Object)source, (String)"source");
        final String connectorSourceName = source.getName();
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            @Override
            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (connectorSourceName.equals(sourceName)) {
                    return source.getConnection();
                }
                return null;
            }
        };
        return new Graph(connectorSourceName, connectionFactory, context);
    }

    public static Graph create(ExecutionContext context) {
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("Transient source");
        return Graph.create(source, context);
    }

    protected Graph(String sourceName, RepositoryConnectionFactory connectionFactory, ExecutionContext context) {
        CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        CheckArg.isNotNull((Object)context, (String)"context");
        this.sourceName = sourceName;
        this.connectionFactory = connectionFactory;
        this.context = context;
        this.nextGraph = new Conjunction<Graph>(){

            @Override
            public Graph and() {
                return Graph.this;
            }
        };
        this.requests = new RequestBuilder(){

            @Override
            protected <T extends Request> T process(T request) {
                Graph.this.execute(request);
                return request;
            }
        };
    }

    public RepositoryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Request request) {
        RepositoryConnection connection = this.getConnectionFactory().createConnection(this.getSourceName());
        if (connection == null) {
            throw new RepositorySourceException(GraphI18n.unableToFindRepositorySourceWithName.text(new Object[]{this.getSourceName()}));
        }
        try {
            connection.execute(this.getContext(), request);
        }
        finally {
            connection.close();
        }
        if (request.hasError()) {
            Throwable error = request.getError();
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new RepositorySourceException(this.getSourceName(), error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachePolicy getDefaultCachePolicy() {
        RepositoryConnection connection = this.connectionFactory.createConnection(this.getSourceName());
        if (connection == null) {
            throw new RepositorySourceException(GraphI18n.unableToFindRepositorySourceWithName.text(new Object[]{this.getSourceName()}));
        }
        try {
            CachePolicy cachePolicy = connection.getDefaultCachePolicy();
            return cachePolicy;
        }
        finally {
            connection.close();
        }
    }

    protected Workspace setWorkspace(String workspaceName, Location actualRootLocation) {
        assert (workspaceName != null);
        assert (actualRootLocation != null);
        this.currentWorkspace = new GraphWorkspace(workspaceName, actualRootLocation);
        return this.currentWorkspace;
    }

    public String getCurrentWorkspaceName() {
        return this.getCurrentWorkspace().getName();
    }

    public Workspace getCurrentWorkspace() {
        if (this.currentWorkspace == null) {
            this.useWorkspace(null);
        }
        assert (this.currentWorkspace != null);
        return this.currentWorkspace;
    }

    public Set<String> getWorkspaces() {
        return this.requests.getWorkspaces().getAvailableWorkspaceNames();
    }

    public Workspace useWorkspace(String workspaceName) {
        VerifyWorkspaceRequest request = this.requests.verifyWorkspace(workspaceName);
        return this.setWorkspace(request.getActualWorkspaceName(), request.getActualLocationOfRoot());
    }

    public CreateWorkspace createWorkspace() {
        return new CreateWorkspace(){

            @Override
            public Workspace named(String workspaceName) {
                CreateWorkspaceRequest request = Graph.this.requests.createWorkspace(workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
                return Graph.this.setWorkspace(request.getActualWorkspaceName(), request.getActualLocationOfRoot());
            }

            @Override
            public Workspace namedSomethingLike(String workspaceName) {
                CreateWorkspaceRequest request = Graph.this.requests.createWorkspace(workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
                return Graph.this.setWorkspace(request.getActualWorkspaceName(), request.getActualLocationOfRoot());
            }

            @Override
            public NameWorkspace clonedFrom(final String nameOfWorkspaceToClone) {
                return new NameWorkspace(){

                    @Override
                    public Workspace named(String nameOfWorkspaceToCreate) {
                        CloneWorkspaceRequest request = Graph.this.requests.cloneWorkspace(nameOfWorkspaceToClone, nameOfWorkspaceToCreate, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.DO_NOT_CLONE);
                        return Graph.this.setWorkspace(request.getActualWorkspaceName(), request.getActualLocationOfRoot());
                    }

                    @Override
                    public Workspace namedSomethingLike(String nameOfWorkspaceToCreate) {
                        CloneWorkspaceRequest request = Graph.this.requests.cloneWorkspace(nameOfWorkspaceToClone, nameOfWorkspaceToCreate, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME, CloneWorkspaceRequest.CloneConflictBehavior.DO_NOT_CLONE);
                        return Graph.this.setWorkspace(request.getActualWorkspaceName(), request.getActualLocationOfRoot());
                    }
                };
            }
        };
    }

    public DestroyWorkspace destroyWorkspace() {
        return new DestroyWorkspace(){

            @Override
            public boolean named(String workspaceName) {
                CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
                if (Graph.this.getCurrentWorkspaceName().equals(workspaceName)) {
                    String msg = GraphI18n.currentWorkspaceCannotBeDeleted.text(new Object[]{workspaceName, Graph.this.getSourceName()});
                    throw new InvalidWorkspaceException(msg);
                }
                DestroyWorkspaceRequest request = Graph.this.requests.destroyWorkspace(workspaceName);
                return !request.hasError();
            }
        };
    }

    public LockScope<LockTimeout<Conjunction<Graph>>> lock(Node at) {
        return this.lock(at.getLocation());
    }

    public LockScope<LockTimeout<Conjunction<Graph>>> lock(String atPath) {
        return this.lock(Location.create(this.createPath(atPath)));
    }

    public LockScope<LockTimeout<Conjunction<Graph>>> lock(Path at) {
        return this.lock(Location.create(at));
    }

    public LockScope<LockTimeout<Conjunction<Graph>>> lock(UUID at) {
        return this.lock(Location.create(at));
    }

    public LockScope<LockTimeout<Conjunction<Graph>>> lock(Property idProperty) {
        return this.lock(Location.create(idProperty));
    }

    public LockScope<LockTimeout<Conjunction<Graph>>> lock(Property firstIdProperty, Property ... additionalIdProperties) {
        return this.lock(Location.create(firstIdProperty, additionalIdProperties));
    }

    public LockScope<LockTimeout<Conjunction<Graph>>> lock(Location at) {
        return new LockAction<Conjunction<Graph>>(this.nextGraph, at){

            @Override
            protected Conjunction<Graph> submit(Location target, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) {
                String workspaceName = Graph.this.getCurrentWorkspaceName();
                Graph.this.requests.lockBranch(workspaceName, target, lockScope, lockTimeoutInMillis);
                return (Conjunction)this.and();
            }
        };
    }

    public Conjunction<Graph> unlock(Node at) {
        return this.unlock(at.getLocation());
    }

    public Conjunction<Graph> unlock(String atPath) {
        return this.unlock(Location.create(this.createPath(atPath)));
    }

    public Conjunction<Graph> unlock(Path at) {
        return this.unlock(Location.create(at));
    }

    public Conjunction<Graph> unlock(UUID at) {
        return this.unlock(Location.create(at));
    }

    public Conjunction<Graph> unlock(Property idProperty) {
        return this.unlock(Location.create(idProperty));
    }

    public Conjunction<Graph> unlock(Property firstIdProperty, Property ... additionalIdProperties) {
        return this.unlock(Location.create(firstIdProperty, additionalIdProperties));
    }

    public Conjunction<Graph> unlock(Location at) {
        String workspaceName = this.getCurrentWorkspaceName();
        this.requests.unlockBranch(workspaceName, at);
        return this.nextGraph;
    }

    public Move<Conjunction<Graph>> move(Node from) {
        return this.move(from.getLocation());
    }

    public Move<Conjunction<Graph>> move(Location from) {
        return new MoveAction<Conjunction<Graph>>(this.nextGraph, from){

            @Override
            protected Conjunction<Graph> submit(Locations from, Location into, Location before, Name newName) {
                String workspaceName = Graph.this.getCurrentWorkspaceName();
                do {
                    Graph.this.requests.moveBranch(from.getLocation(), into, before, workspaceName, newName);
                } while ((from = from.next()) != null);
                return (Conjunction)this.and();
            }
        };
    }

    public Move<Conjunction<Graph>> move(String fromPath) {
        return this.move(Location.create(this.createPath(fromPath)));
    }

    public Move<Conjunction<Graph>> move(Path from) {
        return this.move(Location.create(from));
    }

    public Move<Conjunction<Graph>> move(UUID from) {
        return this.move(Location.create(from));
    }

    public Move<Conjunction<Graph>> move(Property idProperty) {
        return this.move(Location.create(idProperty));
    }

    public Move<Conjunction<Graph>> move(Property firstIdProperty, Property ... additionalIdProperties) {
        return this.move(Location.create(firstIdProperty, additionalIdProperties));
    }

    public Clone<Graph> clone(Location from) {
        return new CloneAction<Graph>(this, from){

            @Override
            protected Graph submit(String fromWorkspaceName, Location from, String intoWorkspaceName, Location into, Name desiredName, Path.Segment desiredSegment, boolean removeExisting) {
                Graph.this.requests.cloneBranch(from, fromWorkspaceName, into, intoWorkspaceName, desiredName, desiredSegment, removeExisting);
                return (Graph)this.and();
            }
        };
    }

    public Clone<Graph> clone(Node from) {
        return this.clone(from.getLocation());
    }

    public Clone<Graph> clone(String fromPath) {
        return this.clone(Location.create(this.createPath(fromPath)));
    }

    public Clone<Graph> clone(Path from) {
        return this.clone(Location.create(from));
    }

    public Clone<Graph> clone(UUID from) {
        return this.clone(Location.create(from));
    }

    public Clone<Graph> clone(Property idProperty) {
        return this.clone(Location.create(idProperty));
    }

    public Clone<Graph> clone(Property firstIdProperty, Property ... additionalIdProperties) {
        return this.clone(Location.create(firstIdProperty, additionalIdProperties));
    }

    public Copy<Graph> copy(Node from) {
        return this.copy(from.getLocation());
    }

    public Copy<Graph> copy(Location from) {
        return new CopyAction<Graph>(this, from){

            @Override
            protected Graph submit(String fromWorkspaceName, Locations from, Location into, Name childName) {
                String workspaceName = fromWorkspaceName != null ? fromWorkspaceName : Graph.this.getCurrentWorkspaceName();
                do {
                    Graph.this.requests.copyBranch(from.getLocation(), workspaceName, into, Graph.this.getCurrentWorkspaceName(), childName, NodeConflictBehavior.APPEND);
                } while ((from = from.next()) != null);
                return (Graph)this.and();
            }
        };
    }

    public Copy<Graph> copy(String fromPath) {
        return this.copy(Location.create(this.createPath(fromPath)));
    }

    public Copy<Graph> copy(Path from) {
        return this.copy(Location.create(from));
    }

    public Copy<Graph> copy(UUID from) {
        return this.copy(Location.create(from));
    }

    public Copy<Graph> copy(Property idProperty) {
        return this.copy(Location.create(idProperty));
    }

    public Copy<Graph> copy(Property firstIdProperty, Property ... additionalIdProperties) {
        return this.copy(Location.create(firstIdProperty, additionalIdProperties));
    }

    public Conjunction<Graph> delete(Node at) {
        this.requests.deleteBranch(at.getLocation(), this.getCurrentWorkspaceName());
        return this.nextGraph;
    }

    public Conjunction<Graph> delete(Location at) {
        this.requests.deleteBranch(at, this.getCurrentWorkspaceName());
        return this.nextGraph;
    }

    public Conjunction<Graph> delete(String atPath) {
        return this.delete(Location.create(this.createPath(atPath)));
    }

    public Conjunction<Graph> delete(Path at) {
        return this.delete(Location.create(at));
    }

    public Conjunction<Graph> delete(UUID at) {
        return this.delete(Location.create(at));
    }

    public Conjunction<Graph> delete(Property idProperty) {
        return this.delete(Location.create(idProperty));
    }

    public Conjunction<Graph> delete(Property firstIdProperty, Property ... additionalIdProperties) {
        return this.delete(Location.create(firstIdProperty, additionalIdProperties));
    }

    public CreateAt<Graph> createAt(String atPath) {
        return this.createAt(this.createPath(atPath));
    }

    public CreateAt<Graph> createAt(Path at) {
        CheckArg.isNotNull((Object)at, (String)"at");
        final Path parent = at.getParent();
        final Name childName = at.getLastSegment().getName();
        final String workspaceName = this.getCurrentWorkspaceName();
        return new CreateAt<Graph>(){
            private final List<Property> properties = new LinkedList<Property>();

            @Override
            public CreateAt<Graph> and(UUID uuid) {
                PropertyFactory factory = Graph.this.getContext().getPropertyFactory();
                this.properties.add(factory.create(ModeShapeLexicon.UUID, uuid));
                return this;
            }

            @Override
            public CreateAt<Graph> and(Property property) {
                this.properties.add(property);
                return this;
            }

            @Override
            public CreateAt<Graph> and(Iterable<Property> properties) {
                for (Property property : properties) {
                    this.properties.add(property);
                }
                return this;
            }

            @Override
            public CreateAt<Graph> and(String name, Object ... values) {
                ExecutionContext context = Graph.this.getContext();
                PropertyFactory factory = context.getPropertyFactory();
                NameFactory nameFactory = context.getValueFactories().getNameFactory();
                this.properties.add(factory.create((Name)nameFactory.create(name), values));
                return this;
            }

            @Override
            public CreateAt<Graph> and(Name name, Object ... values) {
                ExecutionContext context = Graph.this.getContext();
                PropertyFactory factory = context.getPropertyFactory();
                this.properties.add(factory.create(name, values));
                return this;
            }

            @Override
            public CreateAt<Graph> and(Property property, Property ... additionalProperties) {
                this.properties.add(property);
                for (Property additionalProperty : additionalProperties) {
                    this.properties.add(additionalProperty);
                }
                return this;
            }

            @Override
            public CreateAt<Graph> with(UUID uuid) {
                return this.and(uuid);
            }

            @Override
            public CreateAt<Graph> with(Property property) {
                return this.and(property);
            }

            @Override
            public CreateAt<Graph> with(Iterable<Property> properties) {
                return this.and(properties);
            }

            @Override
            public CreateAt<Graph> with(Property property, Property ... additionalProperties) {
                return this.and(property, additionalProperties);
            }

            @Override
            public CreateAt<Graph> with(String name, Object ... values) {
                return this.and(name, values);
            }

            @Override
            public CreateAt<Graph> with(Name name, Object ... values) {
                return this.and(name, values);
            }

            @Override
            public Location getLocation() {
                Location parentLoc = Location.create(parent);
                CreateNodeRequest request = Graph.this.requests.createNode(parentLoc, workspaceName, childName, this.properties.iterator());
                return request.getActualLocationOfNode();
            }

            @Override
            public Node getNode() {
                Location parentLoc = Location.create(parent);
                CreateNodeRequest request = Graph.this.requests.createNode(parentLoc, workspaceName, childName, this.properties.iterator());
                return Graph.this.getNodeAt(request.getActualLocationOfNode());
            }

            @Override
            public Graph and() {
                Graph.this.requests.createNode(Location.create(parent), workspaceName, childName, this.properties.iterator());
                return Graph.this;
            }
        };
    }

    public Create<Graph> create(String atPath) {
        return this.create(this.createPath(atPath));
    }

    public Create<Graph> create(String atPath, Property property) {
        return this.create(this.createPath(atPath)).with(property);
    }

    public Create<Graph> create(String atPath, Property firstProperty, Property ... additionalProperties) {
        return this.create(this.createPath(atPath)).with(firstProperty, additionalProperties);
    }

    public final Create<Graph> create(Path at) {
        CheckArg.isNotNull((Object)at, (String)"at");
        Path parent = at.getParent();
        Name name = at.getLastSegment().getName();
        return this.create(Location.create(parent), name);
    }

    protected final CreateAction<Graph> create(Location parent, Name child) {
        return new CreateAction<Graph>(this, parent, this.getCurrentWorkspaceName(), child){

            @Override
            protected Graph submit(Location parent, String workspaceName, Name childName, Collection<Property> properties, NodeConflictBehavior behavior) {
                Graph.this.requests.createNode(parent, workspaceName, childName, properties.iterator(), behavior);
                return Graph.this;
            }
        };
    }

    public Create<Graph> create(Path at, Iterable<Property> properties) {
        Create<Graph> action = this.create(at);
        for (Property property : properties) {
            action.and(property);
        }
        return action;
    }

    public Create<Graph> create(Path at, Property property) {
        return this.create(at).with(property);
    }

    public Create<Graph> create(Path at, Property firstProperty, Property ... additionalProperties) {
        return this.create(at).with(firstProperty, additionalProperties);
    }

    public CreateNode<Conjunction<Graph>> createUnder(final Location parent) {
        final NameFactory nameFactory = this.getContext().getValueFactories().getNameFactory();
        CheckArg.isNotNull((Object)parent, (String)"parent");
        return new CreateNode<Conjunction<Graph>>(){

            @Override
            public Conjunction<Graph> node(String name, Property ... properties) {
                Name child = (Name)nameFactory.create(name);
                Graph.this.requests.createNode(parent, Graph.this.getCurrentWorkspaceName(), child, properties);
                return Graph.this.nextGraph;
            }

            @Override
            public Conjunction<Graph> node(String name, Iterator<Property> properties) {
                Name child = (Name)nameFactory.create(name);
                Graph.this.requests.createNode(parent, Graph.this.getCurrentWorkspaceName(), child, properties);
                return Graph.this.nextGraph;
            }

            @Override
            public Conjunction<Graph> node(String name, Iterable<Property> properties) {
                Name child = (Name)nameFactory.create(name);
                Graph.this.requests.createNode(parent, Graph.this.getCurrentWorkspaceName(), child, properties.iterator());
                return Graph.this.nextGraph;
            }
        };
    }

    public AddValue<Graph> addValue(Object value) {
        return new AddValueAction<Graph>(this, this.getCurrentWorkspaceName(), value){

            @Override
            protected Graph submit(String workspaceName, Location on, Name property, List<Object> values) {
                Graph.this.requests.addValues(workspaceName, on, property, values);
                return Graph.this.nextGraph.and();
            }
        };
    }

    public RemoveValue<Graph> removeValue(Object value) {
        return new RemoveValueAction<Graph>(this, this.getCurrentWorkspaceName(), value){

            @Override
            protected Graph submit(String workspaceName, Location on, Name property, List<Object> values) {
                Graph.this.requests.removeValues(workspaceName, on, property, values);
                return Graph.this.nextGraph.and();
            }
        };
    }

    public On<Conjunction<Graph>> set(final Property ... properties) {
        return new On<Conjunction<Graph>>(){

            @Override
            public Conjunction<Graph> on(Location location) {
                Graph.this.requests.setProperties(location, Graph.this.getCurrentWorkspaceName(), properties);
                return Graph.this.nextGraph;
            }

            @Override
            public Conjunction<Graph> on(String path) {
                return this.on(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> on(Path path) {
                return this.on(Location.create(path));
            }

            @Override
            public Conjunction<Graph> on(Property idProperty) {
                return this.on(Location.create(idProperty));
            }

            @Override
            public Conjunction<Graph> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> on(Iterable<Property> idProperties) {
                return this.on(Location.create(idProperties));
            }

            @Override
            public Conjunction<Graph> on(UUID uuid) {
                return this.on(Location.create(uuid));
            }
        };
    }

    public SetValues<Conjunction<Graph>> set(String propertyName) {
        Name name = (Name)this.getContext().getValueFactories().getNameFactory().create(propertyName);
        return this.set(name);
    }

    public SetValues<Conjunction<Graph>> set(final Name propertyName) {
        return new SetValues<Conjunction<Graph>>(){

            @Override
            public SetValuesTo<Conjunction<Graph>> on(final Location location) {
                return new SetValuesTo<Conjunction<Graph>>(){

                    @Override
                    public Conjunction<Graph> to(Node value) {
                        Reference ref = (Reference)Graph.this.convertReferenceValue(value);
                        Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, ref);
                        Graph.this.requests.setProperty(location, Graph.this.getCurrentWorkspaceName(), property);
                        return Graph.this.nextGraph;
                    }

                    @Override
                    public Conjunction<Graph> to(Location value) {
                        Reference ref = (Reference)Graph.this.convertReferenceValue(value);
                        Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, ref);
                        Graph.this.requests.setProperty(location, Graph.this.getCurrentWorkspaceName(), property);
                        return Graph.this.nextGraph;
                    }

                    protected Conjunction<Graph> toValue(Object value) {
                        Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, value);
                        Graph.this.requests.setProperty(location, Graph.this.getCurrentWorkspaceName(), property);
                        return Graph.this.nextGraph;
                    }

                    @Override
                    public Conjunction<Graph> to(String value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(int value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(long value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(boolean value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(float value) {
                        return this.toValue(Float.valueOf(value));
                    }

                    @Override
                    public Conjunction<Graph> to(double value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(BigDecimal value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(Calendar value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(Date value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(DateTime value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(Name value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(Path value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(Reference value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(URI value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(UUID value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(Binary value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(byte[] value) {
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(InputStream stream, long approximateLength) {
                        Binary value = (Binary)Graph.this.getContext().getValueFactories().getBinaryFactory().create(stream, approximateLength);
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(Reader reader, long approximateLength) {
                        Binary value = (Binary)Graph.this.getContext().getValueFactories().getBinaryFactory().create(reader, approximateLength);
                        return this.toValue(value);
                    }

                    @Override
                    public Conjunction<Graph> to(Object value) {
                        value = Graph.this.convertReferenceValue(value);
                        Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, value);
                        Graph.this.requests.setProperty(location, Graph.this.getCurrentWorkspaceName(), property);
                        return Graph.this.nextGraph;
                    }

                    @Override
                    public Conjunction<Graph> to(Object firstValue, Object ... otherValues) {
                        firstValue = Graph.this.convertReferenceValue(firstValue);
                        int len = otherValues.length;
                        for (int i = 0; i != len; ++i) {
                            otherValues[i] = Graph.this.convertReferenceValue(otherValues[i]);
                        }
                        Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, firstValue, otherValues);
                        Graph.this.requests.setProperty(location, Graph.this.getCurrentWorkspaceName(), property);
                        return Graph.this.nextGraph;
                    }

                    @Override
                    public Conjunction<Graph> to(Object[] values) {
                        int len = values.length;
                        for (int i = 0; i != len; ++i) {
                            values[i] = Graph.this.convertReferenceValue(values[i]);
                        }
                        Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, values);
                        Graph.this.requests.setProperty(location, Graph.this.getCurrentWorkspaceName(), property);
                        return Graph.this.nextGraph;
                    }

                    @Override
                    public Conjunction<Graph> to(Iterable<?> values) {
                        LinkedList valueList = new LinkedList();
                        for (Object value : values) {
                            value = Graph.this.convertReferenceValue(value);
                            valueList.add(value);
                        }
                        Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, valueList);
                        Graph.this.requests.setProperty(location, Graph.this.getCurrentWorkspaceName(), property);
                        return Graph.this.nextGraph;
                    }

                    @Override
                    public Conjunction<Graph> to(Iterator<?> values) {
                        LinkedList valueList = new LinkedList();
                        while (values.hasNext()) {
                            Object value = values.next();
                            valueList.add(value);
                        }
                        Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, valueList);
                        Graph.this.requests.setProperty(location, Graph.this.getCurrentWorkspaceName(), property);
                        return Graph.this.nextGraph;
                    }
                };
            }

            @Override
            public SetValuesTo<Conjunction<Graph>> on(String path) {
                return this.on(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public SetValuesTo<Conjunction<Graph>> on(Path path) {
                return this.on(Location.create(path));
            }

            @Override
            public SetValuesTo<Conjunction<Graph>> on(Property idProperty) {
                return this.on(Location.create(idProperty));
            }

            @Override
            public SetValuesTo<Conjunction<Graph>> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public SetValuesTo<Conjunction<Graph>> on(Iterable<Property> idProperties) {
                return this.on(Location.create(idProperties));
            }

            @Override
            public SetValuesTo<Conjunction<Graph>> on(UUID uuid) {
                return this.on(Location.create(uuid));
            }

            @Override
            public On<Conjunction<Graph>> to(Node node) {
                Reference value = (Reference)Graph.this.convertReferenceValue(node);
                return Graph.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, value));
            }

            @Override
            public On<Conjunction<Graph>> to(Location location) {
                Reference value = (Reference)Graph.this.convertReferenceValue(location);
                return Graph.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, value));
            }

            protected On<Conjunction<Graph>> toValue(Object value) {
                return Graph.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, value));
            }

            @Override
            public On<Conjunction<Graph>> to(String value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(int value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(long value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(boolean value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(float value) {
                return this.toValue(Float.valueOf(value));
            }

            @Override
            public On<Conjunction<Graph>> to(double value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(BigDecimal value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(Calendar value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(Date value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(DateTime value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(Name value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(Path value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(Reference value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(URI value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(UUID value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(Binary value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(byte[] value) {
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(InputStream stream, long approximateLength) {
                Binary value = (Binary)Graph.this.getContext().getValueFactories().getBinaryFactory().create(stream, approximateLength);
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(Reader reader, long approximateLength) {
                Binary value = (Binary)Graph.this.getContext().getValueFactories().getBinaryFactory().create(reader, approximateLength);
                return this.toValue(value);
            }

            @Override
            public On<Conjunction<Graph>> to(Object value) {
                value = Graph.this.convertReferenceValue(value);
                return Graph.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, value));
            }

            @Override
            public On<Conjunction<Graph>> to(Object firstValue, Object ... otherValues) {
                firstValue = Graph.this.convertReferenceValue(firstValue);
                int len = otherValues.length;
                for (int i = 0; i != len; ++i) {
                    otherValues[i] = Graph.this.convertReferenceValue(otherValues[i]);
                }
                return Graph.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, firstValue, otherValues));
            }

            @Override
            public On<Conjunction<Graph>> to(Object[] values) {
                int len = values.length;
                for (int i = 0; i != len; ++i) {
                    values[i] = Graph.this.convertReferenceValue(values[i]);
                }
                return Graph.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, values));
            }

            @Override
            public On<Conjunction<Graph>> to(Iterable<?> values) {
                LinkedList valueList = new LinkedList();
                for (Object value : values) {
                    value = Graph.this.convertReferenceValue(value);
                    valueList.add(value);
                }
                return Graph.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, valueList));
            }

            @Override
            public On<Conjunction<Graph>> to(Iterator<?> values) {
                LinkedList valueList = new LinkedList();
                while (values.hasNext()) {
                    Object value = values.next();
                    valueList.add(value);
                }
                return Graph.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, valueList));
            }
        };
    }

    public On<Conjunction<Graph>> remove(final Name ... propertyNames) {
        return new On<Conjunction<Graph>>(){

            @Override
            public Conjunction<Graph> on(Location location) {
                Graph.this.requests.removeProperties(location, Graph.this.getCurrentWorkspaceName(), propertyNames);
                return Graph.this.nextGraph;
            }

            @Override
            public Conjunction<Graph> on(String path) {
                return this.on(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> on(Path path) {
                return this.on(Location.create(path));
            }

            @Override
            public Conjunction<Graph> on(Property idProperty) {
                return this.on(Location.create(idProperty));
            }

            @Override
            public Conjunction<Graph> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> on(Iterable<Property> idProperties) {
                return this.on(Location.create(idProperties));
            }

            @Override
            public Conjunction<Graph> on(UUID uuid) {
                return this.on(Location.create(uuid));
            }
        };
    }

    public On<Conjunction<Graph>> remove(String ... propertyNames) {
        NameFactory nameFactory = this.getContext().getValueFactories().getNameFactory();
        int number = propertyNames.length;
        final Name[] names = new Name[number];
        for (int i = 0; i != number; ++i) {
            names[i] = (Name)nameFactory.create(propertyNames[i]);
        }
        return new On<Conjunction<Graph>>(){

            @Override
            public Conjunction<Graph> on(Location location) {
                Graph.this.requests.removeProperties(location, Graph.this.getCurrentWorkspaceName(), names);
                return Graph.this.nextGraph;
            }

            @Override
            public Conjunction<Graph> on(String path) {
                return this.on(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> on(Path path) {
                return this.on(Location.create(path));
            }

            @Override
            public Conjunction<Graph> on(Property idProperty) {
                return this.on(Location.create(idProperty));
            }

            @Override
            public Conjunction<Graph> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> on(Iterable<Property> idProperties) {
                return this.on(Location.create(idProperties));
            }

            @Override
            public Conjunction<Graph> on(UUID uuid) {
                return this.on(Location.create(uuid));
            }
        };
    }

    public On<Collection<Property>> getProperties() {
        return new On<Collection<Property>>(){

            @Override
            public Collection<Property> on(Location location) {
                return Graph.this.requests.readAllProperties(location, Graph.this.getCurrentWorkspaceName()).getProperties();
            }

            @Override
            public Collection<Property> on(String path) {
                return this.on(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Collection<Property> on(Path path) {
                return this.on(Location.create(path));
            }

            @Override
            public Collection<Property> on(Property idProperty) {
                return this.on(Location.create(idProperty));
            }

            @Override
            public Collection<Property> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Collection<Property> on(Iterable<Property> idProperties) {
                return this.on(Location.create(idProperties));
            }

            @Override
            public Collection<Property> on(UUID uuid) {
                return this.on(Location.create(uuid));
            }
        };
    }

    public On<Map<Name, Property>> getPropertiesByName() {
        return new On<Map<Name, Property>>(){

            @Override
            public Map<Name, Property> on(Location location) {
                return Graph.this.requests.readAllProperties(location, Graph.this.getCurrentWorkspaceName()).getPropertiesByName();
            }

            @Override
            public Map<Name, Property> on(String path) {
                return this.on(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Map<Name, Property> on(Path path) {
                return this.on(Location.create(path));
            }

            @Override
            public Map<Name, Property> on(Property idProperty) {
                return this.on(Location.create(idProperty));
            }

            @Override
            public Map<Name, Property> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Map<Name, Property> on(Iterable<Property> idProperties) {
                return this.on(Location.create(idProperties));
            }

            @Override
            public Map<Name, Property> on(UUID uuid) {
                return this.on(Location.create(uuid));
            }
        };
    }

    public Children<List<Location>> getChildren() {
        return new Children<List<Location>>(){

            @Override
            public List<Location> of(String path) {
                return this.of(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public List<Location> of(Path path) {
                return this.of(Location.create(path));
            }

            @Override
            public List<Location> of(Property idProperty) {
                return this.of(Location.create(idProperty));
            }

            @Override
            public List<Location> of(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.of(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public List<Location> of(Iterable<Property> idProperties) {
                return this.of(Location.create(idProperties));
            }

            @Override
            public List<Location> of(UUID uuid) {
                return this.of(Location.create(uuid));
            }

            @Override
            public List<Location> of(Location at) {
                return Graph.this.requests.readAllChildren(at, Graph.this.getCurrentWorkspaceName()).getChildren();
            }

            @Override
            public BlockOfChildren<List<Location>> inBlockOf(final int blockSize) {
                return new BlockOfChildren<List<Location>>(){

                    @Override
                    public Under<List<Location>> startingAt(final int startingIndex) {
                        return new Under<List<Location>>(){

                            @Override
                            public List<Location> under(String path) {
                                return this.under(Location.create(Graph.this.createPath(path)));
                            }

                            @Override
                            public List<Location> under(Path path) {
                                return this.under(Location.create(path));
                            }

                            @Override
                            public List<Location> under(Property idProperty) {
                                return this.under(Location.create(idProperty));
                            }

                            @Override
                            public List<Location> under(Property firstIdProperty, Property ... additionalIdProperties) {
                                return this.under(Location.create(firstIdProperty, additionalIdProperties));
                            }

                            @Override
                            public List<Location> under(UUID uuid) {
                                return this.under(Location.create(uuid));
                            }

                            @Override
                            public List<Location> under(Location at) {
                                return Graph.this.requests.readBlockOfChildren(at, Graph.this.getCurrentWorkspaceName(), startingIndex, blockSize).getChildren();
                            }
                        };
                    }

                    @Override
                    public List<Location> startingAfter(Location previousSibling) {
                        return Graph.this.requests.readNextBlockOfChildren(previousSibling, Graph.this.getCurrentWorkspaceName(), blockSize).getChildren();
                    }

                    @Override
                    public List<Location> startingAfter(String pathOfPreviousSibling) {
                        return this.startingAfter(Location.create(Graph.this.createPath(pathOfPreviousSibling)));
                    }

                    @Override
                    public List<Location> startingAfter(Path pathOfPreviousSibling) {
                        return this.startingAfter(Location.create(pathOfPreviousSibling));
                    }

                    @Override
                    public List<Location> startingAfter(UUID uuidOfPreviousSibling) {
                        return this.startingAfter(Location.create(uuidOfPreviousSibling));
                    }

                    @Override
                    public List<Location> startingAfter(Property idPropertyOfPreviousSibling) {
                        return this.startingAfter(Location.create(idPropertyOfPreviousSibling));
                    }

                    @Override
                    public List<Location> startingAfter(Property firstIdProperyOfPreviousSibling, Property ... additionalIdPropertiesOfPreviousSibling) {
                        return this.startingAfter(Location.create(firstIdProperyOfPreviousSibling, additionalIdPropertiesOfPreviousSibling));
                    }
                };
            }
        };
    }

    public On<Property> getProperty(String name) {
        Name nameObj = (Name)this.getContext().getValueFactories().getNameFactory().create(name);
        return this.getProperty(nameObj);
    }

    public OnMultiple<Property> getProperty(final Name name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        return new OnMultiple<Property>(){

            @Override
            public Property on(String path) {
                return this.on(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Property on(Path path) {
                return this.on(Location.create(path));
            }

            @Override
            public Property on(Property idProperty) {
                return this.on(Location.create(idProperty));
            }

            @Override
            public Property on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Property on(Iterable<Property> idProperties) {
                return this.on(Location.create(idProperties));
            }

            @Override
            public Property on(UUID uuid) {
                return this.on(Location.create(uuid));
            }

            @Override
            public Property on(Location at) {
                return Graph.this.requests.readProperty(at, Graph.this.getCurrentWorkspaceName(), name).getProperty();
            }

            @Override
            public Map<Location, Property> on(Collection<Location> locations) {
                CheckArg.isNotNull(locations, (String)"locations");
                LinkedList<ReadPropertyRequest> requests = new LinkedList<ReadPropertyRequest>();
                String workspace = Graph.this.getCurrentWorkspaceName();
                for (Location location : locations) {
                    requests.add(new ReadPropertyRequest(location, workspace, name));
                }
                return this.execute(requests);
            }

            @Override
            public Map<Location, Property> on(Location first, Location ... additional) {
                CheckArg.isNotNull((Object)first, (String)"first");
                LinkedList<ReadPropertyRequest> requests = new LinkedList<ReadPropertyRequest>();
                String workspace = Graph.this.getCurrentWorkspaceName();
                requests.add(new ReadPropertyRequest(first, workspace, name));
                for (Location location : additional) {
                    requests.add(new ReadPropertyRequest(location, workspace, name));
                }
                return this.execute(requests);
            }

            @Override
            public Map<Location, Property> on(String first, String ... additional) {
                CheckArg.isNotNull((Object)first, (String)"first");
                LinkedList<ReadPropertyRequest> requests = new LinkedList<ReadPropertyRequest>();
                String workspace = Graph.this.getCurrentWorkspaceName();
                requests.add(new ReadPropertyRequest(Location.create(Graph.this.createPath(first)), workspace, name));
                for (String path : additional) {
                    requests.add(new ReadPropertyRequest(Location.create(Graph.this.createPath(path)), workspace, name));
                }
                return this.execute(requests);
            }

            @Override
            public Map<Location, Property> on(Path first, Path ... additional) {
                CheckArg.isNotNull((Object)first, (String)"first");
                LinkedList<ReadPropertyRequest> requests = new LinkedList<ReadPropertyRequest>();
                String workspace = Graph.this.getCurrentWorkspaceName();
                requests.add(new ReadPropertyRequest(Location.create(first), workspace, name));
                for (Path path : additional) {
                    requests.add(new ReadPropertyRequest(Location.create(path), workspace, name));
                }
                return this.execute(requests);
            }

            @Override
            public Map<Location, Property> on(UUID first, UUID ... additional) {
                CheckArg.isNotNull((Object)first, (String)"first");
                LinkedList<ReadPropertyRequest> requests = new LinkedList<ReadPropertyRequest>();
                String workspace = Graph.this.getCurrentWorkspaceName();
                requests.add(new ReadPropertyRequest(Location.create(first), workspace, name));
                for (UUID uuid : additional) {
                    requests.add(new ReadPropertyRequest(Location.create(uuid), workspace, name));
                }
                return this.execute(requests);
            }

            protected Map<Location, Property> execute(List<ReadPropertyRequest> requests) {
                Request composite = CompositeRequest.with(requests);
                Graph.this.execute(composite);
                HashMap<Location, Property> results = new HashMap<Location, Property>();
                for (ReadPropertyRequest request : requests) {
                    Property property = request.getProperty();
                    Location location = request.getActualLocationOfNode();
                    results.put(location, property);
                }
                return results;
            }
        };
    }

    public OnMultiple<Map<Name, Property>> getProperties(final Name ... names) {
        return new OnMultiple<Map<Name, Property>>(){

            @Override
            public Map<Name, Property> on(String path) {
                return this.on(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Map<Name, Property> on(Path path) {
                return this.on(Location.create(path));
            }

            @Override
            public Map<Name, Property> on(Property idProperty) {
                return this.on(Location.create(idProperty));
            }

            @Override
            public Map<Name, Property> on(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.on(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Map<Name, Property> on(Iterable<Property> idProperties) {
                return this.on(Location.create(idProperties));
            }

            @Override
            public Map<Name, Property> on(UUID uuid) {
                return this.on(Location.create(uuid));
            }

            @Override
            public Map<Name, Property> on(Location at) {
                LinkedList<ReadPropertyRequest> requests = new LinkedList<ReadPropertyRequest>();
                String workspace = Graph.this.getCurrentWorkspaceName();
                for (Name propertyName : names) {
                    requests.add(new ReadPropertyRequest(at, workspace, propertyName));
                }
                Request composite = CompositeRequest.with(requests);
                Graph.this.execute(composite);
                HashMap<Name, Property> results = new HashMap<Name, Property>();
                for (ReadPropertyRequest request : requests) {
                    Property property = request.getProperty();
                    results.put(property.getName(), property);
                }
                return results;
            }

            @Override
            public Map<Location, Map<Name, Property>> on(Collection<Location> locations) {
                CheckArg.isNotNull(locations, (String)"locations");
                LinkedList<ReadPropertyRequest> requests = new LinkedList<ReadPropertyRequest>();
                String workspace = Graph.this.getCurrentWorkspaceName();
                for (Location location : locations) {
                    if (location == null) continue;
                    for (Name propertyName : names) {
                        if (propertyName == null) continue;
                        requests.add(new ReadPropertyRequest(location, workspace, propertyName));
                    }
                }
                return this.execute(requests);
            }

            @Override
            public Map<Location, Map<Name, Property>> on(Location first, Location ... additional) {
                CheckArg.isNotNull((Object)first, (String)"first");
                LinkedList<ReadPropertyRequest> requests = new LinkedList<ReadPropertyRequest>();
                String workspace = Graph.this.getCurrentWorkspaceName();
                for (Location location : additional) {
                    if (location == null) continue;
                    for (Name propertyName : names) {
                        if (propertyName == null) continue;
                        requests.add(new ReadPropertyRequest(first, workspace, propertyName));
                        requests.add(new ReadPropertyRequest(location, workspace, propertyName));
                    }
                }
                return this.execute(requests);
            }

            @Override
            public Map<Location, Map<Name, Property>> on(Path first, Path ... additional) {
                CheckArg.isNotNull((Object)first, (String)"first");
                LinkedList<Location> locations = new LinkedList<Location>();
                locations.add(Location.create(first));
                for (Path path : additional) {
                    if (path == null) continue;
                    locations.add(Location.create(path));
                }
                return this.on((Collection<Location>)locations);
            }

            @Override
            public Map<Location, Map<Name, Property>> on(String first, String ... additional) {
                CheckArg.isNotNull((Object)first, (String)"first");
                LinkedList<Location> locations = new LinkedList<Location>();
                locations.add(Location.create(Graph.this.createPath(first)));
                for (String path : additional) {
                    if (path == null) continue;
                    locations.add(Location.create(Graph.this.createPath(path)));
                }
                return this.on((Collection<Location>)locations);
            }

            @Override
            public Map<Location, Map<Name, Property>> on(UUID first, UUID ... additional) {
                CheckArg.isNotNull((Object)first, (String)"first");
                LinkedList<Location> locations = new LinkedList<Location>();
                locations.add(Location.create(first));
                for (UUID uuid : additional) {
                    if (uuid == null) continue;
                    locations.add(Location.create(uuid));
                }
                return this.on((Collection<Location>)locations);
            }

            protected Map<Location, Map<Name, Property>> execute(List<ReadPropertyRequest> requests) {
                Request composite = CompositeRequest.with(requests);
                Graph.this.execute(composite);
                HashMap<Location, Map<Name, Property>> results = new HashMap<Location, Map<Name, Property>>();
                for (ReadPropertyRequest request : requests) {
                    Property property = request.getProperty();
                    if (property == null) continue;
                    Location location = request.getActualLocationOfNode();
                    HashMap<Name, Property> properties = (HashMap<Name, Property>)results.get(location);
                    if (properties == null) {
                        properties = new HashMap<Name, Property>();
                        results.put(location, properties);
                    }
                    properties.put(property.getName(), property);
                }
                return results;
            }
        };
    }

    public Node getNodeAt(UUID uuid) {
        return this.getNodeAt(Location.create(uuid));
    }

    public Node getNodeAt(Location location) {
        return new GraphNode(this.requests.readNode(location, this.getCurrentWorkspaceName()));
    }

    public Node getNodeAt(String path) {
        return this.getNodeAt(Location.create(this.createPath(path)));
    }

    public Node getNodeAt(Path path) {
        return this.getNodeAt(Location.create(path));
    }

    public Node getNodeAt(Property idProperty) {
        return this.getNodeAt(Location.create(idProperty));
    }

    public Node getNodeAt(Property firstIdProperty, Property ... additionalIdProperties) {
        return this.getNodeAt(Location.create(firstIdProperty, additionalIdProperties));
    }

    public Node getNodeAt(Iterable<Property> idProperties) {
        return this.getNodeAt(Location.create(idProperties));
    }

    public Node resolve(Reference reference) {
        CheckArg.isNotNull((Object)reference, (String)"reference");
        UUID uuid = (UUID)this.getContext().getValueFactories().getUuidFactory().create(reference);
        return this.getNodeAt(uuid);
    }

    public At<Subgraph> getSubgraphOfDepth(final int depth) {
        return new At<Subgraph>(){

            @Override
            public Subgraph at(Location location) {
                return new SubgraphResults(Graph.this.requests.readBranch(location, Graph.this.getCurrentWorkspaceName(), depth));
            }

            @Override
            public Subgraph at(String path) {
                return this.at(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Subgraph at(Path path) {
                return this.at(Location.create(path));
            }

            @Override
            public Subgraph at(UUID uuid) {
                return this.at(Location.create(uuid));
            }

            @Override
            public Subgraph at(Property idProperty) {
                return this.at(Location.create(idProperty));
            }

            @Override
            public Subgraph at(Property firstIdProperty, Property ... additionalIdProperties) {
                return this.at(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Subgraph at(Iterable<Property> idProperties) {
                return this.at(Location.create(idProperties));
            }
        };
    }

    public org.modeshape.graph.query.QueryResults search(String fullTextSearchExpression, int maxResults, int offset) {
        FullTextSearchRequest request = this.requests.search(this.getCurrentWorkspaceName(), fullTextSearchExpression, maxResults, offset);
        QueryResults results = new QueryResults(request.getResultColumns(), request.getStatistics(), request.getTuples());
        return results;
    }

    public BuildQuery query(final QueryCommand query, final Schemata schemata) {
        CheckArg.isNotNull((Object)query, (String)"query");
        CheckArg.isNotNull((Object)schemata, (String)"schemata");
        return new BuildQuery(){
            private PlanHints hints;
            private Problems problems;
            private Map<String, Object> variables;

            @Override
            public BuildQuery using(Map<String, Object> variables) {
                CheckArg.isNotNull(variables, (String)"variables");
                if (this.variables == null) {
                    this.variables = new HashMap<String, Object>();
                }
                this.variables.putAll(variables);
                return this;
            }

            @Override
            public BuildQuery using(String variableName, Object variableValue) {
                CheckArg.isNotNull((Object)variableName, (String)"variableName");
                if (this.variables == null) {
                    this.variables = new HashMap<String, Object>();
                }
                this.variables.put(variableName, variableValue);
                return this;
            }

            @Override
            public BuildQuery using(PlanHints hints) {
                this.hints = hints;
                return this;
            }

            @Override
            public org.modeshape.graph.query.QueryResults execute() {
                Batch batch = Graph.this.batch();
                TypeSystem typeSystem = Graph.this.getContext().getValueFactories().getTypeSystem();
                GraphQueryContext context = new GraphQueryContext(schemata, typeSystem, this.hints, this.problems, this.variables, batch);
                QueryEngine engine = Graph.this.getQueryEngine();
                return engine.execute(context, query);
            }
        };
    }

    protected QueryEngine getQueryEngine() {
        if (this.queryEngine == null) {
            this.queryEngine = this.getQueryEngine(new RuleBasedOptimizer());
        }
        return this.queryEngine;
    }

    protected QueryEngine getQueryEngine(Optimizer optimizer) {
        CanonicalPlanner planner = new CanonicalPlanner();
        QueryProcessor processor = new QueryProcessor(){

            @Override
            protected ProcessingComponent createAccessComponent(QueryCommand originalQuery, QueryContext context, PlanNode accessNode, QueryResults.Columns resultColumns, SelectComponent.Analyzer analyzer) {
                return new AccessQueryProcessor(Graph.this.getSourceName(), Graph.this.getCurrentWorkspaceName(), context, resultColumns, accessNode);
            }

            @Override
            protected void preExecute(QueryContext context) {
                ((GraphQueryContext)context).getBatch().execute();
            }
        };
        return new QueryEngine(planner, optimizer, processor);
    }

    public ImportInto<Conjunction<Graph>> importXmlFrom(final InputStream stream) {
        CheckArg.isNotNull((Object)stream, (String)"stream");
        return new ImportInto<Conjunction<Graph>>(){
            private boolean skipRootElement = false;
            private Name nameAttribute = JcrLexicon.NAME;
            private Name typeAttribute = JcrLexicon.PRIMARY_TYPE;

            @Override
            public ImportInto<Conjunction<Graph>> skippingRootElement(boolean skipRootElement) {
                this.skipRootElement = skipRootElement;
                return this;
            }

            @Override
            public ImportInto<Conjunction<Graph>> usingAttributeForName(String nameAttribute) {
                if (nameAttribute != null) {
                    this.nameAttribute = Graph.this.createName(nameAttribute);
                }
                return this;
            }

            @Override
            public ImportInto<Conjunction<Graph>> usingAttributeForName(Name nameAttribute) {
                if (nameAttribute != null) {
                    this.nameAttribute = nameAttribute;
                }
                return this;
            }

            @Override
            public ImportInto<Conjunction<Graph>> usingAttributeForType(String typeAttribute) {
                if (typeAttribute != null) {
                    this.typeAttribute = Graph.this.createName(typeAttribute);
                }
                return this;
            }

            @Override
            public ImportInto<Conjunction<Graph>> usingAttributeForType(Name typeAttribute) {
                if (typeAttribute != null) {
                    this.typeAttribute = typeAttribute;
                }
                return this;
            }

            @Override
            public Conjunction<Graph> into(String path) throws IOException, SAXException {
                return this.into(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> into(Path path) throws IOException, SAXException {
                return this.into(Location.create(path));
            }

            @Override
            public Conjunction<Graph> into(Property idProperty) throws IOException, SAXException {
                return this.into(Location.create(idProperty));
            }

            @Override
            public Conjunction<Graph> into(Property firstIdProperty, Property ... additionalIdProperties) throws IOException, SAXException {
                return this.into(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> into(Iterable<Property> idProperties) throws IOException, SAXException {
                return this.into(Location.create(idProperties));
            }

            @Override
            public Conjunction<Graph> into(UUID uuid) throws IOException, SAXException {
                return this.into(Location.create(uuid));
            }

            @Override
            public Conjunction<Graph> into(Location at) throws IOException, SAXException {
                final Name nameAttribute = this.nameAttribute;
                final Name typeAttribute = this.typeAttribute;
                GraphImporter importer = new GraphImporter(Graph.this){

                    @Override
                    protected Name getNameAttribute() {
                        return nameAttribute;
                    }

                    @Override
                    protected Name getTypeAttribute() {
                        return typeAttribute;
                    }
                };
                importer.importXml(stream, at, this.skipRootElement).execute();
                return Graph.this.nextGraph;
            }
        };
    }

    public ImportInto<Conjunction<Graph>> importXmlFrom(final URI uri) {
        return new ImportInto<Conjunction<Graph>>(){
            private boolean skipRootElement = false;
            private Name nameAttribute = JcrLexicon.NAME;
            private Name typeAttribute = JcrLexicon.PRIMARY_TYPE;

            @Override
            public ImportInto<Conjunction<Graph>> skippingRootElement(boolean skipRootElement) {
                this.skipRootElement = skipRootElement;
                return this;
            }

            @Override
            public ImportInto<Conjunction<Graph>> usingAttributeForName(String nameAttribute) {
                if (nameAttribute != null) {
                    this.nameAttribute = Graph.this.createName(nameAttribute);
                }
                return this;
            }

            @Override
            public ImportInto<Conjunction<Graph>> usingAttributeForName(Name nameAttribute) {
                if (nameAttribute != null) {
                    this.nameAttribute = nameAttribute;
                }
                return this;
            }

            @Override
            public ImportInto<Conjunction<Graph>> usingAttributeForType(String typeAttribute) {
                if (typeAttribute != null) {
                    this.typeAttribute = Graph.this.createName(typeAttribute);
                }
                return this;
            }

            @Override
            public ImportInto<Conjunction<Graph>> usingAttributeForType(Name typeAttribute) {
                if (typeAttribute != null) {
                    this.typeAttribute = typeAttribute;
                }
                return this;
            }

            @Override
            public Conjunction<Graph> into(String path) throws IOException, SAXException {
                return this.into(Location.create(Graph.this.createPath(path)));
            }

            @Override
            public Conjunction<Graph> into(Path path) throws IOException, SAXException {
                return this.into(Location.create(path));
            }

            @Override
            public Conjunction<Graph> into(Property idProperty) throws IOException, SAXException {
                return this.into(Location.create(idProperty));
            }

            @Override
            public Conjunction<Graph> into(Property firstIdProperty, Property ... additionalIdProperties) throws IOException, SAXException {
                return this.into(Location.create(firstIdProperty, additionalIdProperties));
            }

            @Override
            public Conjunction<Graph> into(Iterable<Property> idProperties) throws IOException, SAXException {
                return this.into(Location.create(idProperties));
            }

            @Override
            public Conjunction<Graph> into(UUID uuid) throws IOException, SAXException {
                return this.into(Location.create(uuid));
            }

            @Override
            public Conjunction<Graph> into(Location at) throws IOException, SAXException {
                final Name nameAttribute = this.nameAttribute;
                final Name typeAttribute = this.typeAttribute;
                GraphImporter importer = new GraphImporter(Graph.this){

                    @Override
                    protected Name getNameAttribute() {
                        return nameAttribute;
                    }

                    @Override
                    protected Name getTypeAttribute() {
                        return typeAttribute;
                    }
                };
                importer.importXml(uri, at, this.skipRootElement).execute();
                return Graph.this.nextGraph;
            }
        };
    }

    public ImportInto<Conjunction<Graph>> importXmlFrom(String pathToFile) {
        CheckArg.isNotEmpty((String)pathToFile, (String)"pathToFile");
        File file = new File(pathToFile);
        if (file.exists() && file.canRead()) {
            return this.importXmlFrom(new File(pathToFile).toURI());
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(pathToFile);
        if (stream != null) {
            try {
                stream.close();
                return this.importXmlFrom(pathToFile, classLoader);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            return this.importXmlFrom(new URI(pathToFile));
        }
        catch (URISyntaxException e) {
            return this.importXmlFrom(pathToFile, this.getClass().getClassLoader());
        }
    }

    public ImportInto<Conjunction<Graph>> importXmlFrom(String resourceName, ClassLoader classLoader) {
        CheckArg.isNotEmpty((String)resourceName, (String)"resourceName");
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        InputStream stream = null;
        RuntimeException error = null;
        try {
            stream = this.getClass().getResourceAsStream(resourceName);
            ImportInto<Conjunction<Graph>> importInto = this.importXmlFrom(stream);
            return importInto;
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        finally {
            block11: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable e2) {
                        if (error != null) break block11;
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
    }

    public ImportInto<Conjunction<Graph>> importXmlFrom(File file) {
        CheckArg.isNotNull((Object)file, (String)"file");
        return this.importXmlFrom(file.toURI());
    }

    protected Path createPath(String path) {
        return (Path)this.getContext().getValueFactories().getPathFactory().create(path);
    }

    protected Name createName(String name) {
        return (Name)this.getContext().getValueFactories().getNameFactory().create(name);
    }

    protected List<Path.Segment> getSegments(List<Location> locations) {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(locations.size());
        for (Location location : locations) {
            segments.add(location.getPath().getLastSegment());
        }
        return segments;
    }

    public Batch batch() {
        return new Batch(new BatchRequestBuilder());
    }

    public Batch batch(BatchRequestBuilder builder) {
        CheckArg.isNotNull((Object)builder, (String)"builder");
        return new Batch(builder);
    }

    protected Object convertReferenceValue(Object value) {
        if (value instanceof Node) {
            Node node = (Node)value;
            UUID uuid = node.getLocation().getUuid();
            if (uuid == null) {
                Property uuidProperty = node.getProperty(ModeShapeLexicon.UUID);
                if (uuidProperty != null) {
                    uuid = (UUID)this.getContext().getValueFactories().getUuidFactory().create(uuidProperty.getFirstValue());
                } else {
                    uuidProperty = node.getProperty(JcrLexicon.UUID);
                    if (uuidProperty != null) {
                        uuid = (UUID)this.getContext().getValueFactories().getUuidFactory().create(uuidProperty.getFirstValue());
                    }
                }
            }
            if (uuid == null) {
                String nodeString = node.getLocation().getString(this.getContext().getNamespaceRegistry());
                String msg = GraphI18n.unableToCreateReferenceToNodeWithoutUuid.text(new Object[]{nodeString});
                throw new IllegalArgumentException(msg);
            }
            return this.getContext().getValueFactories().getReferenceFactory().create(uuid);
        }
        if (value instanceof Location) {
            Location location = (Location)value;
            UUID uuid = location.getUuid();
            if (uuid == null) {
                String nodeString = location.getString(this.getContext().getNamespaceRegistry());
                String msg = GraphI18n.unableToCreateReferenceToNodeWithoutUuid.text(new Object[]{nodeString});
                throw new IllegalArgumentException(msg);
            }
            return this.getContext().getValueFactories().getReferenceFactory().create(uuid);
        }
        return value;
    }

    protected static DateTime computeExpirationTime(CacheableRequest request) {
        CachePolicy policy = request.getCachePolicy();
        return policy == null ? null : request.getTimeLoaded().plus(policy.getTimeToLive(), TimeUnit.MILLISECONDS);
    }

    @Immutable
    public static interface BaseResults<NodeType extends Node>
    extends Iterable<NodeType> {
        public Graph getGraph();

        public NodeType getNode(String var1);

        public NodeType getNode(Path var1);

        public NodeType getNode(Location var1);

        public boolean includes(String var1);

        public boolean includes(Path var1);

        public boolean includes(Location var1);
    }

    @Immutable
    protected static final class GraphWorkspace
    implements Workspace {
        private final String name;
        private final Location root;

        GraphWorkspace(String name, Location root) {
            assert (name != null);
            assert (root != null);
            this.name = name;
            this.root = root;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Location getRoot() {
            return this.root;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof GraphWorkspace) {
                GraphWorkspace that = (GraphWorkspace)obj;
                return this.getName().equals(that.getName());
            }
            return false;
        }

        public String toString() {
            return "Workspace \"" + this.name + "\" (root = " + this.root + " )";
        }
    }

    @NotThreadSafe
    protected abstract class CreateNodeNamedAction<T>
    extends AbstractAction<T>
    implements CreateNodeNamed<T> {
        private final Location parent;

        protected CreateNodeNamedAction(T afterConjunction, Location parent) {
            super(afterConjunction);
            this.parent = parent;
        }

        @Override
        public CreateAction<T> nodeNamed(String name) {
            NameFactory factory = Graph.this.getContext().getValueFactories().getNameFactory();
            Name nameObj = (Name)factory.create(name);
            return this.createWith(this.afterConjunction(), this.parent, nameObj);
        }

        @Override
        public CreateAction<T> nodeNamed(Name name) {
            return this.createWith(this.afterConjunction(), this.parent, name);
        }

        protected abstract CreateAction<T> createWith(T var1, Location var2, Name var3);
    }

    @NotThreadSafe
    protected abstract class CreateAction<T>
    extends AbstractAction<T>
    implements Create<T> {
        private final String workspaceName;
        private final Location parent;
        private final Name childName;
        private final Map<Name, Property> properties;
        private boolean submitted;
        private NodeConflictBehavior conflictBehavior;

        CreateAction(T afterConjunction, Location parent, String workspaceName, Name childName) {
            super(afterConjunction);
            this.properties = new HashMap<Name, Property>();
            this.submitted = false;
            this.conflictBehavior = NodeConflictBehavior.APPEND;
            this.parent = parent;
            this.workspaceName = workspaceName;
            this.childName = childName;
        }

        @Override
        public CreateAction<T> ifAbsent() {
            this.conflictBehavior = NodeConflictBehavior.DO_NOT_REPLACE;
            return this;
        }

        @Override
        public CreateAction<T> orReplace() {
            this.conflictBehavior = NodeConflictBehavior.REPLACE;
            return this;
        }

        @Override
        public CreateAction<T> orUpdate() {
            this.conflictBehavior = NodeConflictBehavior.UPDATE;
            return this;
        }

        @Override
        public CreateAction<T> byAppending() {
            this.conflictBehavior = NodeConflictBehavior.APPEND;
            return this;
        }

        @Override
        public Create<T> and(UUID uuid) {
            PropertyFactory factory = Graph.this.getContext().getPropertyFactory();
            this.properties.put(ModeShapeLexicon.UUID, factory.create(ModeShapeLexicon.UUID, uuid));
            return this;
        }

        @Override
        public Create<T> and(Property property) {
            this.properties.put(property.getName(), property);
            return this;
        }

        @Override
        public Create<T> and(Iterable<Property> properties) {
            for (Property property : properties) {
                this.properties.put(property.getName(), property);
            }
            return this;
        }

        @Override
        public Create<T> and(String name, Object ... values) {
            ExecutionContext context = Graph.this.getContext();
            PropertyFactory factory = context.getPropertyFactory();
            NameFactory nameFactory = context.getValueFactories().getNameFactory();
            Name propertyName = (Name)nameFactory.create(name);
            this.properties.put(propertyName, factory.create(propertyName, values));
            return this;
        }

        @Override
        public Create<T> and(Name name, Object ... values) {
            PropertyFactory factory = Graph.this.getContext().getPropertyFactory();
            this.properties.put(name, factory.create(name, values));
            return this;
        }

        @Override
        public Create<T> and(Property property, Property ... additionalProperties) {
            this.properties.put(property.getName(), property);
            for (Property additionalProperty : additionalProperties) {
                this.properties.put(additionalProperty.getName(), additionalProperty);
            }
            return this;
        }

        @Override
        public Create<T> with(UUID uuid) {
            return this.and(uuid);
        }

        @Override
        public Create<T> with(Property property) {
            return this.and(property);
        }

        @Override
        public Create<T> with(Iterable<Property> properties) {
            return this.and(properties);
        }

        @Override
        public Create<T> with(Property property, Property ... additionalProperties) {
            return this.and(property, additionalProperties);
        }

        @Override
        public Create<T> with(String name, Object ... values) {
            return this.and(name, values);
        }

        @Override
        public Create<T> with(Name name, Object ... values) {
            return this.and(name, values);
        }

        protected abstract T submit(Location var1, String var2, Name var3, Collection<Property> var4, NodeConflictBehavior var5);

        @Override
        public T and() {
            if (!this.submitted) {
                this.submit(this.parent, this.workspaceName, this.childName, this.properties.values(), this.conflictBehavior);
                this.submitted = true;
            }
            return super.and();
        }
    }

    @NotThreadSafe
    public abstract class CloneTargetAction<T>
    extends AbstractAction<T>
    implements Into<WithUuids<T>> {
        protected final CloneAction<T> source;

        CloneTargetAction(T afterConjunction, CloneAction<T> source) {
            super(afterConjunction);
            this.source = source;
        }

        protected abstract T submit(Location var1, boolean var2);

        @Override
        public WithUuids<T> into(final Location into) {
            return new WithUuids<T>(){

                @Override
                public T failingIfAnyUuidsMatch() {
                    CloneTargetAction.this.submit(into, false);
                    return CloneTargetAction.this.and();
                }

                @Override
                public T replacingExistingNodesWithSameUuids() {
                    CloneTargetAction.this.submit(into, true);
                    return CloneTargetAction.this.and();
                }
            };
        }

        @Override
        public WithUuids<T> into(Path into) {
            return this.into(Location.create(into));
        }

        @Override
        public WithUuids<T> into(UUID into) {
            return this.into(Location.create(into));
        }

        @Override
        public WithUuids<T> into(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.into(Location.create(firstIdProperty, additionalIdProperties));
        }

        @Override
        public WithUuids<T> into(Property into) {
            return this.into(Location.create(into));
        }

        @Override
        public WithUuids<T> into(String into) {
            return this.into(Location.create(this.createPath(into)));
        }
    }

    @NotThreadSafe
    public abstract class CloneAction<T>
    extends AbstractAction<T>
    implements Clone<T> {
        protected final Location from;

        CloneAction(T afterConjunction, Location from) {
            super(afterConjunction);
            this.from = from;
        }

        protected abstract T submit(String var1, Location var2, String var3, Location var4, Name var5, Path.Segment var6, boolean var7);

        @Override
        public AsChild<Into<WithUuids<T>>> fromWorkspace(final String workspaceName) {
            final CloneAction source = this;
            return new AsChild<Into<WithUuids<T>>>(){

                @Override
                public Into<WithUuids<T>> as(final Name name) {
                    return new CloneTargetAction<T>(CloneAction.this.afterConjunction(), source){

                        @Override
                        protected T submit(Location into, boolean removeExisting) {
                            String intoWorkspaceName = Graph.this.getCurrentWorkspaceName();
                            return this.source.submit(workspaceName, CloneAction.this.from, intoWorkspaceName, into, name, null, removeExisting);
                        }
                    };
                }

                @Override
                public Into<WithUuids<T>> as(String name) {
                    return this.as((Name)Graph.this.getContext().getValueFactories().getNameFactory().create(name));
                }

                @Override
                public Into<WithUuids<T>> as(final Path.Segment segment) {
                    return new CloneTargetAction<T>(CloneAction.this.afterConjunction(), source){

                        @Override
                        protected T submit(Location into, boolean removeExisting) {
                            String intoWorkspaceName = Graph.this.getCurrentWorkspaceName();
                            return this.source.submit(workspaceName, CloneAction.this.from, intoWorkspaceName, into, null, segment, removeExisting);
                        }
                    };
                }
            };
        }
    }

    @NotThreadSafe
    protected abstract class CopyAction<T>
    extends AbstractAction<T>
    implements Copy<T> {
        protected Locations from;
        protected String fromWorkspaceName;

        CopyAction(T afterConjunction, Location from) {
            super(afterConjunction);
            this.from = new Locations(from);
            this.fromWorkspaceName = Graph.this.getCurrentWorkspaceName();
        }

        @Override
        public Copy<T> and(Location from) {
            this.from.add(from);
            return this;
        }

        @Override
        public Copy<T> and(String from) {
            this.from.add(Location.create(this.createPath(from)));
            return this;
        }

        @Override
        public Copy<T> and(Path from) {
            this.from.add(Location.create(from));
            return this;
        }

        @Override
        public Copy<T> and(Property firstFrom, Property ... additionalFroms) {
            this.from.add(Location.create(firstFrom, additionalFroms));
            return this;
        }

        @Override
        public Copy<T> and(Iterable<Property> idProperties) {
            this.from.add(Location.create(idProperties));
            return this;
        }

        @Override
        public Copy<T> and(Property from) {
            this.from.add(Location.create(from));
            return this;
        }

        @Override
        public Copy<T> and(UUID from) {
            this.from.add(Location.create(from));
            return this;
        }

        protected abstract T submit(String var1, Locations var2, Location var3, Name var4);

        @Override
        public CopyTarget<T> fromWorkspace(String workspaceName) {
            this.fromWorkspaceName = workspaceName;
            return this;
        }

        @Override
        public T into(Location into) {
            return this.submit(this.fromWorkspaceName, this.from, into, null);
        }

        @Override
        public T into(Path into) {
            return this.submit(this.fromWorkspaceName, this.from, Location.create(into), null);
        }

        @Override
        public T into(UUID into) {
            return this.submit(this.fromWorkspaceName, this.from, Location.create(into), null);
        }

        @Override
        public T into(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.submit(this.fromWorkspaceName, this.from, Location.create(firstIdProperty, additionalIdProperties), null);
        }

        @Override
        public T into(Property into) {
            return this.submit(this.fromWorkspaceName, this.from, Location.create(into), null);
        }

        @Override
        public T into(String into) {
            return this.submit(this.fromWorkspaceName, this.from, Location.create(this.createPath(into)), null);
        }

        @Override
        public T to(Location desiredLocation) {
            if (!desiredLocation.hasPath()) {
                throw new IllegalArgumentException(GraphI18n.unableToCopyToLocationWithoutAPath.text(new Object[]{this.from, desiredLocation}));
            }
            Path desiredPath = desiredLocation.getPath();
            if (desiredPath.isRoot()) {
                throw new IllegalArgumentException(GraphI18n.unableToCopyToTheRoot.text(new Object[]{this.from, desiredLocation}));
            }
            Path parent = desiredPath.getParent();
            return this.submit(this.fromWorkspaceName, this.from, Location.create(parent), desiredPath.getLastSegment().getName());
        }

        @Override
        public T to(Path desiredPath) {
            if (desiredPath.isRoot()) {
                throw new IllegalArgumentException(GraphI18n.unableToCopyToTheRoot.text(new Object[]{this.from, desiredPath}));
            }
            Path parent = desiredPath.getParent();
            return this.submit(this.fromWorkspaceName, this.from, Location.create(parent), desiredPath.getLastSegment().getName());
        }

        @Override
        public T to(String desiredPath) {
            return this.to(this.createPath(desiredPath));
        }
    }

    @NotThreadSafe
    protected abstract class MoveAction<T>
    extends AbstractAction<T>
    implements Move<T> {
        private final Locations from;
        private Name newName;

        MoveAction(T afterConjunction, Location from) {
            super(afterConjunction);
            this.from = new Locations(from);
        }

        @Override
        public Move<T> and(Location from) {
            this.from.add(from);
            return this;
        }

        @Override
        public Move<T> and(String from) {
            this.from.add(Location.create(this.createPath(from)));
            return this;
        }

        @Override
        public Move<T> and(Path from) {
            this.from.add(Location.create(from));
            return this;
        }

        @Override
        public Move<T> and(Property firstFrom, Property ... additionalFroms) {
            this.from.add(Location.create(firstFrom, additionalFroms));
            return this;
        }

        @Override
        public Move<T> and(Iterable<Property> idPropertiesFrom) {
            this.from.add(Location.create(idPropertiesFrom));
            return this;
        }

        @Override
        public Move<T> and(Property from) {
            this.from.add(Location.create(from));
            return this;
        }

        @Override
        public Move<T> and(UUID from) {
            this.from.add(Location.create(from));
            return this;
        }

        @Override
        public Into<T> as(Name newName) {
            this.newName = newName;
            return this;
        }

        @Override
        public Into<T> as(String newName) {
            return this.as(this.createName(newName));
        }

        protected abstract T submit(Locations var1, Location var2, Location var3, Name var4);

        protected T submit(Locations from, Location into, Name newName) {
            return this.submit(from, into, null, newName);
        }

        @Override
        public T into(Location into) {
            return this.submit(this.from, into, null, this.newName);
        }

        @Override
        public T into(Path into) {
            return this.submit(this.from, Location.create(into), this.newName);
        }

        @Override
        public T into(UUID into) {
            return this.submit(this.from, Location.create(into), this.newName);
        }

        @Override
        public T into(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.submit(this.from, Location.create(firstIdProperty, additionalIdProperties), this.newName);
        }

        @Override
        public T into(Property into) {
            return this.submit(this.from, Location.create(into), this.newName);
        }

        @Override
        public T into(String into) {
            return this.submit(this.from, Location.create(this.createPath(into)), this.newName);
        }

        @Override
        public T before(Location before) {
            return this.submit(this.from, null, before, this.newName);
        }

        @Override
        public T before(Path before) {
            return this.submit(this.from, null, Location.create(before), this.newName);
        }

        @Override
        public T before(UUID before) {
            return this.submit(this.from, null, Location.create(before), this.newName);
        }

        @Override
        public T before(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.submit(this.from, null, Location.create(firstIdProperty, additionalIdProperties), this.newName);
        }

        @Override
        public T before(Property before) {
            return this.submit(this.from, null, Location.create(before), this.newName);
        }

        @Override
        public T before(String before) {
            return this.submit(this.from, null, Location.create(this.createPath(before)), this.newName);
        }
    }

    @Immutable
    protected abstract class AbstractAction<T>
    implements Conjunction<T> {
        private final T afterConjunction;

        AbstractAction(T afterConjunction) {
            this.afterConjunction = afterConjunction;
        }

        T afterConjunction() {
            return this.afterConjunction;
        }

        @Override
        public T and() {
            return this.afterConjunction;
        }

        Path createPath(String path) {
            return (Path)Graph.this.getContext().getValueFactories().getPathFactory().create(path);
        }

        Name createName(String name) {
            return (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(name);
        }
    }

    @Immutable
    class SubgraphNodeImpl
    implements SubgraphNode {
        private final Location location;
        private final ReadBranchRequest request;

        SubgraphNodeImpl(Location location, ReadBranchRequest request) {
            this.location = location;
            this.request = request;
        }

        @Override
        public DateTime getExpirationTime() {
            return Graph.computeExpirationTime(this.request);
        }

        @Override
        public List<Location> getChildren() {
            List<Location> children = this.request.getChildren(this.location);
            if (children == null) {
                children = NO_CHILDREN;
            }
            return children;
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public Collection<Property> getProperties() {
            return this.getPropertiesByName().values();
        }

        @Override
        public Map<Name, Property> getPropertiesByName() {
            return this.request.getPropertiesFor(this.location);
        }

        @Override
        public Property getProperty(Name name) {
            return this.getPropertiesByName().get(name);
        }

        @Override
        public Property getProperty(String nameStr) {
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(nameStr);
            return this.getPropertiesByName().get(name);
        }

        @Override
        public boolean hasChildren() {
            return this.getChildren().size() != 0;
        }

        @Override
        public List<Path.Segment> getChildrenSegments() {
            return Graph.this.getSegments(this.getChildren());
        }

        @Override
        public Iterator<Location> iterator() {
            return this.getChildren().iterator();
        }

        @Override
        public SubgraphNode getNode(String childName) {
            Path path = Graph.this.getContext().getValueFactories().getPathFactory().create(this.location.getPath(), childName);
            Location location = this.request.getLocationFor(path);
            if (location == null) {
                return null;
            }
            return new SubgraphNodeImpl(location, this.request);
        }

        @Override
        public SubgraphNode getNode(Name childName) {
            Path path = Graph.this.getContext().getValueFactories().getPathFactory().create(this.location.getPath(), childName);
            Location location = this.request.getLocationFor(path);
            if (location == null) {
                return null;
            }
            return new SubgraphNodeImpl(location, this.request);
        }

        @Override
        public SubgraphNode getNode(Path.Segment childSegment) {
            Path path = Graph.this.getContext().getValueFactories().getPathFactory().create(this.location.getPath(), childSegment);
            Location location = this.request.getLocationFor(path = path.getNormalizedPath());
            if (location == null) {
                return null;
            }
            return new SubgraphNodeImpl(location, this.request);
        }

        @Override
        public SubgraphNode getNode(Path relativePath) {
            Path path = Graph.this.getContext().getValueFactories().getPathFactory().create(this.location.getPath(), relativePath);
            Location location = this.request.getLocationFor(path = path.getNormalizedPath());
            if (location == null) {
                return null;
            }
            return new SubgraphNodeImpl(location, this.request);
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node that = (Node)obj;
                return this.location.isSame(that.getLocation());
            }
            return false;
        }

        public String toString() {
            return this.getNodeString(Graph.this.getContext(), this.location);
        }

        private String getNodeString(ExecutionContext context, Location location) {
            StringBuilder sb = new StringBuilder();
            sb.append('<');
            ValueFactory<String> strings = context.getValueFactories().getStringFactory();
            String name = "";
            name = location.getPath().getLastSegment() != null ? strings.create(location.getPath().getLastSegment()) : strings.create(location.getPath());
            if (name.startsWith("{")) {
                int end = name.indexOf(125);
                name = name.substring(end + 1, name.length());
            }
            sb.append("name = ").append('\"').append(name).append('\"').append(" ");
            boolean first = true;
            if (this.getProperties() != null) {
                for (Property entry : this.getProperties()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" ");
                    }
                    sb.append(this.getPropertyString(entry));
                }
            }
            sb.append(">\n");
            return sb.toString();
        }

        private String getPropertyString(Property property) {
            StringBuilder sb = new StringBuilder();
            sb.append(Graph.this.getContext().getValueFactories().getStringFactory().create(property.getName()));
            sb.append(" = ");
            if (property.isEmpty()) {
                sb.append("null");
            } else if (property.isSingle()) {
                String valueStr = Graph.this.getContext().getValueFactories().getStringFactory().create(property.getValues().next());
                sb.append('\"').append(valueStr).append('\"');
            } else {
                sb.append('[');
                boolean first = true;
                for (Object value : property.getValuesAsArray()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    String valueStr = Graph.this.getContext().getValueFactories().getStringFactory().create(value);
                    sb.append('\"').append(valueStr).append('\"');
                }
                if (property.isMultiple()) {
                    sb.append(']');
                }
            }
            return sb.toString();
        }
    }

    @Immutable
    class SubgraphResults
    implements Subgraph {
        private final ReadBranchRequest request;

        SubgraphResults(ReadBranchRequest request) {
            this.request = request;
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public Location getLocation() {
            return this.request.getActualLocationOfNode();
        }

        @Override
        public SubgraphNode getRoot() {
            return this.getNode(this.getLocation());
        }

        @Override
        public int getMaximumDepth() {
            return this.request.maximumDepth();
        }

        @Override
        public Iterator<SubgraphNode> iterator() {
            final Iterator<Location> iter = this.request.iterator();
            return new Iterator<SubgraphNode>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public SubgraphNode next() {
                    return SubgraphResults.this.getNode((Location)iter.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean includes(Path path) {
            CheckArg.isNotNull((Object)path, (String)"path");
            path = this.getAbsolutePath(path);
            return this.request.includes(path);
        }

        @Override
        public boolean includes(Location location) {
            CheckArg.isNotNull((Object)location, (String)"location");
            return this.request.includes(location);
        }

        @Override
        public boolean includes(String pathStr) {
            Path path = Graph.this.createPath(pathStr);
            path = this.getAbsolutePath(path);
            return this.includes(path);
        }

        @Override
        public SubgraphNode getNode(Location location) {
            if (!location.hasPath()) {
                return null;
            }
            Location actualLocation = this.request.getLocationFor(location.getPath());
            if (actualLocation == null) {
                return null;
            }
            return new SubgraphNodeImpl(actualLocation, this.request);
        }

        @Override
        public SubgraphNode getNode(Path path) {
            if (!this.includes(path = this.getAbsolutePath(path))) {
                return null;
            }
            Location location = this.request.getLocationFor(path);
            if (location == null) {
                return null;
            }
            return new SubgraphNodeImpl(location, this.request);
        }

        @Override
        public SubgraphNode getNode(String pathStr) {
            CheckArg.isNotEmpty((String)pathStr, (String)"path");
            Path path = Graph.this.createPath(pathStr);
            path = this.getAbsolutePath(path);
            return this.getNode(path);
        }

        @Override
        public SubgraphNode getNode(Name relativePath) {
            Path path = this.getGraph().getContext().getValueFactories().getPathFactory().create(this.getLocation().getPath(), relativePath);
            path = path.getNormalizedPath();
            return this.getNode(path);
        }

        protected Path getAbsolutePath(Path absoluteOrRelative) {
            Path result = absoluteOrRelative;
            if (!result.isAbsolute()) {
                result = this.getGraph().getContext().getValueFactories().getPathFactory().create(this.getLocation().getPath(), result);
                result = result.getNormalizedPath();
            }
            return result;
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SubgraphResults) {
                SubgraphResults that = (SubgraphResults)obj;
                return this.getLocation().equals(that.getLocation()) && this.request.equals(that.request);
            }
            if (obj instanceof Subgraph) {
                Subgraph that = (Subgraph)obj;
                if (!this.getLocation().equals(that.getLocation())) {
                    return false;
                }
                Iterator<SubgraphNode> thisIter = this.iterator();
                Iterator thatIter = that.iterator();
                while (thisIter.hasNext() && thatIter.hasNext()) {
                    SubgraphNode thisNode = thisIter.next();
                    SubgraphNode thatNode = (SubgraphNode)thatIter.next();
                    if (!thisNode.getLocation().equals(thatNode.getLocation())) {
                        return false;
                    }
                    if (!((Object)thisNode.getProperties()).equals(thatNode.getProperties())) {
                        return false;
                    }
                    if (((Object)thisNode.getChildren()).equals(thatNode.getChildren())) continue;
                    return false;
                }
                return !thisIter.hasNext() && !thatIter.hasNext();
            }
            return false;
        }

        public String toString() {
            return "Subgraph\n" + this.getToString(Graph.this.getContext());
        }

        public String getToString(ExecutionContext context) {
            StringBuilder sb = new StringBuilder();
            this.getRecursiveString(context, this.getRoot(), sb, 0);
            return sb.toString();
        }

        private void getRecursiveString(ExecutionContext context, SubgraphNode node, StringBuilder str, int indentLevel) {
            for (int i = 0; i < indentLevel; ++i) {
                str.append("  ");
            }
            str.append(node.toString());
            for (Location nextLoc : node.getChildren()) {
                SubgraphNode childNode = this.getNode(nextLoc);
                if (childNode == null) continue;
                this.getRecursiveString(context, childNode, str, indentLevel + 1);
            }
        }
    }

    @Immutable
    class BatchResultsNode
    implements Node {
        private final Location location;
        private final DateTime expirationTime;
        private Map<Name, Property> properties;
        private List<Location> children;

        BatchResultsNode(Location location, DateTime expirationTime) {
            this.location = location;
            this.expirationTime = expirationTime;
        }

        @Override
        public DateTime getExpirationTime() {
            return this.expirationTime;
        }

        void addProperty(Property property) {
            if (this.properties == null) {
                this.properties = new HashMap<Name, Property>();
            }
            this.properties.put(property.getName(), property);
        }

        void setProperties(Map<Name, Property> properties) {
            this.properties = properties;
        }

        void setChildren(List<Location> children) {
            this.children = children;
        }

        void freeze() {
            this.properties = this.properties != null ? Collections.unmodifiableMap(this.properties) : Collections.emptyMap();
            this.children = this.children != null ? Collections.unmodifiableList(this.children) : Collections.emptyList();
        }

        @Override
        public List<Path.Segment> getChildrenSegments() {
            return Graph.this.getSegments(this.getChildren());
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public Collection<Property> getProperties() {
            return this.properties.values();
        }

        @Override
        public Map<Name, Property> getPropertiesByName() {
            return this.properties;
        }

        @Override
        public Property getProperty(Name name) {
            return this.properties.get(name);
        }

        @Override
        public Property getProperty(String nameStr) {
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(nameStr);
            return this.properties.get(name);
        }

        @Override
        public List<Location> getChildren() {
            return this.children;
        }

        @Override
        public boolean hasChildren() {
            return this.children.size() != 0;
        }

        @Override
        public Iterator<Location> iterator() {
            return this.children.iterator();
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node that = (Node)obj;
                return this.location.isSame(that.getLocation());
            }
            return false;
        }

        public String toString() {
            return "Node " + this.getLocation().toString();
        }
    }

    @Immutable
    class BatchResults
    implements Results {
        private final Map<Path, BatchResultsNode> nodes = new HashMap<Path, BatchResultsNode>();
        private final List<Request> requests;

        BatchResults(List<Request> requests) {
            this.requests = Collections.unmodifiableList(requests);
            block8: for (Request request : requests) {
                switch (request.getType()) {
                    case READ_ALL_PROPERTIES: {
                        ReadAllPropertiesRequest readAll = (ReadAllPropertiesRequest)request;
                        DateTime expires = Graph.computeExpirationTime(readAll);
                        this.getOrCreateNode(readAll.getActualLocationOfNode(), expires).setProperties(readAll.getPropertiesByName());
                        break;
                    }
                    case READ_PROPERTY: {
                        ReadPropertyRequest read = (ReadPropertyRequest)request;
                        DateTime expires = Graph.computeExpirationTime(read);
                        this.getOrCreateNode(read.getActualLocationOfNode(), expires).addProperty(read.getProperty());
                        break;
                    }
                    case READ_NODE: {
                        ReadNodeRequest readNode = (ReadNodeRequest)request;
                        DateTime expires = Graph.computeExpirationTime(readNode);
                        BatchResultsNode node = this.getOrCreateNode(readNode.getActualLocationOfNode(), expires);
                        node.setProperties(readNode.getPropertiesByName());
                        node.setChildren(readNode.getChildren());
                        break;
                    }
                    case READ_BLOCK_OF_CHILDREN: {
                        throw new IllegalStateException();
                    }
                    case READ_ALL_CHILDREN: {
                        ReadAllChildrenRequest readAllChildren = (ReadAllChildrenRequest)request;
                        DateTime expires = Graph.computeExpirationTime(readAllChildren);
                        this.getOrCreateNode(readAllChildren.getActualLocationOfNode(), expires).setChildren(readAllChildren.getChildren());
                        break;
                    }
                    case READ_BRANCH: {
                        BatchResultsNode node;
                        ReadBranchRequest readBranch = (ReadBranchRequest)request;
                        DateTime expires = Graph.computeExpirationTime(readBranch);
                        for (Location location : readBranch) {
                            node = this.getOrCreateNode(location, expires);
                            node.setProperties(readBranch.getPropertiesFor(location));
                            node.setChildren(readBranch.getChildren(location));
                        }
                        continue block8;
                    }
                }
            }
            for (Map.Entry entry : this.nodes.entrySet()) {
                ((BatchResultsNode)entry.getValue()).freeze();
            }
        }

        BatchResults(Request request) {
            this.requests = Collections.singletonList(request);
            switch (request.getType()) {
                case READ_ALL_PROPERTIES: {
                    ReadAllPropertiesRequest readAll = (ReadAllPropertiesRequest)request;
                    DateTime expires = Graph.computeExpirationTime(readAll);
                    this.getOrCreateNode(readAll.getActualLocationOfNode(), expires).setProperties(readAll.getPropertiesByName());
                    break;
                }
                case READ_PROPERTY: {
                    ReadPropertyRequest read = (ReadPropertyRequest)request;
                    DateTime expires = Graph.computeExpirationTime(read);
                    this.getOrCreateNode(read.getActualLocationOfNode(), expires).addProperty(read.getProperty());
                    break;
                }
                case READ_NODE: {
                    ReadNodeRequest readNode = (ReadNodeRequest)request;
                    DateTime expires = Graph.computeExpirationTime(readNode);
                    BatchResultsNode node = this.getOrCreateNode(readNode.getActualLocationOfNode(), expires);
                    node.setProperties(readNode.getPropertiesByName());
                    node.setChildren(readNode.getChildren());
                    break;
                }
                case READ_BLOCK_OF_CHILDREN: {
                    throw new IllegalStateException();
                }
                case READ_ALL_CHILDREN: {
                    ReadAllChildrenRequest readAllChildren = (ReadAllChildrenRequest)request;
                    DateTime expires = Graph.computeExpirationTime(readAllChildren);
                    this.getOrCreateNode(readAllChildren.getActualLocationOfNode(), expires).setChildren(readAllChildren.getChildren());
                    break;
                }
                case READ_BRANCH: {
                    BatchResultsNode node;
                    ReadBranchRequest readBranch = (ReadBranchRequest)request;
                    DateTime expires = Graph.computeExpirationTime(readBranch);
                    for (Location location : readBranch) {
                        node = this.getOrCreateNode(location, expires);
                        node.setProperties(readBranch.getPropertiesFor(location));
                        node.setChildren(readBranch.getChildren(location));
                    }
                    break;
                }
            }
            for (Map.Entry<Path, BatchResultsNode> entry : this.nodes.entrySet()) {
                entry.getValue().freeze();
            }
        }

        BatchResults() {
            this.requests = Collections.emptyList();
        }

        @Override
        public List<Request> getRequests() {
            return this.requests;
        }

        private BatchResultsNode getOrCreateNode(Location location, DateTime expirationTime) {
            BatchResultsNode node = this.nodes.get(location);
            if (node == null) {
                node = new BatchResultsNode(location, expirationTime);
                assert (location != null);
                assert (location.getPath() != null);
                this.nodes.put(location.getPath(), node);
            }
            return node;
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        protected void checkIsAbsolute(Path path) {
            if (!path.isAbsolute()) {
                throw new IllegalArgumentException(GraphI18n.pathIsNotAbsolute.text(new Object[]{path}));
            }
        }

        @Override
        public Node getNode(String pathStr) {
            Path path = Graph.this.createPath(pathStr);
            this.checkIsAbsolute(path);
            return this.nodes.get(path);
        }

        @Override
        public Node getNode(Path path) {
            CheckArg.isNotNull((Object)path, (String)"path");
            this.checkIsAbsolute(path);
            return this.nodes.get(path);
        }

        @Override
        public Node getNode(Location location) {
            CheckArg.isNotNull((Object)location, (String)"location");
            CheckArg.isNotNull((Object)location.getPath(), (String)"location.getPath()");
            return this.nodes.get(location.getPath());
        }

        @Override
        public boolean includes(String path) {
            return this.getNode(path) != null;
        }

        @Override
        public boolean includes(Path path) {
            return this.getNode(path) != null;
        }

        @Override
        public boolean includes(Location location) {
            return this.getNode(location) != null;
        }

        @Override
        public Iterator<Node> iterator() {
            ArrayList<Path> paths = new ArrayList<Path>(this.nodes.keySet());
            Collections.sort(paths);
            final Iterator pathIter = paths.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return pathIter.hasNext();
                }

                @Override
                public Node next() {
                    Path nextPath = (Path)pathIter.next();
                    return BatchResults.this.getNode(nextPath);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    @Immutable
    protected class GraphNode
    implements Node {
        private final ReadNodeRequest request;

        GraphNode(ReadNodeRequest request) {
            this.request = request;
        }

        @Override
        public Location getLocation() {
            return this.request.getActualLocationOfNode();
        }

        @Override
        public DateTime getExpirationTime() {
            CachePolicy policy = this.request.getCachePolicy();
            return policy == null ? null : this.request.getTimeLoaded().plus(policy.getTimeToLive(), TimeUnit.MILLISECONDS);
        }

        @Override
        public Graph getGraph() {
            return Graph.this;
        }

        @Override
        public Collection<Property> getProperties() {
            return this.request.getProperties();
        }

        @Override
        public Property getProperty(Name name) {
            return this.getPropertiesByName().get(name);
        }

        @Override
        public Property getProperty(String nameStr) {
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(nameStr);
            return this.getPropertiesByName().get(name);
        }

        @Override
        public Map<Name, Property> getPropertiesByName() {
            return this.request.getPropertiesByName();
        }

        @Override
        public List<Location> getChildren() {
            return this.request.getChildren();
        }

        @Override
        public boolean hasChildren() {
            return this.request.getChildren().size() > 0;
        }

        @Override
        public List<Path.Segment> getChildrenSegments() {
            return Graph.this.getSegments(this.getChildren());
        }

        @Override
        public Iterator<Location> iterator() {
            return this.request.getChildren().iterator();
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node that = (Node)obj;
                return this.getLocation().isSame(that.getLocation());
            }
            return false;
        }

        public String toString() {
            return "Node " + this.getLocation().toString();
        }
    }

    public static interface GetNodeConjunction<Next>
    extends Conjunction<Next> {
        public Node andReturn();
    }

    public static interface BatchConjunction
    extends Conjunction<Batch>,
    Executable<Node> {
    }

    public static interface ImportInto<Next> {
        public ImportInto<Next> usingAttributeForName(String var1);

        public ImportInto<Next> usingAttributeForName(Name var1);

        public ImportInto<Next> usingAttributeForType(String var1);

        public ImportInto<Next> usingAttributeForType(Name var1);

        public ImportInto<Next> skippingRootElement(boolean var1);

        public Next into(Location var1) throws IOException, SAXException;

        public Next into(String var1) throws IOException, SAXException;

        public Next into(Path var1) throws IOException, SAXException;

        public Next into(UUID var1) throws IOException, SAXException;

        public Next into(Property var1) throws IOException, SAXException;

        public Next into(Property var1, Property ... var2) throws IOException, SAXException;

        public Next into(Iterable<Property> var1) throws IOException, SAXException;
    }

    public static interface CreateNodeNamed<Next> {
        public Create<Next> nodeNamed(String var1);

        public Create<Next> nodeNamed(Name var1);
    }

    public static interface CreateNode<Next> {
        public Next node(String var1, Property ... var2);

        public Next node(String var1, Iterator<Property> var2);

        public Next node(String var1, Iterable<Property> var2);
    }

    public static interface SetValuesTo<Next> {
        public Next to(Node var1);

        public Next to(Location var1);

        public Next to(String var1);

        public Next to(int var1);

        public Next to(long var1);

        public Next to(boolean var1);

        public Next to(float var1);

        public Next to(double var1);

        public Next to(BigDecimal var1);

        public Next to(Calendar var1);

        public Next to(Date var1);

        public Next to(DateTime var1);

        public Next to(Name var1);

        public Next to(Path var1);

        public Next to(Reference var1);

        public Next to(URI var1);

        public Next to(UUID var1);

        public Next to(Binary var1);

        public Next to(byte[] var1);

        public Next to(InputStream var1, long var2);

        public Next to(Reader var1, long var2);

        public Next to(Object var1);

        public Next to(Object[] var1);

        public Next to(Object var1, Object ... var2);

        public Next to(Iterable<?> var1);

        public Next to(Iterator<?> var1);
    }

    public static interface SetValues<Next>
    extends On<SetValuesTo<Next>>,
    SetValuesTo<On<Next>> {
    }

    public abstract class RemoveValueAction<T>
    extends AbstractAction<T>
    implements RemoveValue<T> {
        protected final String workspaceName;
        protected final List<Object> values;

        protected RemoveValueAction(T afterConjunction, String workspaceName, Object firstValue) {
            super(afterConjunction);
            this.values = new LinkedList<Object>();
            this.workspaceName = workspaceName;
            this.values.add(firstValue);
        }

        @Override
        public RemoveValue<T> andValue(Object nextValue) {
            this.values.add(nextValue);
            return this;
        }

        @Override
        public On<T> from(String name) {
            return this.from(this.createName(name));
        }

        @Override
        public On<T> from(final Name name) {
            return new On<T>(){

                @Override
                public T on(Iterable<Property> idProperties) {
                    return this.on(Location.create(idProperties));
                }

                @Override
                public T on(Location to) {
                    return RemoveValueAction.this.submit(RemoveValueAction.this.workspaceName, to, name, RemoveValueAction.this.values);
                }

                @Override
                public T on(Path to) {
                    return this.on(Location.create(to));
                }

                @Override
                public T on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public T on(Property idProperty) {
                    return this.on(Location.create(idProperty));
                }

                @Override
                public T on(String toPath) {
                    return this.on(Location.create(RemoveValueAction.this.createPath(toPath)));
                }

                @Override
                public T on(UUID to) {
                    return this.on(Location.create(to));
                }
            };
        }

        protected abstract T submit(String var1, Location var2, Name var3, List<Object> var4);
    }

    public abstract class AddValueAction<T>
    extends AbstractAction<T>
    implements AddValue<T> {
        protected final String workspaceName;
        protected final List<Object> values;

        protected AddValueAction(T afterConjunction, String workspaceName, Object firstValue) {
            super(afterConjunction);
            this.values = new LinkedList<Object>();
            this.workspaceName = workspaceName;
            this.values.add(firstValue);
        }

        @Override
        public AddValue<T> andValue(Object nextValue) {
            this.values.add(nextValue);
            return this;
        }

        @Override
        public On<T> to(String name) {
            return this.to(this.createName(name));
        }

        @Override
        public On<T> to(final Name name) {
            return new On<T>(){

                @Override
                public T on(Iterable<Property> idProperties) {
                    return this.on(Location.create(idProperties));
                }

                @Override
                public T on(Location to) {
                    return AddValueAction.this.submit(AddValueAction.this.workspaceName, to, name, AddValueAction.this.values);
                }

                @Override
                public T on(Path to) {
                    return this.on(Location.create(to));
                }

                @Override
                public T on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public T on(Property idProperty) {
                    return this.on(Location.create(idProperty));
                }

                @Override
                public T on(String toPath) {
                    return this.on(Location.create(AddValueAction.this.createPath(toPath)));
                }

                @Override
                public T on(UUID to) {
                    return this.on(Location.create(to));
                }
            };
        }

        protected abstract T submit(String var1, Location var2, Name var3, List<Object> var4);
    }

    public static interface RemoveValue<Next>
    extends FromName<On<Next>> {
        public RemoveValue<Next> andValue(Object var1);
    }

    public static interface AddValue<Next>
    extends ToName<On<Next>> {
        public AddValue<Next> andValue(Object var1);
    }

    public static interface Under<Next> {
        public Next under(Location var1);

        public Next under(String var1);

        public Next under(Path var1);

        public Next under(UUID var1);

        public Next under(Property var1);

        public Next under(Property var1, Property ... var2);
    }

    public static interface BlockOfChildren<Next> {
        public Under<Next> startingAt(int var1);

        public Next startingAfter(Location var1);

        public Next startingAfter(String var1);

        public Next startingAfter(Path var1);

        public Next startingAfter(UUID var1);

        public Next startingAfter(Property var1);

        public Next startingAfter(Property var1, Property ... var2);
    }

    public static interface Children<Next>
    extends Of<Next> {
        public BlockOfChildren<Next> inBlockOf(int var1);
    }

    public static interface At<Next> {
        public Next at(Location var1);

        public Next at(String var1);

        public Next at(Path var1);

        public Next at(UUID var1);

        public Next at(Property var1);

        public Next at(Property var1, Property ... var2);

        public Next at(Iterable<Property> var1);
    }

    public static interface Of<Next> {
        public Next of(Location var1);

        public Next of(String var1);

        public Next of(Path var1);

        public Next of(UUID var1);

        public Next of(Property var1);

        public Next of(Property var1, Property ... var2);

        public Next of(Iterable<Property> var1);
    }

    public static interface OnMultiple<Next>
    extends On<Next> {
        public Map<Location, Next> on(Collection<Location> var1);

        public Map<Location, Next> on(Location var1, Location ... var2);

        public Map<Location, Next> on(String var1, String ... var2);

        public Map<Location, Next> on(Path var1, Path ... var2);

        public Map<Location, Next> on(UUID var1, UUID ... var2);
    }

    public static interface On<Next> {
        public Next on(Location var1);

        public Next on(String var1);

        public Next on(Path var1);

        public Next on(UUID var1);

        public Next on(Property var1);

        public Next on(Property var1, Property ... var2);

        public Next on(Iterable<Property> var1);
    }

    public static interface CreateAt<Next>
    extends Conjunction<Next> {
        public CreateAt<Next> with(UUID var1);

        public CreateAt<Next> with(Property var1);

        public CreateAt<Next> with(Iterable<Property> var1);

        public CreateAt<Next> with(String var1, Object ... var2);

        public CreateAt<Next> with(Name var1, Object ... var2);

        public CreateAt<Next> with(Property var1, Property ... var2);

        public CreateAt<Next> and(UUID var1);

        public CreateAt<Next> and(Property var1);

        public CreateAt<Next> and(Iterable<Property> var1);

        public CreateAt<Next> and(String var1, Object ... var2);

        public CreateAt<Next> and(Name var1, Object ... var2);

        public CreateAt<Next> and(Property var1, Property ... var2);

        public Location getLocation();

        public Node getNode();
    }

    public static interface Create<Next>
    extends Conjunction<Next> {
        public Create<Next> ifAbsent();

        public Create<Next> orUpdate();

        public Create<Next> orReplace();

        public Create<Next> byAppending();

        public Create<Next> with(UUID var1);

        public Create<Next> with(Property var1);

        public Create<Next> with(Iterable<Property> var1);

        public Create<Next> with(String var1, Object ... var2);

        public Create<Next> with(Name var1, Object ... var2);

        public Create<Next> with(Property var1, Property ... var2);

        public Create<Next> and(UUID var1);

        public Create<Next> and(Property var1);

        public Create<Next> and(Iterable<Property> var1);

        public Create<Next> and(String var1, Object ... var2);

        public Create<Next> and(Name var1, Object ... var2);

        public Create<Next> and(Property var1, Property ... var2);
    }

    @NotThreadSafe
    protected abstract class LockAction<T>
    extends AbstractAction<T>
    implements LockScope<LockTimeout<T>> {
        private final Location target;

        LockAction(T afterConjunction, Location target) {
            super(afterConjunction);
            this.target = target;
        }

        protected abstract T submit(Location var1, LockBranchRequest.LockScope var2, long var3);

        @Override
        public LockTimeout<T> andItsDescendants() {
            return new LockTimeout<T>(){

                @Override
                public T withDefaultTimeout() {
                    return LockAction.this.submit(LockAction.this.target, LockBranchRequest.LockScope.SELF_AND_DESCENDANTS, 0L);
                }

                @Override
                public T withTimeoutOf(long milliseconds) {
                    return LockAction.this.submit(LockAction.this.target, LockBranchRequest.LockScope.SELF_AND_DESCENDANTS, milliseconds);
                }
            };
        }

        @Override
        public LockTimeout<T> only() {
            return new LockTimeout<T>(){

                @Override
                public T withDefaultTimeout() {
                    return LockAction.this.submit(LockAction.this.target, LockBranchRequest.LockScope.SELF_ONLY, 0L);
                }

                @Override
                public T withTimeoutOf(long milliseconds) {
                    return LockAction.this.submit(LockAction.this.target, LockBranchRequest.LockScope.SELF_ONLY, milliseconds);
                }
            };
        }
    }

    public static interface LockTimeout<Next> {
        public Next withDefaultTimeout();

        public Next withTimeoutOf(long var1);
    }

    public static interface LockScope<Next> {
        public Next andItsDescendants();

        public Next only();
    }

    public static interface WithUuids<Next> {
        public Next failingIfAnyUuidsMatch();

        public Next replacingExistingNodesWithSameUuids();
    }

    public static interface FromWorkspace<Next> {
        public Next fromWorkspace(String var1);
    }

    public static interface Clone<Next>
    extends FromWorkspace<AsChild<Into<WithUuids<Next>>>> {
    }

    public static interface CopyTarget<Next>
    extends To<Next>,
    Into<Next> {
    }

    public static interface Copy<Next>
    extends FromWorkspace<CopyTarget<Next>>,
    CopyTarget<Next>,
    And<Copy<Next>> {
    }

    public static interface Move<Next>
    extends AsName<Into<Next>>,
    Into<Next>,
    Before<Next>,
    And<Move<Next>> {
    }

    public static interface And<Next> {
        public Next and(Location var1);

        public Next and(String var1);

        public Next and(Path var1);

        public Next and(UUID var1);

        public Next and(Property var1);

        public Next and(Property var1, Property ... var2);

        public Next and(Iterable<Property> var1);
    }

    public static interface AsName<Next> {
        public Next as(String var1);

        public Next as(Name var1);
    }

    public static interface AsChild<Next> {
        public Next as(Path.Segment var1);

        public Next as(Name var1);

        public Next as(String var1);
    }

    public static interface To<Next> {
        public Next to(Location var1);

        public Next to(String var1);

        public Next to(Path var1);
    }

    public static interface FromName<Next> {
        public Next from(String var1);

        public Next from(Name var1);
    }

    public static interface ToName<Next> {
        public Next to(String var1);

        public Next to(Name var1);
    }

    public static interface Before<Next> {
        public Next before(Location var1);

        public Next before(String var1);

        public Next before(Path var1);

        public Next before(UUID var1);

        public Next before(Property var1);

        public Next before(Property var1, Property ... var2);
    }

    public static interface Into<Next> {
        public Next into(Location var1);

        public Next into(String var1);

        public Next into(Path var1);

        public Next into(UUID var1);

        public Next into(Property var1);

        public Next into(Property var1, Property ... var2);
    }

    public static interface Conjunction<Next> {
        public Next and();
    }

    public static interface Executable<NodeType extends Node> {
        public Results execute();
    }

    public static interface DestroyWorkspace {
        public boolean named(String var1);
    }

    public static interface CreateWorkspace
    extends NameWorkspace {
        public NameWorkspace clonedFrom(String var1);
    }

    public static interface NameWorkspace {
        public Workspace named(String var1);

        public Workspace namedSomethingLike(String var1);
    }

    public static interface BuildQuery {
        public BuildQuery using(PlanHints var1);

        public BuildQuery using(Map<String, Object> var1);

        public BuildQuery using(String var1, Object var2);

        public org.modeshape.graph.query.QueryResults execute();
    }

    @Immutable
    public final class Batch
    implements Executable<Node> {
        protected final BatchRequestBuilder requestQueue;
        protected final BatchConjunction nextRequests;
        protected final String workspaceName;
        protected boolean executed = false;

        Batch(BatchRequestBuilder builder) {
            assert (builder != null);
            this.requestQueue = builder;
            this.workspaceName = Graph.this.getCurrentWorkspaceName();
            this.nextRequests = new BatchConjunction(){

                @Override
                public Batch and() {
                    return Batch.this;
                }

                @Override
                public Results execute() {
                    return Batch.this.execute();
                }
            };
        }

        public boolean hasExecuted() {
            return this.executed;
        }

        public boolean isExecuteRequired() {
            return !this.executed && this.requestQueue.hasRequests();
        }

        public Graph getGraph() {
            return Graph.this;
        }

        public String getCurrentWorkspaceName() {
            return this.workspaceName;
        }

        protected final void assertNotExecuted() {
            if (this.executed) {
                throw new IllegalStateException(GraphI18n.unableToAddMoreRequestsToAlreadyExecutedBatch.text(new Object[0]));
            }
        }

        public Move<BatchConjunction> move(Node from) {
            return this.move(from.getLocation());
        }

        public final Move<BatchConjunction> move(Location from) {
            this.assertNotExecuted();
            return new MoveAction<BatchConjunction>(this.nextRequests, from){

                @Override
                protected BatchConjunction submit(Locations from, Location into, Location before, Name newName) {
                    String workspaceName = Batch.this.getCurrentWorkspaceName();
                    do {
                        Batch.this.requestQueue.moveBranch(from.getLocation(), into, before, workspaceName, newName);
                    } while ((from = from.next()) != null);
                    return (BatchConjunction)this.and();
                }
            };
        }

        public Move<BatchConjunction> move(String fromPath) {
            return this.move(Location.create(Graph.this.createPath(fromPath)));
        }

        public Move<BatchConjunction> move(Path from) {
            return this.move(Location.create(from));
        }

        public Move<BatchConjunction> move(UUID from) {
            return this.move(Location.create(from));
        }

        public Move<BatchConjunction> move(Property idProperty) {
            return this.move(Location.create(idProperty));
        }

        public Move<BatchConjunction> move(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.move(Location.create(firstIdProperty, additionalIdProperties));
        }

        public Move<BatchConjunction> move(Iterable<Property> idProperties) {
            return this.move(Location.create(idProperties));
        }

        public LockScope<LockTimeout<BatchConjunction>> lock(Node at) {
            return this.lock(at.getLocation());
        }

        public LockScope<LockTimeout<BatchConjunction>> lock(String atPath) {
            return this.lock(Location.create(Graph.this.createPath(atPath)));
        }

        public LockScope<LockTimeout<BatchConjunction>> lock(Path at) {
            return this.lock(Location.create(at));
        }

        public LockScope<LockTimeout<BatchConjunction>> lock(UUID at) {
            return this.lock(Location.create(at));
        }

        public LockScope<LockTimeout<BatchConjunction>> lock(Property idProperty) {
            return this.lock(Location.create(idProperty));
        }

        public LockScope<LockTimeout<BatchConjunction>> lock(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.lock(Location.create(firstIdProperty, additionalIdProperties));
        }

        public LockScope<LockTimeout<BatchConjunction>> lock(Location at) {
            return new LockAction<BatchConjunction>(this.nextRequests, at){

                @Override
                protected BatchConjunction submit(Location target, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) {
                    String workspaceName = Batch.this.getCurrentWorkspaceName();
                    Graph.this.requests.lockBranch(workspaceName, target, lockScope, lockTimeoutInMillis);
                    return (BatchConjunction)this.and();
                }
            };
        }

        public BatchConjunction unlock(Node at) {
            return this.unlock(at.getLocation());
        }

        public BatchConjunction unlock(String atPath) {
            return this.unlock(Location.create(Graph.this.createPath(atPath)));
        }

        public BatchConjunction unlock(Path at) {
            return this.unlock(Location.create(at));
        }

        public BatchConjunction unlock(UUID at) {
            return this.unlock(Location.create(at));
        }

        public BatchConjunction unlock(Property idProperty) {
            return this.unlock(Location.create(idProperty));
        }

        public BatchConjunction unlock(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.unlock(Location.create(firstIdProperty, additionalIdProperties));
        }

        public BatchConjunction unlock(Location at) {
            Graph.this.requests.unlockBranch(this.workspaceName, at);
            return this.nextRequests;
        }

        public Clone<BatchConjunction> clone(Node from) {
            return this.clone(from.getLocation());
        }

        public Clone<BatchConjunction> clone(Location from) {
            this.assertNotExecuted();
            return new CloneAction<BatchConjunction>(this.nextRequests, from){

                @Override
                protected BatchConjunction submit(String fromWorkspaceName, Location from, String intoWorkspaceName, Location into, Name desiredName, Path.Segment desiredSegment, boolean removeExisting) {
                    Batch.this.requestQueue.cloneBranch(from, fromWorkspaceName, into, intoWorkspaceName, desiredName, desiredSegment, removeExisting);
                    return (BatchConjunction)this.and();
                }
            };
        }

        public Clone<BatchConjunction> clone(String fromPath) {
            return this.clone(Location.create(Graph.this.createPath(fromPath)));
        }

        public Clone<BatchConjunction> clone(Path from) {
            return this.clone(Location.create(from));
        }

        public Clone<BatchConjunction> clone(UUID from) {
            return this.clone(Location.create(from));
        }

        public Clone<BatchConjunction> clone(Property idProperty) {
            return this.clone(Location.create(idProperty));
        }

        public Clone<BatchConjunction> clone(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.clone(Location.create(firstIdProperty, additionalIdProperties));
        }

        public Clone<BatchConjunction> clone(Iterable<Property> idProperties) {
            return this.clone(Location.create(idProperties));
        }

        public Copy<BatchConjunction> copy(Node from) {
            return this.copy(from.getLocation());
        }

        public Copy<BatchConjunction> copy(Location from) {
            this.assertNotExecuted();
            return new CopyAction<BatchConjunction>(this.nextRequests, from){

                @Override
                protected BatchConjunction submit(String fromWorkspaceName, Locations from, Location into, Name copyName) {
                    String intoWorkspaceName = Batch.this.getCurrentWorkspaceName();
                    if (fromWorkspaceName == null) {
                        fromWorkspaceName = intoWorkspaceName;
                    }
                    do {
                        Batch.this.requestQueue.copyBranch(from.getLocation(), fromWorkspaceName, into, intoWorkspaceName, copyName, null);
                    } while ((from = from.next()) != null);
                    return (BatchConjunction)this.and();
                }
            };
        }

        public Copy<BatchConjunction> copy(String fromPath) {
            return this.copy(Location.create(Graph.this.createPath(fromPath)));
        }

        public Copy<BatchConjunction> copy(Path from) {
            return this.copy(Location.create(from));
        }

        public Copy<BatchConjunction> copy(UUID from) {
            return this.copy(Location.create(from));
        }

        public Copy<BatchConjunction> copy(Property idProperty) {
            return this.copy(Location.create(idProperty));
        }

        public Copy<BatchConjunction> copy(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.copy(Location.create(firstIdProperty, additionalIdProperties));
        }

        public Copy<BatchConjunction> copy(Iterable<Property> idProperties) {
            return this.copy(Location.create(idProperties));
        }

        public BatchConjunction delete(Node at) {
            return this.delete(at.getLocation());
        }

        public BatchConjunction delete(Location at) {
            this.assertNotExecuted();
            this.requestQueue.deleteBranch(at, this.getCurrentWorkspaceName());
            return this.nextRequests;
        }

        public BatchConjunction delete(String atPath) {
            return this.delete(Location.create(Graph.this.createPath(atPath)));
        }

        public BatchConjunction delete(Path at) {
            return this.delete(Location.create(at));
        }

        public BatchConjunction delete(UUID at) {
            return this.delete(Location.create(at));
        }

        public BatchConjunction delete(Property idProperty) {
            return this.delete(Location.create(idProperty));
        }

        public BatchConjunction delete(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.delete(Location.create(firstIdProperty, additionalIdProperties));
        }

        public BatchConjunction delete(Iterable<Property> idProperties) {
            return this.delete(Location.create(idProperties));
        }

        public Create<Batch> create(String atPath) {
            return this.create(Graph.this.createPath(atPath));
        }

        public Create<Batch> create(String atPath, Property property) {
            return this.create(Graph.this.createPath(atPath)).with(property);
        }

        public Create<Batch> create(String atPath, Property firstProperty, Property ... additionalProperties) {
            return this.create(Graph.this.createPath(atPath)).with(firstProperty, additionalProperties);
        }

        public final Create<Batch> create(Path at) {
            this.assertNotExecuted();
            CheckArg.isNotNull((Object)at, (String)"at");
            Path parent = at.getParent();
            Name name = at.getLastSegment().getName();
            return this.create(Location.create(parent), name);
        }

        protected final CreateAction<Batch> create(Location parent, Name child) {
            return new CreateAction<Batch>(this, parent, this.getCurrentWorkspaceName(), child){

                @Override
                protected Batch submit(Location parent, String workspaceName, Name childName, Collection<Property> properties, NodeConflictBehavior behavior) {
                    Batch.this.requestQueue.createNode(parent, workspaceName, childName, properties.iterator(), behavior);
                    return Batch.this;
                }
            };
        }

        public Create<Batch> create(Path at, Iterable<Property> properties) {
            Create<Batch> action = this.create(at);
            for (Property property : properties) {
                action.and(property);
            }
            return action;
        }

        public Create<Batch> create(Path at, Property property) {
            return this.create(at).with(property);
        }

        public Create<Batch> create(Path at, Property firstProperty, Property ... additionalProperties) {
            return this.create(at).with(firstProperty, additionalProperties);
        }

        public CreateNodeNamed<Batch> createUnder(Location parent) {
            CheckArg.isNotNull((Object)parent, (String)"parent");
            return new CreateNodeNamedAction<Batch>(this, parent){

                @Override
                protected CreateAction<Batch> createWith(Batch batch, Location parent, Name childName) {
                    return Batch.this.create(parent, childName);
                }
            };
        }

        public AddValue<Batch> addValue(Object value) {
            return new AddValueAction<Batch>(this, this.getCurrentWorkspaceName(), value){

                @Override
                protected Batch submit(String workspaceName, Location on, Name property, List<Object> values) {
                    Graph.this.requests.addValues(workspaceName, on, property, values);
                    return (Batch)Batch.this.nextRequests.and();
                }
            };
        }

        public RemoveValue<Batch> removeValue(Object value) {
            return new RemoveValueAction<Batch>(this, this.getCurrentWorkspaceName(), value){

                @Override
                protected Batch submit(String workspaceName, Location on, Name property, List<Object> values) {
                    Graph.this.requests.removeValues(workspaceName, on, property, values);
                    return (Batch)Batch.this.nextRequests.and();
                }
            };
        }

        public On<BatchConjunction> set(final Property ... properties) {
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(Location location) {
                    Batch.this.requestQueue.setProperties(location, Batch.this.getCurrentWorkspaceName(), properties);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction on(String path) {
                    return this.on(Location.create(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(Location.create(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(Location.create(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(Iterable<Property> idProperties) {
                    return this.on(Location.create(idProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(Location.create(uuid));
                }
            };
        }

        public SetValues<BatchConjunction> set(String propertyName) {
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(propertyName);
            return this.set(name);
        }

        public SetValues<BatchConjunction> set(final Name propertyName) {
            return new SetValues<BatchConjunction>(){

                @Override
                public SetValuesTo<BatchConjunction> on(final Location location) {
                    return new SetValuesTo<BatchConjunction>(){

                        @Override
                        public BatchConjunction to(Node value) {
                            return this.to(value.getLocation());
                        }

                        @Override
                        public BatchConjunction to(Location value) {
                            Reference ref = (Reference)Graph.this.convertReferenceValue(value);
                            Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, ref);
                            Batch.this.requestQueue.setProperty(location, Batch.this.getCurrentWorkspaceName(), property);
                            return Batch.this.nextRequests;
                        }

                        protected BatchConjunction toValue(Object value) {
                            Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, value);
                            Batch.this.requestQueue.setProperty(location, Batch.this.getCurrentWorkspaceName(), property);
                            return Batch.this.nextRequests;
                        }

                        @Override
                        public BatchConjunction to(String value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(int value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(long value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(boolean value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(float value) {
                            return this.toValue(Float.valueOf(value));
                        }

                        @Override
                        public BatchConjunction to(double value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(BigDecimal value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(Calendar value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(Date value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(DateTime value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(Name value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(Path value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(Reference value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(URI value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(UUID value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(Binary value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(byte[] value) {
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(InputStream stream, long approximateLength) {
                            Binary value = (Binary)Graph.this.getContext().getValueFactories().getBinaryFactory().create(stream, approximateLength);
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(Reader reader, long approximateLength) {
                            Binary value = (Binary)Graph.this.getContext().getValueFactories().getBinaryFactory().create(reader, approximateLength);
                            return this.toValue(value);
                        }

                        @Override
                        public BatchConjunction to(Object value) {
                            value = Graph.this.convertReferenceValue(value);
                            Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, value);
                            Batch.this.requestQueue.setProperty(location, Batch.this.getCurrentWorkspaceName(), property);
                            return Batch.this.nextRequests;
                        }

                        @Override
                        public BatchConjunction to(Object firstValue, Object ... otherValues) {
                            firstValue = Graph.this.convertReferenceValue(firstValue);
                            int len = otherValues.length;
                            for (int i = 0; i != len; ++i) {
                                otherValues[i] = Graph.this.convertReferenceValue(otherValues[i]);
                            }
                            Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, firstValue, otherValues);
                            Batch.this.requestQueue.setProperty(location, Batch.this.getCurrentWorkspaceName(), property);
                            return Batch.this.nextRequests;
                        }

                        @Override
                        public BatchConjunction to(Object[] values) {
                            for (int i = 0; i != values.length; ++i) {
                                values[i] = Graph.this.convertReferenceValue(values[i]);
                            }
                            Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, values);
                            Batch.this.requestQueue.setProperty(location, Batch.this.getCurrentWorkspaceName(), property);
                            return Batch.this.nextRequests;
                        }

                        @Override
                        public BatchConjunction to(Iterable<?> values) {
                            LinkedList valueList = new LinkedList();
                            for (Object value : values) {
                                value = Graph.this.convertReferenceValue(value);
                                valueList.add(value);
                            }
                            Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, valueList);
                            Batch.this.requestQueue.setProperty(location, Batch.this.getCurrentWorkspaceName(), property);
                            return Batch.this.nextRequests;
                        }

                        @Override
                        public BatchConjunction to(Iterator<?> values) {
                            LinkedList valueList = new LinkedList();
                            while (values.hasNext()) {
                                Object value = values.next();
                                valueList.add(value);
                            }
                            Property property = Graph.this.getContext().getPropertyFactory().create(propertyName, valueList);
                            Batch.this.requestQueue.setProperty(location, Batch.this.getCurrentWorkspaceName(), property);
                            return Batch.this.nextRequests;
                        }
                    };
                }

                @Override
                public SetValuesTo<BatchConjunction> on(String path) {
                    return this.on(Location.create(Graph.this.createPath(path)));
                }

                @Override
                public SetValuesTo<BatchConjunction> on(Path path) {
                    return this.on(Location.create(path));
                }

                @Override
                public SetValuesTo<BatchConjunction> on(Property idProperty) {
                    return this.on(Location.create(idProperty));
                }

                @Override
                public SetValuesTo<BatchConjunction> on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public SetValuesTo<BatchConjunction> on(Iterable<Property> idProperties) {
                    return this.on(Location.create(idProperties));
                }

                @Override
                public SetValuesTo<BatchConjunction> on(UUID uuid) {
                    return this.on(Location.create(uuid));
                }

                @Override
                public On<BatchConjunction> to(Node value) {
                    Object reference = Graph.this.convertReferenceValue(value);
                    return Batch.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, reference));
                }

                @Override
                public On<BatchConjunction> to(Location value) {
                    Object reference = Graph.this.convertReferenceValue(value);
                    return Batch.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, reference));
                }

                protected On<BatchConjunction> toValue(Object value) {
                    return Batch.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, value));
                }

                @Override
                public On<BatchConjunction> to(String value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(int value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(long value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(boolean value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(float value) {
                    return this.toValue(Float.valueOf(value));
                }

                @Override
                public On<BatchConjunction> to(double value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(BigDecimal value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(Calendar value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(Date value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(DateTime value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(Name value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(Path value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(Reference value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(URI value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(UUID value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(Binary value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(byte[] value) {
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(InputStream stream, long approximateLength) {
                    Binary value = (Binary)Graph.this.getContext().getValueFactories().getBinaryFactory().create(stream, approximateLength);
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(Reader reader, long approximateLength) {
                    Binary value = (Binary)Graph.this.getContext().getValueFactories().getBinaryFactory().create(reader, approximateLength);
                    return this.toValue(value);
                }

                @Override
                public On<BatchConjunction> to(Object value) {
                    value = Graph.this.convertReferenceValue(value);
                    return Batch.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, value));
                }

                @Override
                public On<BatchConjunction> to(Object firstValue, Object ... otherValues) {
                    Object[] values = new Object[otherValues.length + 1];
                    values[0] = Graph.this.convertReferenceValue(firstValue);
                    int len = otherValues.length;
                    for (int i = 0; i != len; ++i) {
                        values[i + 1] = Graph.this.convertReferenceValue(otherValues[i]);
                    }
                    return Batch.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, values));
                }

                @Override
                public On<BatchConjunction> to(Object[] values) {
                    int len = values.length;
                    for (int i = 0; i != len; ++i) {
                        values[i] = Graph.this.convertReferenceValue(values[i]);
                    }
                    return Batch.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, values));
                }

                @Override
                public On<BatchConjunction> to(Iterable<?> values) {
                    LinkedList valueList = new LinkedList();
                    for (Object value : values) {
                        value = Graph.this.convertReferenceValue(value);
                        valueList.add(value);
                    }
                    return Batch.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, valueList));
                }

                @Override
                public On<BatchConjunction> to(Iterator<?> values) {
                    LinkedList valueList = new LinkedList();
                    while (values.hasNext()) {
                        Object value = values.next();
                        valueList.add(value);
                    }
                    return Batch.this.set(Graph.this.getContext().getPropertyFactory().create(propertyName, valueList));
                }
            };
        }

        public On<BatchConjunction> remove(final Name ... propertyNames) {
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(Location location) {
                    Batch.this.requestQueue.removeProperties(location, Batch.this.getCurrentWorkspaceName(), propertyNames);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction on(String path) {
                    return this.on(Location.create(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(Location.create(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(Location.create(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(Iterable<Property> idProperties) {
                    return this.on(Location.create(idProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(Location.create(uuid));
                }
            };
        }

        public On<BatchConjunction> remove(String ... propertyNames) {
            NameFactory nameFactory = Graph.this.getContext().getValueFactories().getNameFactory();
            int number = propertyNames.length;
            final Name[] names = new Name[number];
            for (int i = 0; i != number; ++i) {
                names[i] = (Name)nameFactory.create(propertyNames[i]);
            }
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(Location location) {
                    Batch.this.requestQueue.removeProperties(location, Batch.this.getCurrentWorkspaceName(), names);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction on(String path) {
                    return this.on(Location.create(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(Location.create(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(Location.create(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(Iterable<Property> idProperties) {
                    return this.on(Location.create(idProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(Location.create(uuid));
                }
            };
        }

        public BatchConjunction read(UUID uuid) {
            return this.read(Location.create(uuid));
        }

        public BatchConjunction read(Location location) {
            this.assertNotExecuted();
            this.requestQueue.readNode(location, this.getCurrentWorkspaceName());
            return this.nextRequests;
        }

        public BatchConjunction read(String path) {
            return this.read(Location.create(Graph.this.createPath(path)));
        }

        public BatchConjunction read(Path path) {
            return this.read(Location.create(path));
        }

        public BatchConjunction read(Property idProperty) {
            return this.read(Location.create(idProperty));
        }

        public BatchConjunction read(Property firstIdProperty, Property ... additionalIdProperties) {
            return this.read(Location.create(firstIdProperty, additionalIdProperties));
        }

        public BatchConjunction read(Iterable<Property> idProperties) {
            return this.read(Location.create(idProperties));
        }

        public On<BatchConjunction> readProperty(String propertyName) {
            this.assertNotExecuted();
            Name name = (Name)Graph.this.getContext().getValueFactories().getNameFactory().create(propertyName);
            return this.readProperty(name);
        }

        public On<BatchConjunction> readProperty(final Name name) {
            this.assertNotExecuted();
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(String path) {
                    return this.on(Location.create(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(Location.create(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(Location.create(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(Iterable<Property> idProperties) {
                    return this.on(Location.create(idProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(Location.create(uuid));
                }

                @Override
                public BatchConjunction on(Location at) {
                    Batch.this.requestQueue.readProperty(at, Batch.this.getCurrentWorkspaceName(), name);
                    return Batch.this.nextRequests;
                }
            };
        }

        public On<BatchConjunction> readProperties() {
            this.assertNotExecuted();
            return new On<BatchConjunction>(){

                @Override
                public BatchConjunction on(Location location) {
                    Batch.this.requestQueue.readAllProperties(location, Batch.this.getCurrentWorkspaceName());
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction on(String path) {
                    return this.on(Location.create(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction on(Path path) {
                    return this.on(Location.create(path));
                }

                @Override
                public BatchConjunction on(Property idProperty) {
                    return this.on(Location.create(idProperty));
                }

                @Override
                public BatchConjunction on(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.on(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction on(Iterable<Property> idProperties) {
                    return this.on(Location.create(idProperties));
                }

                @Override
                public BatchConjunction on(UUID uuid) {
                    return this.on(Location.create(uuid));
                }
            };
        }

        public Of<BatchConjunction> readChildren() {
            this.assertNotExecuted();
            return new Of<BatchConjunction>(){

                @Override
                public BatchConjunction of(String path) {
                    return this.of(Location.create(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction of(Path path) {
                    return this.of(Location.create(path));
                }

                @Override
                public BatchConjunction of(Property idProperty) {
                    return this.of(Location.create(idProperty));
                }

                @Override
                public BatchConjunction of(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.of(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction of(Iterable<Property> idProperties) {
                    return this.of(Location.create(idProperties));
                }

                @Override
                public BatchConjunction of(UUID uuid) {
                    return this.of(Location.create(uuid));
                }

                @Override
                public BatchConjunction of(Location at) {
                    Batch.this.requestQueue.readAllChildren(at, Batch.this.getCurrentWorkspaceName());
                    return Batch.this.nextRequests;
                }
            };
        }

        public At<BatchConjunction> readSubgraphOfDepth(final int depth) {
            this.assertNotExecuted();
            return new At<BatchConjunction>(){

                @Override
                public BatchConjunction at(Location location) {
                    Batch.this.requestQueue.readBranch(location, Batch.this.getCurrentWorkspaceName(), depth);
                    return Batch.this.nextRequests;
                }

                @Override
                public BatchConjunction at(String path) {
                    return this.at(Location.create(Graph.this.createPath(path)));
                }

                @Override
                public BatchConjunction at(Path path) {
                    return this.at(Location.create(path));
                }

                @Override
                public BatchConjunction at(UUID uuid) {
                    return this.at(Location.create(uuid));
                }

                @Override
                public BatchConjunction at(Property idProperty) {
                    return this.at(Location.create(idProperty));
                }

                @Override
                public BatchConjunction at(Property firstIdProperty, Property ... additionalIdProperties) {
                    return this.at(Location.create(firstIdProperty, additionalIdProperties));
                }

                @Override
                public BatchConjunction at(Iterable<Property> idProperties) {
                    return this.at(Location.create(idProperties));
                }
            };
        }

        @Override
        public Results execute() {
            this.executed = true;
            Request request = this.requestQueue.pop();
            if (request == null) {
                return new BatchResults();
            }
            Graph.this.execute(request);
            if (RequestType.COMPOSITE == request.getType()) {
                CompositeRequest composite = (CompositeRequest)request;
                return new BatchResults(composite.getRequests());
            }
            return new BatchResults(request);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Pending requests:\n");
            sb.append(this.requestQueue.toString());
            return sb.toString();
        }
    }

    protected static class AccessQueryProcessor
    extends AbstractAccessComponent {
        private final AccessQueryRequest accessRequest;
        private final String graphSourceName;

        protected AccessQueryProcessor(String graphSourceName, String workspaceName, QueryContext context, QueryResults.Columns columns, PlanNode accessNode) {
            super(context, columns, accessNode);
            this.graphSourceName = graphSourceName;
            this.accessRequest = new AccessQueryRequest(workspaceName, this.sourceName, this.getColumns(), this.andedConstraints, this.limit, context.getSchemata(), context.getVariables());
            ((GraphQueryContext)context).getBatch().requestQueue.submit(this.accessRequest);
        }

        public AccessQueryRequest getAccessRequest() {
            return this.accessRequest;
        }

        @Override
        public List<Object[]> execute() {
            if (this.accessRequest.getError() != null) {
                I18n msg = GraphI18n.errorWhilePerformingQuery;
                this.getContext().getProblems().addError(this.accessRequest.getError(), msg, new Object[]{this.accessNode.getString(), this.accessRequest.workspace(), this.graphSourceName, this.accessRequest.getError().getLocalizedMessage()});
                return this.emptyTuples();
            }
            return this.accessRequest.getTuples();
        }
    }

    protected class GraphQueryContext
    extends QueryContext {
        private final Batch batch;

        protected GraphQueryContext(Schemata schemata, TypeSystem typeSystem, PlanHints hints, Problems problems, Map<String, Object> variables, Batch batch) {
            super(schemata, typeSystem, hints, problems, variables);
            this.batch = batch;
            assert (this.batch != null);
        }

        public Batch getBatch() {
            return this.batch;
        }
    }
}

