/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.process.ProcessingComponent;

public class DependentQueryComponent
extends ProcessingComponent {
    private final ProcessingComponent left;
    private final ProcessingComponent right;
    private final String leftVariableName;
    private final String rightVariableName;

    public DependentQueryComponent(QueryContext context, ProcessingComponent left, ProcessingComponent right, String leftVariableName, String rightVariableName) {
        super(context, right.getColumns());
        this.left = left;
        this.right = right;
        this.leftVariableName = leftVariableName;
        this.rightVariableName = rightVariableName;
    }

    protected final ProcessingComponent left() {
        return this.left;
    }

    protected final ProcessingComponent right() {
        return this.right;
    }

    protected final QueryResults.Columns colunnsOfIndependentQuery() {
        return this.left.getColumns();
    }

    protected final QueryResults.Columns colunnsOfDependentQuery() {
        return this.right.getColumns();
    }

    @Override
    public List<Object[]> execute() {
        List<Object[]> leftResults = this.left.execute();
        if (this.left.getColumns().getColumnCount() > 0) {
            this.saveResultsToVariable(leftResults, this.leftVariableName);
        }
        List<Object[]> rightResults = this.right.execute();
        if (this.right.getColumns().getColumnCount() > 0) {
            this.saveResultsToVariable(rightResults, this.rightVariableName);
        }
        return rightResults;
    }

    protected void saveResultsToVariable(List<Object[]> results, String variableName) {
        if (results == null || results.isEmpty()) {
            return;
        }
        if (variableName == null) {
            return;
        }
        ArrayList<Object> singleColumnResults = new ArrayList<Object>(results.size());
        Object[] firstTuple = results.get(0);
        if (firstTuple.length != 0) {
            for (Object[] tuple : results) {
                singleColumnResults.add(tuple[0]);
            }
        }
        this.getContext().getVariables().put(variableName, singleColumnResults);
    }
}

