/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.math.BigDecimal;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ReferenceFactory;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueTypeSystem;
import org.modeshape.graph.property.basic.AbstractValueFactories;
import org.modeshape.graph.property.basic.BooleanValueFactory;
import org.modeshape.graph.property.basic.DecimalValueFactory;
import org.modeshape.graph.property.basic.DoubleValueFactory;
import org.modeshape.graph.property.basic.InMemoryBinaryValueFactory;
import org.modeshape.graph.property.basic.JodaDateTimeValueFactory;
import org.modeshape.graph.property.basic.LongValueFactory;
import org.modeshape.graph.property.basic.NameValueFactory;
import org.modeshape.graph.property.basic.ObjectValueFactory;
import org.modeshape.graph.property.basic.PathValueFactory;
import org.modeshape.graph.property.basic.ReferenceValueFactory;
import org.modeshape.graph.property.basic.StringValueFactory;
import org.modeshape.graph.property.basic.UriValueFactory;
import org.modeshape.graph.property.basic.UuidValueFactory;
import org.modeshape.graph.query.model.TypeSystem;

@Immutable
public class StandardValueFactories
extends AbstractValueFactories {
    private final ValueFactory<String> stringFactory;
    private final BinaryFactory binaryFactory;
    private final ValueFactory<Boolean> booleanFactory;
    private final DateTimeFactory dateFactory;
    private final ValueFactory<BigDecimal> decimalFactory;
    private final ValueFactory<Double> doubleFactory;
    private final ValueFactory<Long> longFactory;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final ReferenceFactory referenceFactory;
    private final ReferenceFactory weakReferenceFactory;
    private final ValueFactory<URI> uriFactory;
    private final UuidFactory uuidFactory;
    private final ValueFactory<Object> objectFactory;
    private final NamespaceRegistry namespaceRegistry;
    private final TypeSystem typeSystem;

    public StandardValueFactories(NamespaceRegistry namespaceRegistry) {
        this(namespaceRegistry, null, null, new ValueFactory[0]);
    }

    public StandardValueFactories(NamespaceRegistry namespaceRegistry, TextDecoder decoder, TextEncoder encoder, ValueFactory<?> ... extraFactories) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        this.namespaceRegistry = namespaceRegistry;
        decoder = decoder != null ? decoder : ValueFactory.DEFAULT_DECODER;
        encoder = encoder != null ? encoder : ValueFactory.DEFAULT_ENCODER;
        HashMap factories = new HashMap();
        for (ValueFactory<?> factory : extraFactories) {
            if (factory == null) continue;
            factories.put(factory.getPropertyType(), factory);
        }
        this.stringFactory = StandardValueFactories.getFactory(factories, new StringValueFactory(this.namespaceRegistry, decoder, encoder));
        StringValueFactory stringFactoryWithoutNamespaces = new StringValueFactory(decoder, encoder);
        this.binaryFactory = (BinaryFactory)StandardValueFactories.getFactory(factories, new InMemoryBinaryValueFactory(decoder, stringFactoryWithoutNamespaces));
        this.booleanFactory = StandardValueFactories.getFactory(factories, new BooleanValueFactory(decoder, this.stringFactory));
        this.dateFactory = (DateTimeFactory)StandardValueFactories.getFactory(factories, new JodaDateTimeValueFactory(decoder, this.stringFactory));
        this.decimalFactory = StandardValueFactories.getFactory(factories, new DecimalValueFactory(decoder, this.stringFactory));
        this.doubleFactory = StandardValueFactories.getFactory(factories, new DoubleValueFactory(decoder, this.stringFactory));
        this.longFactory = StandardValueFactories.getFactory(factories, new LongValueFactory(decoder, this.stringFactory));
        this.nameFactory = (NameFactory)StandardValueFactories.getFactory(factories, new NameValueFactory(this.namespaceRegistry, decoder, this.stringFactory));
        this.pathFactory = (PathFactory)StandardValueFactories.getFactory(factories, new PathValueFactory(decoder, this.stringFactory, this.nameFactory));
        this.referenceFactory = (ReferenceFactory)StandardValueFactories.getFactory(factories, new ReferenceValueFactory(decoder, this.stringFactory, false));
        this.weakReferenceFactory = (ReferenceFactory)StandardValueFactories.getFactory(factories, new ReferenceValueFactory(decoder, this.stringFactory, true));
        this.uuidFactory = (UuidFactory)StandardValueFactories.getFactory(factories, new UuidValueFactory(decoder, this.stringFactory));
        this.uriFactory = StandardValueFactories.getFactory(factories, new UriValueFactory(this.namespaceRegistry, decoder, this.stringFactory));
        this.objectFactory = StandardValueFactories.getFactory(factories, new ObjectValueFactory(decoder, this.stringFactory, this.binaryFactory));
        this.typeSystem = new ValueTypeSystem(this);
    }

    private static <T> ValueFactory<T> getFactory(Map<PropertyType, ValueFactory<?>> factories, ValueFactory<T> defaultFactory) {
        PropertyType type = defaultFactory.getPropertyType();
        ValueFactory<Object> factory = factories.get((Object)type);
        if (factory == null) {
            factory = defaultFactory;
            factories.put(type, factory);
        }
        return factory;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    @Override
    public BinaryFactory getBinaryFactory() {
        return this.binaryFactory;
    }

    @Override
    public ValueFactory<Boolean> getBooleanFactory() {
        return this.booleanFactory;
    }

    @Override
    public DateTimeFactory getDateFactory() {
        return this.dateFactory;
    }

    @Override
    public ValueFactory<BigDecimal> getDecimalFactory() {
        return this.decimalFactory;
    }

    @Override
    public ValueFactory<Double> getDoubleFactory() {
        return this.doubleFactory;
    }

    @Override
    public ValueFactory<Long> getLongFactory() {
        return this.longFactory;
    }

    @Override
    public NameFactory getNameFactory() {
        return this.nameFactory;
    }

    @Override
    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    @Override
    public ReferenceFactory getReferenceFactory() {
        return this.referenceFactory;
    }

    @Override
    public ReferenceFactory getWeakReferenceFactory() {
        return this.weakReferenceFactory;
    }

    @Override
    public ValueFactory<String> getStringFactory() {
        return this.stringFactory;
    }

    @Override
    public ValueFactory<URI> getUriFactory() {
        return this.uriFactory;
    }

    @Override
    public UuidFactory getUuidFactory() {
        return this.uuidFactory;
    }

    @Override
    public ValueFactory<Object> getObjectFactory() {
        return this.objectFactory;
    }
}

