/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class CreateNodeRequest
extends ChangeRequest
implements Iterable<Property> {
    private static final long serialVersionUID = 1L;
    public static final NodeConflictBehavior DEFAULT_CONFLICT_BEHAVIOR = NodeConflictBehavior.APPEND;
    private final Location under;
    private final String workspaceName;
    private final Name childName;
    private final List<Property> properties;
    private final NodeConflictBehavior conflictBehavior;
    private Location actualLocation;

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, Property ... properties) {
        this(parentLocation, workspaceName, childName, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, Iterable<Property> properties) {
        this(parentLocation, workspaceName, childName, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, Iterator<Property> properties) {
        this(parentLocation, workspaceName, childName, DEFAULT_CONFLICT_BEHAVIOR, properties);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, NodeConflictBehavior conflictBehavior, Property ... properties) {
        CheckArg.isNotNull((Object)parentLocation, (String)"parentLocation");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        CheckArg.isNotNull((Object)childName, (String)"childName");
        this.under = parentLocation;
        this.workspaceName = workspaceName;
        this.childName = childName;
        this.conflictBehavior = conflictBehavior;
        int number = properties.length + (this.under.hasIdProperties() ? this.under.getIdProperties().size() : 0);
        ArrayList<Property> props = new ArrayList<Property>(number);
        for (Property property : properties) {
            if (property == null) continue;
            props.add(property);
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, NodeConflictBehavior conflictBehavior, Iterable<Property> properties) {
        CheckArg.isNotNull((Object)parentLocation, (String)"parentLocation");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        CheckArg.isNotNull((Object)childName, (String)"childName");
        this.under = parentLocation;
        this.workspaceName = workspaceName;
        this.childName = childName;
        this.conflictBehavior = conflictBehavior;
        LinkedList<Property> props = new LinkedList<Property>();
        for (Property property : properties) {
            if (property == null) continue;
            props.add(property);
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public CreateNodeRequest(Location parentLocation, String workspaceName, Name childName, NodeConflictBehavior conflictBehavior, Iterator<Property> properties) {
        CheckArg.isNotNull((Object)parentLocation, (String)"parentLocation");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)((Object)conflictBehavior), (String)"conflictBehavior");
        CheckArg.isNotNull((Object)childName, (String)"childName");
        this.under = parentLocation;
        this.workspaceName = workspaceName;
        this.childName = childName;
        this.conflictBehavior = conflictBehavior;
        LinkedList<Property> props = new LinkedList<Property>();
        while (properties.hasNext()) {
            Property property = properties.next();
            if (property == null) continue;
            props.add(property);
        }
        this.properties = Collections.unmodifiableList(props);
    }

    public Location under() {
        return this.under;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name named() {
        return this.childName;
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties.iterator();
    }

    public Collection<Property> properties() {
        return this.properties;
    }

    public NodeConflictBehavior conflictBehavior() {
        return this.conflictBehavior;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)actual, (String)"actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        assert (actual.hasPath());
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.under.hasPath() && this.under.getPath().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.under;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.under, this.childName, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CreateNodeRequest that = (CreateNodeRequest)obj;
            if (!this.under().isSame(that.under())) {
                return false;
            }
            if (!this.conflictBehavior().equals((Object)that.conflictBehavior())) {
                return false;
            }
            if (!this.inWorkspace().equals((Object)that.conflictBehavior())) {
                return false;
            }
            return ((Object)this.properties()).equals(that.properties());
        }
        return false;
    }

    public String toString() {
        String path = null;
        path = this.under.hasPath() && this.under.getPath().isRoot() ? "'/" + this.childName + "'" : this.printable(this.under(), this.childName);
        StringBuilder sb = new StringBuilder();
        sb.append("create ").append(path).append(" (in ");
        if (this.workspaceName != null) {
            sb.append("'").append(this.workspaceName).append("'");
        } else {
            sb.append("default");
        }
        sb.append(" workspace) with properties ");
        sb.append(this.properties());
        switch (this.conflictBehavior()) {
            case APPEND: {
                sb.append(" by appending");
                break;
            }
            case REPLACE: {
                sb.append(" by replacing");
                break;
            }
            case UPDATE: {
                sb.append(" by updating");
                break;
            }
            case DO_NOT_REPLACE: {
                sb.append(" if absent");
            }
        }
        return sb.toString();
    }

    @Override
    public CreateNodeRequest clone() {
        CreateNodeRequest request = new CreateNodeRequest(this.under, this.workspaceName, this.childName, this.conflictBehavior, this.properties);
        request.setActualLocationOfNode(this.actualLocation);
        return request;
    }

    @Override
    public RequestType getType() {
        return RequestType.CREATE_NODE;
    }
}

