/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.text;

import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.common.component.ComponentConfig;
import org.modeshape.common.component.ComponentLibrary;
import org.modeshape.common.component.StandardClassLoaderFactory;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.text.TextExtractor;
import org.modeshape.graph.text.TextExtractorConfig;
import org.modeshape.graph.text.TextExtractorContext;
import org.modeshape.graph.text.TextExtractorOutput;

@ThreadSafe
public final class TextExtractors
implements TextExtractor {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    protected static final ClassLoaderFactory DEFAULT_CLASSLOADER_FACTORY = new StandardClassLoaderFactory(TextExtractors.class.getClassLoader());
    private final ComponentLibrary<TextExtractor, TextExtractorConfig> library = new ComponentLibrary(true);
    private Logger logger;
    private final boolean stopAfterFirst;

    public TextExtractors() {
        this.library.setClassLoaderFactory(DEFAULT_CLASSLOADER_FACTORY);
        this.stopAfterFirst = true;
    }

    public ComponentLibrary<TextExtractor, TextExtractorConfig> getLibrary() {
        return this.library;
    }

    public int size() {
        return this.library.getSequenceConfigs().size();
    }

    public boolean addExtractor(TextExtractorConfig config) {
        return this.library.add((ComponentConfig)config);
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        return this.library.getClassLoaderFactory();
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getClass());
        }
        return this.logger;
    }

    @Override
    public boolean supportsMimeType(String mimeType) {
        for (TextExtractor extractor : this.library.getInstances()) {
            if (!extractor.supportsMimeType(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void extractFrom(InputStream stream, TextExtractorOutput output, TextExtractorContext context) throws IOException {
        if (stream == null) {
            return;
        }
        if (stream.markSupported()) {
            stream.mark(Integer.MAX_VALUE);
        }
        String mimeType = context.getMimeType();
        for (TextExtractor extractor : this.library.getInstances()) {
            if (!extractor.supportsMimeType(mimeType)) continue;
            extractor.extractFrom(stream, output, context);
            if (this.stopAfterFirst || !stream.markSupported()) break;
            stream.reset();
        }
    }

    public boolean removeExtractor(TextExtractorConfig config) {
        return this.library.remove((ComponentConfig)config);
    }

    public void setClassLoaderFactory(ClassLoaderFactory classLoaderFactory) {
        this.library.setClassLoaderFactory(classLoaderFactory != null ? classLoaderFactory : DEFAULT_CLASSLOADER_FACTORY);
    }

    public synchronized void setLogger(Logger logger) {
        this.logger = logger != null ? logger : this.getLogger();
    }
}

