/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ReadOnly;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Connection;
import org.modeshape.graph.connector.inmemory.InMemoryNode;
import org.modeshape.graph.connector.inmemory.InMemoryRepository;
import org.modeshape.graph.connector.inmemory.InMemoryTransaction;
import org.modeshape.graph.connector.inmemory.InMemoryWorkspace;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.CreateWorkspaceRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class InMemoryRepositorySource
implements BaseRepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final String DEFAULT_WORKSPACE_NAME = "";
    protected static final RepositorySourceCapabilities CAPABILITIES = new RepositorySourceCapabilities(true, true, false, true, true);
    protected static final String ROOT_NODE_UUID_ATTR = "rootNodeUuid";
    protected static final String SOURCE_NAME_ATTR = "sourceName";
    protected static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    protected static final String DEFAULT_WORKSPACE_NAME_ATTR = "defaultWorkspaceName";
    protected static final String DEFAULT_CACHE_POLICY_ATTR = "defaultCachePolicy";
    protected static final String JNDI_NAME_ATTR = "jndiName";
    protected static final String RETRY_LIMIT_ATTR = "retryLimit";
    @Description(i18n=GraphI18n.class, value="namePropertyDescription")
    @Label(i18n=GraphI18n.class, value="namePropertyLabel")
    @Category(i18n=GraphI18n.class, value="namePropertyCategory")
    private String name;
    @Description(i18n=GraphI18n.class, value="jndiNamePropertyDescription")
    @Label(i18n=GraphI18n.class, value="jndiNamePropertyLabel")
    @Category(i18n=GraphI18n.class, value="jndiNamePropertyCategory")
    private String jndiName;
    @Description(i18n=GraphI18n.class, value="defaultWorkspaceNamePropertyDescription")
    @Label(i18n=GraphI18n.class, value="defaultWorkspaceNamePropertyLabel")
    @Category(i18n=GraphI18n.class, value="defaultWorkspaceNamePropertyCategory")
    private String defaultWorkspaceName = "";
    @Description(i18n=GraphI18n.class, value="rootNodeUuidPropertyDescription")
    @Label(i18n=GraphI18n.class, value="rootNodeUuidPropertyLabel")
    @Category(i18n=GraphI18n.class, value="rootNodeUuidPropertyCategory")
    private UUID rootNodeUuid = UUID.randomUUID();
    @Description(i18n=GraphI18n.class, value="predefinedWorkspacesPropertyDescription")
    @Label(i18n=GraphI18n.class, value="predefinedWorkspacesPropertyLabel")
    @Category(i18n=GraphI18n.class, value="predefinedWorkspacesPropertyCategory")
    private volatile String[] predefinedWorkspaces = new String[0];
    @Description(i18n=GraphI18n.class, value="retryLimitPropertyDescription")
    @Label(i18n=GraphI18n.class, value="retryLimitPropertyLabel")
    @Category(i18n=GraphI18n.class, value="retryLimitPropertyCategory")
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    private CachePolicy defaultCachePolicy;
    private transient InMemoryRepository repository;
    private transient ExecutionContext defaultContext = new ExecutionContext();
    private transient RepositoryContext repositoryContext = new DefaultRepositoryContext();

    @Override
    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context != null ? context : new DefaultRepositoryContext();
    }

    @Override
    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    @Override
    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    @Override
    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    @Override
    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        this.defaultCachePolicy = defaultCachePolicy;
    }

    @Override
    public String getDefaultWorkspaceName() {
        return this.defaultWorkspaceName;
    }

    public void setDefaultWorkspaceName(String defaultWorkspaceName) {
        this.defaultWorkspaceName = defaultWorkspaceName != null ? defaultWorkspaceName : DEFAULT_WORKSPACE_NAME;
    }

    public String getRootNodeUuid() {
        return this.rootNodeUuid.toString();
    }

    @Override
    public UUID getRootNodeUuidObject() {
        return this.rootNodeUuid;
    }

    public void setRootNodeUuid(UUID rootNodeUuid) {
        this.rootNodeUuid = rootNodeUuid != null ? rootNodeUuid : UUID.randomUUID();
    }

    public void setRootNodeUuid(String rootNodeUuid) {
        this.rootNodeUuid = rootNodeUuid != null ? UUID.fromString(rootNodeUuid) : UUID.randomUUID();
    }

    public void setJndiName(String name) throws NamingException {
        this.setJndiName(name, null);
    }

    public synchronized void setJndiName(String name, Context context) throws NamingException {
        CheckArg.isNotNull((Object)name, (String)"name");
        if (context == null) {
            context = new InitialContext();
        }
        if (name != null) {
            context.bind(name, (Object)this);
        }
        if (this.jndiName != null && !this.jndiName.equals(name)) {
            context.unbind(this.jndiName);
        }
        this.jndiName = name;
    }

    public synchronized String getJndiName() {
        return this.jndiName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.repository == null) {
            this.repository = new InMemoryRepository(this);
            ExecutionContext context = this.repositoryContext != null ? this.repositoryContext.getExecutionContext() : this.defaultContext;
            InMemoryTransaction txn = this.repository.startTransaction(context, false);
            try {
                for (String initialName : this.getPredefinedWorkspaceNames()) {
                    this.repository.createWorkspace(txn, initialName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, null);
                }
            }
            finally {
                txn.commit();
            }
        }
        return new Connection<InMemoryNode, InMemoryWorkspace>(this, this.repository);
    }

    @Override
    public synchronized void close() {
        this.repository = null;
    }

    @Override
    public synchronized Reference getReference() {
        String[] workspaceNames;
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME_ATTR, this.getName()));
        }
        if (this.getRootNodeUuid() != null) {
            ref.add(new StringRefAddr(ROOT_NODE_UUID_ATTR, this.getRootNodeUuid().toString()));
        }
        if (this.getJndiName() != null) {
            ref.add(new StringRefAddr(JNDI_NAME_ATTR, this.getJndiName()));
        }
        if (this.getDefaultWorkspaceName() != null) {
            ref.add(new StringRefAddr(DEFAULT_WORKSPACE_NAME_ATTR, this.getDefaultWorkspaceName()));
        }
        if ((workspaceNames = this.getPredefinedWorkspaceNames()) != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        if (this.getDefaultCachePolicy() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(DEFAULT_CACHE_POLICY_ATTR, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = GraphI18n.errorSerializingInMemoryCachePolicyInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), e);
            }
        }
        ref.add(new StringRefAddr(RETRY_LIMIT_ATTR, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME_ATTR);
            String rootNodeUuidString = (String)values.get(ROOT_NODE_UUID_ATTR);
            String jndiName = (String)values.get(JNDI_NAME_ATTR);
            String defaultWorkspaceName = (String)values.get(DEFAULT_WORKSPACE_NAME_ATTR);
            Object defaultCachePolicy = values.get(DEFAULT_CACHE_POLICY_ATTR);
            String retryLimit = (String)values.get(RETRY_LIMIT_ATTR);
            String combinedWorkspaceNames = (String)values.get(PREDEFINED_WORKSPACE_NAMES);
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            InMemoryRepositorySource source = new InMemoryRepositorySource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuidString != null) {
                source.setRootNodeUuid(UUID.fromString(rootNodeUuidString));
            }
            if (defaultWorkspaceName != null) {
                source.setDefaultWorkspaceName(defaultWorkspaceName);
            }
            if (jndiName != null) {
                source.setJndiName(jndiName);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        this.predefinedWorkspaces = predefinedWorkspaceNames;
    }

    @Override
    public RepositorySourceCapabilities getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    @Description(i18n=GraphI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=GraphI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=GraphI18n.class, value="updatesAllowedPropertyCategory")
    @ReadOnly
    public boolean areUpdatesAllowed() {
        return true;
    }

    @Override
    public void setUpdatesAllowed(boolean updatesAllowed) {
        if (!updatesAllowed) {
            throw new RepositorySourceException(GraphI18n.inMemoryConnectorMustAllowUpdates.text(new Object[]{this.name}));
        }
    }

    public String toString() {
        return "The \"" + this.name + "\" in-memory repository";
    }

    protected class DefaultRepositoryContext
    implements RepositoryContext {
        protected DefaultRepositoryContext() {
        }

        public ExecutionContext getExecutionContext() {
            return InMemoryRepositorySource.this.defaultContext;
        }

        public Subgraph getConfiguration(int depth) {
            return null;
        }

        public Observer getObserver() {
            return null;
        }

        public RepositoryConnectionFactory getRepositoryConnectionFactory() {
            return null;
        }
    }
}

