/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.search;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.xa.XAResource;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.processor.RequestProcessor;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineProcessor;

@ThreadSafe
public class SearchableRepositorySource
implements RepositorySource {
    private static final long serialVersionUID = 1L;
    private final RepositorySource delegate;
    private final boolean executeAsynchronously;
    private final boolean updateIndexesAsynchronously;
    private final transient ExecutorService executorService;
    private final transient SearchEngine searchEngine;

    public SearchableRepositorySource(RepositorySource wrapped, SearchEngine searchEngine, ExecutorService executorService, boolean executeAsynchronously, boolean updateIndexesAsynchronously) {
        CheckArg.isNotNull((Object)wrapped, (String)"wrapped");
        CheckArg.isNotNull((Object)searchEngine, (String)"searchEngine");
        this.delegate = wrapped;
        this.executorService = executorService;
        this.searchEngine = searchEngine;
        this.updateIndexesAsynchronously = this.executorService != null && updateIndexesAsynchronously;
        this.executeAsynchronously = this.executorService != null && executeAsynchronously;
    }

    public SearchableRepositorySource(RepositorySource wrapped, SearchEngine searchEngine) {
        this(wrapped, searchEngine, null, false, false);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void close() {
        this.delegate.close();
    }

    public RepositorySourceCapabilities getCapabilities() {
        return new RepositorySourceCapabilities(this.delegate.getCapabilities()){

            public boolean supportsQueries() {
                return true;
            }

            public boolean supportsSearches() {
                return true;
            }
        };
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.executeRequestsAsynchronously()) {
            assert (this.executorService != null);
            return new ParallelConnection(this.executorService);
        }
        return new SynchronousConnection();
    }

    public int getRetryLimit() {
        return this.delegate.getRetryLimit();
    }

    public void initialize(final RepositoryContext context) throws RepositorySourceException {
        final String delegateSourceName = this.delegate.getName();
        final RepositoryConnectionFactory originalConnectionFactory = context.getRepositoryConnectionFactory();
        final RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (delegateSourceName.equals(sourceName)) {
                    return SearchableRepositorySource.this.delegate().getConnection();
                }
                return originalConnectionFactory.createConnection(sourceName);
            }
        };
        final Observer observer = new Observer(){

            public void notify(final Changes changes) {
                if (changes != null) {
                    if (SearchableRepositorySource.this.updateIndexesAsynchronously()) {
                        SearchableRepositorySource.this.executorService().submit(new Runnable(){

                            public void run() {
                                SearchableRepositorySource.this.process(context.getExecutionContext(), changes);
                            }
                        });
                    } else {
                        SearchableRepositorySource.this.process(context.getExecutionContext(), changes);
                    }
                }
            }
        };
        RepositoryContext newContext = new RepositoryContext(){

            public Subgraph getConfiguration(int depth) {
                return context.getConfiguration(depth);
            }

            public ExecutionContext getExecutionContext() {
                return context.getExecutionContext();
            }

            public Observer getObserver() {
                return observer;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return connectionFactory;
            }
        };
        this.delegate.initialize(newContext);
    }

    protected final SearchEngine searchEngine() {
        assert (this.searchEngine != null);
        return this.searchEngine;
    }

    protected final boolean updateIndexesAsynchronously() {
        return this.executorService != null && this.updateIndexesAsynchronously;
    }

    protected final boolean executeRequestsAsynchronously() {
        return this.executorService != null && this.executeAsynchronously;
    }

    protected final ExecutorService executorService() {
        assert (this.executorService != null);
        return this.executorService;
    }

    protected final RepositorySource delegate() {
        return this.delegate;
    }

    protected void process(ExecutionContext context, Changes changes) {
        assert (context != null);
        assert (changes != null);
        if (this.searchEngine == null) {
            return;
        }
        this.searchEngine.index(context, changes.getChangeRequests());
    }

    public void setRetryLimit(int limit) {
        this.delegate.setRetryLimit(limit);
    }

    public Reference getReference() throws NamingException {
        return this.delegate.getReference();
    }

    @NotThreadSafe
    protected class SynchronousConnection
    extends AbstractConnection {
        protected SynchronousConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            SearchEngineProcessor searchProcessor = null;
            switch (request.getType()) {
                case ACCESS_QUERY: {
                    AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(queryRequest);
                        Object var6_6 = null;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        ((RequestProcessor)searchProcessor).close();
                        throw throwable;
                    }
                }
                case FULL_TEXT_SEARCH: {
                    FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(searchRequest);
                        Object var8_12 = null;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        ((RequestProcessor)searchProcessor).close();
                        throw throwable;
                    }
                }
                case COMPOSITE: {
                    CompositeRequest composite = (CompositeRequest)request;
                    LinkedList<Request> delegateRequests = null;
                    try {
                        Request delegateRequest = composite;
                        block15: for (Request nested : composite) {
                            switch (nested.getType()) {
                                case ACCESS_QUERY: {
                                    AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(queryRequest);
                                    delegateRequest = null;
                                    continue block15;
                                }
                                case FULL_TEXT_SEARCH: {
                                    FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(searchRequest);
                                    delegateRequest = null;
                                    continue block15;
                                }
                            }
                            if (delegateRequests == null) {
                                delegateRequests = new LinkedList<Request>();
                            }
                            delegateRequests.add(request);
                        }
                        if (delegateRequest == null) {
                            if (delegateRequests != null) {
                                assert (!delegateRequests.isEmpty());
                                delegateRequest = CompositeRequest.with((List<? extends Request>)delegateRequests);
                                this.delegateConnection().execute(context, delegateRequest);
                            }
                        } else {
                            this.delegateConnection().execute(context, request);
                        }
                        Object var12_19 = null;
                        if (searchProcessor == null) break;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var12_20 = null;
                        if (searchProcessor != null) {
                            ((RequestProcessor)searchProcessor).close();
                        }
                        throw throwable;
                    }
                }
                default: {
                    this.delegateConnection().execute(context, request);
                }
            }
        }
    }

    @NotThreadSafe
    protected class ParallelConnection
    extends AbstractConnection {
        private final ExecutorService executorService;

        protected ParallelConnection(ExecutorService executorService) {
            this.executorService = executorService;
        }

        /*
         * Exception decompiling
         */
        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @NotThreadSafe
    protected abstract class AbstractConnection
    implements RepositoryConnection {
        private RepositoryConnection delegateConnection;

        protected AbstractConnection() {
        }

        protected RepositoryConnection delegateConnection() {
            if (this.delegateConnection == null) {
                this.delegateConnection = SearchableRepositorySource.this.delegate().getConnection();
            }
            return this.delegateConnection;
        }

        public boolean ping(long time, TimeUnit unit) throws InterruptedException {
            return this.delegateConnection().ping(time, unit);
        }

        public CachePolicy getDefaultCachePolicy() {
            return this.delegateConnection().getDefaultCachePolicy();
        }

        public String getSourceName() {
            return SearchableRepositorySource.this.delegate().getName();
        }

        public XAResource getXAResource() {
            return this.delegateConnection().getXAResource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.delegateConnection != null) {
                try {
                    this.delegateConnection.close();
                }
                finally {
                    this.delegateConnection = null;
                }
            }
        }
    }
}

