/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.cache;

import java.util.concurrent.TimeUnit;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.cache.ImmutableCachePolicy;

@NotThreadSafe
public class BasicCachePolicy
implements CachePolicy {
    private static final long serialVersionUID = 1L;
    private long timeToLiveInMillis = 0L;

    public BasicCachePolicy() {
    }

    public BasicCachePolicy(long timeToCache, TimeUnit unit) {
        CheckArg.isNotNull((Object)((Object)unit), (String)"unit");
        this.timeToLiveInMillis = TimeUnit.MILLISECONDS.convert(timeToCache, unit);
    }

    public long getTimeToLive() {
        return this.timeToLiveInMillis;
    }

    public void setTimeToLive(long timeToLive, TimeUnit unit) {
        this.timeToLiveInMillis = TimeUnit.NANOSECONDS.convert(timeToLive, unit);
    }

    public boolean isEmpty() {
        return this.timeToLiveInMillis == 0L;
    }

    public CachePolicy getUnmodifiable() {
        return new ImmutableCachePolicy(this.getTimeToLive());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachePolicy) {
            CachePolicy that = (CachePolicy)obj;
            if (this.getTimeToLive() != that.getTimeToLive()) {
                return false;
            }
            if (obj instanceof BasicCachePolicy) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "{ TTL=" + this.timeToLiveInMillis + " ms }";
    }
}

