/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class EquiJoinCondition
implements JoinCondition {
    private static final long serialVersionUID = 1L;
    private final SelectorName selector1Name;
    private final String property1Name;
    private final SelectorName selector2Name;
    private final String property2Name;
    private final int hc;

    public EquiJoinCondition(SelectorName selector1Name, String property1Name, SelectorName selector2Name, String property2Name) {
        CheckArg.isNotNull((Object)selector1Name, (String)"selector1Name");
        CheckArg.isNotNull((Object)property1Name, (String)"property1Name");
        CheckArg.isNotNull((Object)selector2Name, (String)"selector2Name");
        CheckArg.isNotNull((Object)property2Name, (String)"property2Name");
        this.selector1Name = selector1Name;
        this.property1Name = property1Name;
        this.selector2Name = selector2Name;
        this.property2Name = property2Name;
        this.hc = HashCode.compute((Object[])new Object[]{this.selector1Name, this.property1Name, this.selector2Name, this.property2Name});
    }

    public EquiJoinCondition(Column column1, Column column2) {
        this(column1.selectorName(), column1.propertyName(), column2.selectorName(), column2.propertyName());
    }

    public final SelectorName selector1Name() {
        return this.selector1Name;
    }

    public final String property1Name() {
        return this.property1Name;
    }

    public final SelectorName selector2Name() {
        return this.selector2Name;
    }

    public final String property2Name() {
        return this.property2Name;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EquiJoinCondition) {
            EquiJoinCondition that = (EquiJoinCondition)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.selector1Name.equals(that.selector1Name)) {
                return false;
            }
            if (!this.selector2Name.equals(that.selector2Name)) {
                return false;
            }
            if (!this.property1Name.equals(that.property1Name)) {
                return false;
            }
            return this.property2Name.equals(that.property2Name);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

