/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.FunctionRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.UpdateValuesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.function.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestBuilder {
    protected RequestBuilder() {
    }

    protected abstract <T extends Request> T process(T var1);

    public GetWorkspacesRequest getWorkspaces() {
        GetWorkspacesRequest request = new GetWorkspacesRequest();
        this.process(request);
        return request;
    }

    public VerifyWorkspaceRequest verifyWorkspace(String workspaceName) {
        return this.process(new VerifyWorkspaceRequest(workspaceName));
    }

    public CreateWorkspaceRequest createWorkspace(String desiredNameOfNewWorkspace, CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior) {
        return this.process(new CreateWorkspaceRequest(desiredNameOfNewWorkspace, createConflictBehavior));
    }

    public CloneWorkspaceRequest cloneWorkspace(String nameOfWorkspaceToBeCloned, String desiredNameOfTargetWorkspace, CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior, CloneWorkspaceRequest.CloneConflictBehavior cloneConflictBehavior) {
        return this.process(new CloneWorkspaceRequest(nameOfWorkspaceToBeCloned, desiredNameOfTargetWorkspace, createConflictBehavior, cloneConflictBehavior));
    }

    public DestroyWorkspaceRequest destroyWorkspace(String workspaceName) {
        return this.process(new DestroyWorkspaceRequest(workspaceName));
    }

    public VerifyNodeExistsRequest verifyNodeExists(Location at, String workspaceName) {
        return this.process(new VerifyNodeExistsRequest(at, workspaceName));
    }

    public ReadNodeRequest readNode(Location at, String workspaceName) {
        return this.process(new ReadNodeRequest(at, workspaceName));
    }

    public ReadAllChildrenRequest readAllChildren(Location of, String workspaceName) {
        return this.process(new ReadAllChildrenRequest(of, workspaceName));
    }

    public ReadAllPropertiesRequest readAllProperties(Location of, String workspaceName) {
        return this.process(new ReadAllPropertiesRequest(of, workspaceName));
    }

    public ReadPropertyRequest readProperty(Location of, String workspaceName, Name propertyName) {
        return this.process(new ReadPropertyRequest(of, workspaceName, propertyName));
    }

    public ReadBranchRequest readBranch(Location at, String workspaceName) {
        return this.process(new ReadBranchRequest(at, workspaceName));
    }

    public ReadBranchRequest readBranch(Location at, String workspaceName, int maxDepth) {
        return this.process(new ReadBranchRequest(at, workspaceName, maxDepth));
    }

    public ReadBlockOfChildrenRequest readBlockOfChildren(Location of, String workspaceName, int startingIndex, int count) {
        return this.process(new ReadBlockOfChildrenRequest(of, workspaceName, startingIndex, count));
    }

    public ReadNextBlockOfChildrenRequest readNextBlockOfChildren(Location startingAfter, String workspaceName, int count) {
        return this.process(new ReadNextBlockOfChildrenRequest(startingAfter, workspaceName, count));
    }

    public CreateNodeRequest createNode(Location parentLocation, String workspaceName, Name childName, Iterator<Property> properties) {
        return this.process(new CreateNodeRequest(parentLocation, workspaceName, childName, CreateNodeRequest.DEFAULT_CONFLICT_BEHAVIOR, properties));
    }

    public CreateNodeRequest createNode(Location parentLocation, String workspaceName, Name childName, Iterator<Property> properties, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = CreateNodeRequest.DEFAULT_CONFLICT_BEHAVIOR;
        }
        return this.process(new CreateNodeRequest(parentLocation, workspaceName, childName, conflictBehavior, properties));
    }

    public CreateNodeRequest createNode(Location parentLocation, String workspaceName, Name childName, Property[] properties) {
        return this.process(new CreateNodeRequest(parentLocation, workspaceName, childName, CreateNodeRequest.DEFAULT_CONFLICT_BEHAVIOR, properties));
    }

    public CreateNodeRequest createNode(Location parentLocation, String workspaceName, Name childName, Property[] properties, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = CreateNodeRequest.DEFAULT_CONFLICT_BEHAVIOR;
        }
        return this.process(new CreateNodeRequest(parentLocation, workspaceName, childName, conflictBehavior, properties));
    }

    public SetPropertyRequest setProperty(Location on, String workspaceName, Property property) {
        return this.process(new SetPropertyRequest(on, workspaceName, property));
    }

    public Request setProperties(Location on, String workspaceName, Property ... properties) {
        if (properties.length == 1) {
            Property prop = properties[0];
            if (prop == null) {
                throw new IllegalArgumentException(GraphI18n.noPropertiesToUpdate.text(new Object[]{on}));
            }
            return this.process(new SetPropertyRequest(on, workspaceName, properties[0]));
        }
        HashMap<Name, Property> propertyMap = new HashMap<Name, Property>();
        for (Property property : properties) {
            if (property == null) continue;
            propertyMap.put(property.getName(), property);
        }
        if (propertyMap.isEmpty()) {
            throw new IllegalArgumentException(GraphI18n.noPropertiesToUpdate.text(new Object[]{on}));
        }
        return this.process(new UpdatePropertiesRequest(on, workspaceName, propertyMap));
    }

    public RemovePropertyRequest removeProperty(Location on, String workspaceName, Name propertyName) {
        return this.process(new RemovePropertyRequest(on, workspaceName, propertyName));
    }

    public Request removeProperties(Location on, String workspaceName, Name ... propertyNames) {
        if (propertyNames.length == 1) {
            Name name = propertyNames[0];
            if (name == null) {
                throw new IllegalArgumentException(GraphI18n.noPropertiesToRemove.text(new Object[]{on}));
            }
            return this.process(new RemovePropertyRequest(on, workspaceName, propertyNames[0]));
        }
        HashMap<Name, Property> properties = new HashMap<Name, Property>();
        for (Name propertyName : propertyNames) {
            properties.put(propertyName, null);
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException(GraphI18n.noPropertiesToRemove.text(new Object[]{on}));
        }
        return this.process(new UpdatePropertiesRequest(on, workspaceName, properties));
    }

    public RenameNodeRequest renameNode(Location at, String workspaceName, Name newName) {
        return this.process(new RenameNodeRequest(at, workspaceName, newName));
    }

    public CopyBranchRequest copyBranch(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForCopy, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = CopyBranchRequest.DEFAULT_NODE_CONFLICT_BEHAVIOR;
        }
        return this.process(new CopyBranchRequest(from, fromWorkspace, into, intoWorkspace, nameForCopy, conflictBehavior));
    }

    public CloneBranchRequest cloneBranch(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForClone, Path.Segment exactSegmentForClone, boolean removeExisting) {
        return this.process(new CloneBranchRequest(from, fromWorkspace, into, intoWorkspace, nameForClone, exactSegmentForClone, removeExisting));
    }

    public MoveBranchRequest moveBranch(Location from, Location into, String workspaceName) {
        return this.process(new MoveBranchRequest(from, into, workspaceName, MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR));
    }

    public MoveBranchRequest moveBranch(Location from, Location into, String workspaceName, Name newNameForNode) {
        return this.process(new MoveBranchRequest(from, into, null, workspaceName, newNameForNode, MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR));
    }

    public MoveBranchRequest moveBranch(Location from, Location into, Location before, String workspaceName, Name newNameForNode) {
        return this.process(new MoveBranchRequest(from, into, before, workspaceName, newNameForNode, MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR));
    }

    public MoveBranchRequest moveBranch(Location from, Location into, String workspaceName, Name newNameForNode, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR;
        }
        return this.process(new MoveBranchRequest(from, into, null, workspaceName, newNameForNode, conflictBehavior));
    }

    public MoveBranchRequest moveBranch(Location from, Location into, String workspaceName, NodeConflictBehavior conflictBehavior) {
        if (conflictBehavior == null) {
            conflictBehavior = MoveBranchRequest.DEFAULT_CONFLICT_BEHAVIOR;
        }
        return this.process(new MoveBranchRequest(from, into, workspaceName, conflictBehavior));
    }

    public DeleteBranchRequest deleteBranch(Location at, String workspaceName) {
        return this.process(new DeleteBranchRequest(at, workspaceName));
    }

    public UpdateValuesRequest addValues(String workspaceName, Location on, Name property, List<Object> values) {
        UpdateValuesRequest request = new UpdateValuesRequest(workspaceName, on, property, values, null);
        this.process(request);
        return request;
    }

    public UpdateValuesRequest removeValues(String workspaceName, Location on, Name property, List<Object> values) {
        UpdateValuesRequest request = new UpdateValuesRequest(workspaceName, on, property, null, values);
        this.process(request);
        return request;
    }

    public LockBranchRequest lockBranch(String workspaceName, Location target, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) {
        return this.process(new LockBranchRequest(target, workspaceName, lockScope, lockTimeoutInMillis));
    }

    public UnlockBranchRequest unlockBranch(String workspaceName, Location target) {
        return this.process(new UnlockBranchRequest(target, workspaceName));
    }

    public FullTextSearchRequest search(String workspaceName, String fullTextSearchExpression, int maxResults, int offset) {
        return this.process(new FullTextSearchRequest(fullTextSearchExpression, workspaceName, maxResults, offset));
    }

    public FunctionRequest applyFunction(Function function, Map<String, Serializable> inputs, Location to, String workspaceName) {
        return this.process(new FunctionRequest(function, to, workspaceName, inputs));
    }
}

