/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.naming.BinaryRefAddr;
import javax.naming.Reference;
import org.modeshape.common.i18n.I18n;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.AbstractRepositorySource;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.cache.NoCachePolicy;
import org.modeshape.graph.connector.base.cache.NodeCachePolicy;
import org.modeshape.graph.connector.base.cache.NodeCachePolicyChangedEvent;
import org.modeshape.graph.connector.base.cache.NodeCachePolicyChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeCachingRepositorySource<KeyType, NodeType extends Node>
extends AbstractRepositorySource {
    protected static final String NODE_CACHE_POLICY = "nodeCachePolicy";
    public final NodeCachePolicy<KeyType, NodeType> DEFAULT_NODE_CACHE_POLICY = new NoCachePolicy();
    private Collection<NodeCachePolicyChangedListener<KeyType, NodeType>> nodeCachePolicyChangedListeners = new CopyOnWriteArraySet<NodeCachePolicyChangedListener<KeyType, NodeType>>();
    private volatile NodeCachePolicy<KeyType, NodeType> nodeCachePolicy = this.DEFAULT_NODE_CACHE_POLICY;

    public NodeCachePolicy<KeyType, NodeType> getNodeCachePolicy() {
        return this.nodeCachePolicy;
    }

    public synchronized void setNodeCachePolicy(NodeCachePolicy<KeyType, NodeType> nodeCachePolicy) {
        if (nodeCachePolicy == null) {
            nodeCachePolicy = this.DEFAULT_NODE_CACHE_POLICY;
        }
        if (this.nodeCachePolicy == nodeCachePolicy && this.nodeCachePolicy.equals(nodeCachePolicy)) {
            return;
        }
        NodeCachePolicy<KeyType, NodeType> oldPolicy = this.nodeCachePolicy;
        this.nodeCachePolicy = nodeCachePolicy;
        this.cachePolicyChanged(oldPolicy, nodeCachePolicy);
    }

    private void cachePolicyChanged(NodeCachePolicy<KeyType, NodeType> oldPolicy, NodeCachePolicy<KeyType, NodeType> newPolicy) {
        NodeCachePolicyChangedEvent<KeyType, NodeType> event = new NodeCachePolicyChangedEvent<KeyType, NodeType>(oldPolicy, newPolicy);
        for (NodeCachePolicyChangedListener<KeyType, NodeType> listener : this.nodeCachePolicyChangedListeners) {
            listener.cachePolicyChanged(event);
        }
    }

    public void addNodeCachePolicyChangedListener(NodeCachePolicyChangedListener<KeyType, NodeType> listener) {
        this.nodeCachePolicyChangedListeners.add(listener);
    }

    public void removeNodeCachePolicyChangedListener(NodeCachePolicyChangedListener<KeyType, NodeType> listener) {
        this.nodeCachePolicyChangedListeners.add(listener);
    }

    protected void addNodeCachePolicyReference(Reference ref) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NodeCachePolicy<KeyType, NodeType> policy = this.getNodeCachePolicy();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(policy);
            ref.add(new BinaryRefAddr(NODE_CACHE_POLICY, baos.toByteArray()));
        }
        catch (IOException e) {
            I18n msg = GraphI18n.errorSerializingNodeCachePolicyInSource;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), e);
        }
    }
}

