/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import java.util.List;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.plan.PlanNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddJoinConditionColumnsToSources
implements OptimizerRule {
    public static final AddJoinConditionColumnsToSources INSTANCE = new AddJoinConditionColumnsToSources();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode joinNode : plan.findAllAtOrBelow(PlanNode.Type.JOIN)) {
            JoinCondition condition = joinNode.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
            if (!(condition instanceof EquiJoinCondition)) continue;
            EquiJoinCondition equiJoinCondition = (EquiJoinCondition)condition;
            SelectorName selector1 = equiJoinCondition.selector1Name();
            Column joinColumn1 = this.columnFor(equiJoinCondition.selector1Name(), equiJoinCondition.property1Name());
            Column joinColumn2 = this.columnFor(equiJoinCondition.selector2Name(), equiJoinCondition.property2Name());
            PlanNode left = joinNode.getFirstChild();
            PlanNode right = joinNode.getLastChild();
            if (left.getSelectors().contains(selector1)) {
                this.addEquiJoinColumn(context, left, joinColumn1);
                this.addEquiJoinColumn(context, right, joinColumn2);
                continue;
            }
            this.addEquiJoinColumn(context, left, joinColumn2);
            this.addEquiJoinColumn(context, right, joinColumn1);
        }
        return plan;
    }

    protected void addEquiJoinColumn(QueryContext context, PlanNode node, Column joinColumn) {
        if (node.getSelectors().contains(joinColumn.selectorName())) {
            List<Column> columns = node.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
            List<String> types = node.getPropertyAsList(PlanNode.Property.PROJECT_COLUMN_TYPES, String.class);
            if (columns != null && this.addIfMissing(context, joinColumn, columns, types)) {
                node.setProperty(PlanNode.Property.PROJECT_COLUMNS, columns);
                node.setProperty(PlanNode.Property.PROJECT_COLUMN_TYPES, types);
            }
        }
        for (PlanNode child : node) {
            this.addEquiJoinColumn(context, child, joinColumn);
        }
    }

    protected boolean addIfMissing(QueryContext context, Column column, List<Column> columns, List<String> columnTypes) {
        for (Column c : columns) {
            if (!c.propertyName().equals(column.propertyName()) || !c.selectorName().equals(column.selectorName())) continue;
            return false;
        }
        columns.add(column);
        columnTypes.add(context.getTypeSystem().getStringFactory().getTypeName());
        return true;
    }

    protected Column columnFor(SelectorName selector, String property) {
        return new Column(selector, property, property);
    }
}

