/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.BasicPathSegment;

@Immutable
public class IdentifierPathSegment
extends BasicPathSegment {
    private static final long serialVersionUID = 1L;

    public IdentifierPathSegment(Name name) {
        super(name);
    }

    public boolean isIdentifier() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path.Segment) {
            Path.Segment that = (Path.Segment)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            return Math.abs(this.getIndex()) == Math.abs(that.getIndex());
        }
        return false;
    }

    public String toString() {
        if (this.hasIndex()) {
            return this.getName().toString() + "[" + this.getIndex() + "]";
        }
        return this.getName().toString();
    }

    public String getString(TextEncoder encoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getName().getString(encoder)).append(']');
        return sb.toString();
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getName().getString(namespaceRegistry, encoder, delimiterEncoder)).append(']');
        return sb.toString();
    }
}

