/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base.cache;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.cache.CacheStatistics;
import org.modeshape.graph.connector.base.cache.DefaultCacheStatistics;
import org.modeshape.graph.connector.base.cache.NodeCache;
import org.modeshape.graph.connector.base.cache.NodeCachePolicy;
import org.modeshape.graph.connector.base.cache.PathNodeCache;
import org.modeshape.graph.property.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class InMemoryNodeCache<KeyType, NodeType extends Node>
implements NodeCache<KeyType, NodeType> {
    protected final ConcurrentMap<KeyType, CacheEntry> entriesByKey = new ConcurrentHashMap<KeyType, CacheEntry>();
    protected NodeCachePolicy<KeyType, NodeType> policy = null;
    private DefaultCacheStatistics statistics = new DefaultCacheStatistics();

    public InMemoryNodeCache(NodeCachePolicy<KeyType, NodeType> policy) {
        this.assignPolicy(policy);
    }

    @Override
    public void assignPolicy(NodeCachePolicy<KeyType, NodeType> policy) {
        if (this.policy != null) {
            throw new IllegalStateException();
        }
        this.policy = policy;
    }

    @Override
    public void clearStatistics() {
        this.statistics = new DefaultCacheStatistics();
    }

    @Override
    public CacheStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public NodeType get(KeyType path) {
        assert (path != null);
        CacheEntry entry = (CacheEntry)this.entriesByKey.get(path);
        if (entry == null) {
            this.statistics.incrementMisses();
            return null;
        }
        Object node = entry.getNode();
        if (node != null) {
            this.statistics.incrementHits();
            return node;
        }
        this.entriesByKey.remove(path, entry);
        this.statistics.incrementExpirations();
        return null;
    }

    @Override
    public void put(KeyType key, NodeType node) {
        assert (node != null);
        if (!this.policy.shouldCache(node)) {
            return;
        }
        this.statistics.incrementWrites();
        this.entriesByKey.put(key, new CacheEntry(this, node));
    }

    @Override
    public void remove(KeyType key) {
        this.entriesByKey.remove(key);
    }

    @Override
    public void removeAll() {
        this.entriesByKey.clear();
    }

    @Override
    public void close() {
        assert (this.statistics != null) : "Attempt to close an already-closed cache";
        this.entriesByKey.clear();
        this.statistics = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathCache
    extends InMemoryNodeCache<Path, PathNode>
    implements PathNodeCache<PathNode> {
        public PathCache(NodeCachePolicy<Path, PathNode> policy) {
            super(policy);
        }

        @Override
        public void invalidate(Path path) {
            assert (path != null);
            Iterator iter = this.entriesByKey.keySet().iterator();
            while (iter.hasNext()) {
                Path key = (Path)iter.next();
                if (!key.isAtOrBelow(path)) continue;
                iter.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathCachePolicy
    implements NodeCachePolicy<Path, PathNode> {
        private static final long serialVersionUID = 1L;
        private long cacheTimeToLiveInSeconds;

        public PathCachePolicy() {
        }

        public PathCachePolicy(long timeToLiveInSeconds) {
            this.setTimeToLive(timeToLiveInSeconds);
        }

        @Override
        public boolean shouldCache(PathNode node) {
            return true;
        }

        @Override
        public long getTimeToLive() {
            return this.cacheTimeToLiveInSeconds;
        }

        public void setTimeToLive(long timeToLiveInSeconds) {
            this.cacheTimeToLiveInSeconds = timeToLiveInSeconds;
        }

        @Override
        public PathCache newCache() {
            return new PathCache(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapCache<N extends MapNode>
    extends InMemoryNodeCache<UUID, N> {
        public MapCache(NodeCachePolicy<UUID, N> policy) {
            super(policy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapCachePolicy<NodeType extends MapNode>
    implements NodeCachePolicy<UUID, NodeType> {
        private static final long serialVersionUID = 1L;
        private long cacheTimeToLiveInSeconds;

        public MapCachePolicy() {
        }

        public MapCachePolicy(long timeToLiveInSeconds) {
            this.setTimeToLive(timeToLiveInSeconds);
        }

        @Override
        public boolean shouldCache(NodeType node) {
            return true;
        }

        @Override
        public long getTimeToLive() {
            return this.cacheTimeToLiveInSeconds;
        }

        public void setTimeToLive(long timeToLiveInSeconds) {
            this.cacheTimeToLiveInSeconds = timeToLiveInSeconds;
        }

        @Override
        public MapCache<NodeType> newCache() {
            return new MapCache(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry {
        private final SoftReference<NodeType> ref;
        private final long expiryTime;
        final /* synthetic */ InMemoryNodeCache this$0;

        CacheEntry(NodeType node) {
            this.this$0 = var1_1;
            this.ref = new SoftReference(node);
            this.expiryTime = System.currentTimeMillis() + var1_1.policy.getTimeToLive() * 1000L;
        }

        NodeType getNode() {
            if (System.currentTimeMillis() > this.expiryTime) {
                return null;
            }
            return (Node)this.ref.get();
        }
    }
}

