/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.List;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.federation.PlaceholderNode;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.ProjectorWithPlaceholders;
import org.modeshape.graph.connector.federation.ProxyNode;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class OffsetMirrorProjector
extends ProjectorWithPlaceholders {
    private final Projection projection;
    private final Path offset;
    private final int offsetSize;
    private final Path sourcePath;

    static OffsetMirrorProjector with(ExecutionContext context, List<Projection> projections) {
        assert (projections != null);
        assert (context != null);
        if (projections.size() != 1) {
            return null;
        }
        Projection projection = projections.get(0);
        assert (projection != null);
        if (projection.getRules().size() != 1) {
            return null;
        }
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        List<Path> topLevelPaths = projection.getRules().get(0).getTopLevelPathsInRepository(pathFactory);
        if (topLevelPaths.size() != 1) {
            return null;
        }
        Path topLevelPath = topLevelPaths.get(0);
        assert (topLevelPath != null);
        if (topLevelPath.isRoot()) {
            return null;
        }
        Path sourcePath = projection.getRules().get(0).getPathInSource(topLevelPath, pathFactory);
        return new OffsetMirrorProjector(context, projections, topLevelPath, sourcePath);
    }

    private OffsetMirrorProjector(ExecutionContext context, List<Projection> projections, Path offset, Path sourcePath) {
        super(context, projections);
        this.projection = projections.get(0);
        this.offset = offset;
        this.offsetSize = offset.size();
        this.sourcePath = sourcePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProjectedNode project(ExecutionContext context, Location location, boolean requiresUpdate) {
        if (requiresUpdate && this.projection.isReadOnly()) {
            return null;
        }
        PlaceholderNode placeholder = this.isPlaceholder(location);
        if (placeholder != null) {
            return placeholder;
        }
        Path path = location.getPath();
        Location locationInSource = location;
        if (path == null) return new ProxyNode(this.projection, locationInSource, location);
        if (path.size() == this.offsetSize) {
            if (!path.equals(this.offset)) return null;
            locationInSource = location.with(this.sourcePath);
            return new ProxyNode(this.projection, locationInSource, location);
        } else {
            if (!path.isDecendantOf(this.offset)) return null;
            Path pathBelowOffset = path.relativeTo(this.offset);
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            Path pathInSource = pathFactory.create(this.sourcePath, pathBelowOffset);
            locationInSource = location.with(pathInSource);
        }
        return new ProxyNode(this.projection, locationInSource, location);
    }
}

