/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.smartgwt.client.types.VisibilityMode;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.layout.SectionStack;
import com.smartgwt.client.widgets.layout.SectionStackSection;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tab.Tab;
import java.util.Collection;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.JcrTreeNode;
import org.modeshape.web.client.NodePanel;
import org.modeshape.web.shared.JcrAccessControlList;
import org.modeshape.web.shared.JcrProperty;

public class NodePanel
extends Tab {
    private GeneralNodeInformationPanel generalInfo = new GeneralNodeInformationPanel(this);
    private PropertiesPanel properties;
    private AccessControlPanel accessControl;
    protected JcrTreeNode node;
    protected String path;
    protected Console console;

    public NodePanel(Console console) {
        this.console = console;
        this.setIcon("icons/view_table.png");
        this.setTitle("Node Properties");
        this.properties = new PropertiesPanel(this);
        this.accessControl = new AccessControlPanel(this);
        VLayout vLayout = new VLayout();
        vLayout.addMember((Canvas)new Strut(this, 15));
        vLayout.addMember((Canvas)this.generalInfo);
        vLayout.addMember((Canvas)new Strut(this, 15));
        SectionStack stack = new SectionStack();
        stack.setWidth100();
        stack.setHeight100();
        stack.setVisibilityMode(VisibilityMode.MULTIPLE);
        SectionStackSection psection = new SectionStackSection("Properties");
        psection.setExpanded(Boolean.valueOf(true));
        psection.addItem((Canvas)this.properties);
        stack.addSection(psection);
        SectionStackSection acl = new SectionStackSection("Access Control");
        acl.addItem((Canvas)this.accessControl);
        acl.setExpanded(Boolean.valueOf(true));
        stack.addSection(acl);
        vLayout.addMember((Canvas)stack);
        this.setPane((Canvas)vLayout);
    }

    public String principal() {
        return this.accessControl.principal();
    }

    public void display(JcrTreeNode node) {
        this.node = node;
        this.path = node.getPath();
        this.generalInfo.setNode(node);
        this.properties.setData(node.getProperties());
        this.accessControl.display(node.getAccessList(), null);
        this.console.jcrURL.setPath(this.path);
        this.console.htmlHistory.newItem(this.console.jcrURL.toString(), true);
    }

    public void setProperties(Collection<JcrProperty> props) {
        this.properties.setData(props);
    }

    public void setCanEditProperties(boolean flag) {
        this.properties.setCanEdit(flag);
    }

    public void refreshProperties() {
        this.properties.refresh();
    }

    public void display(JcrAccessControlList acl) {
        this.accessControl.display(acl, null);
    }

    public void display(JcrAccessControlList acl, String principal) {
        this.accessControl.display(acl, principal);
    }
}

