/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.naming.InitialContext;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.web.client.RemoteException;
import org.modeshape.web.server.Connector;
import org.modeshape.web.server.LRepository;
import org.modeshape.web.server.impl.LRepositoryImpl;
import org.modeshape.web.shared.RepositoryName;

public class ConnectorImpl
implements Connector {
    private static final long serialVersionUID = 1L;
    private transient HashMap<String, LRepository> repositories = new HashMap();
    private final transient Collection<RepositoryName> repositoryNames = new ArrayList();
    private transient Credentials credentials;
    private transient String userName;
    private static final Logger logger = Logger.getLogger(ConnectorImpl.class);

    public ConnectorImpl() throws RemoteException {
        try {
            InitialContext ic = new InitialContext();
            ModeShapeEngine engine = (ModeShapeEngine)ic.lookup("jcr");
            for (String name : engine.getRepositoryNames()) {
                JcrRepository repo = engine.getRepository(name);
                StringBuilder builder = new StringBuilder();
                builder.append("<b>Vendor: </b>");
                builder.append(repo.getDescriptor("jcr.repository.vendor"));
                builder.append("</br>");
                builder.append("<b>Version: </b>");
                builder.append(repo.getDescriptor("jcr.repository.version"));
                builder.append("</br>");
                builder.append(repo.getDescriptor("jcr.repository.vendor.url"));
                builder.append("</br>");
                String descriptor = builder.toString();
                this.repositoryNames.add(new RepositoryName(name, descriptor));
            }
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void login(String username, String password) {
        if (username == null) {
            this.credentials = null;
        }
        this.credentials = password == null ? new SimpleCredentials(username, null) : new SimpleCredentials(username, password.toCharArray());
        this.userName = username;
    }

    public String userName() {
        return this.userName;
    }

    public Collection<RepositoryName> getRepositories() {
        return this.repositoryNames;
    }

    public LRepository find(String name) throws RemoteException {
        if (!this.repositories.containsKey(name)) {
            try {
                logger.debug("Starting repository: " + name, new Object[0]);
                InitialContext ic = new InitialContext();
                ModeShapeEngine engine = (ModeShapeEngine)ic.lookup("jcr");
                this.repositories.put(name, new LRepositoryImpl(engine.getRepository(name), this.credentials));
            }
            catch (Exception e) {
                logger.debug("Could not start repository " + name, new Object[]{e});
                throw new RemoteException(e.getMessage());
            }
        }
        return (LRepository)this.repositories.get(name);
    }

    public Collection<RepositoryName> search(String name) {
        ArrayList<RepositoryName> list = new ArrayList<RepositoryName>();
        for (RepositoryName n : this.repositoryNames) {
            if (!n.getName().contains(name) && !n.getDescriptor().contains(name)) continue;
            list.add(n);
        }
        return list;
    }
}

