/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.util.LinkedList;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;
import org.modeshape.jcr.api.JcrTools;

@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class StatelessBeanManagedTransactionBean {
    private static Logger log = Logger.getLogger(StatelessBeanManagedTransactionBean.class);
    @Resource(mappedName="java:/jcr/artifacts")
    private Repository repository;
    @Resource
    private UserTransaction utxn;
    private final JcrTools tools = new JcrTools();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNodes(String path, int numNodesAtEachLevel, boolean print) throws Exception {
        if (path == null || path.trim().length() == 0) {
            path = "/";
        }
        this.utxn.begin();
        try {
            Session session = this.repository.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
            try {
                Node topNode = this.tools.findOrCreateNode(session, path, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                for (int i = 1; i <= numNodesAtEachLevel; ++i) {
                    Node node = topNode.addNode("node" + i, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                    node.setProperty("prop", "Property value for " + node.getIdentifier());
                    if (print) {
                        log.info((Object)("Populating " + node.getPath()));
                    }
                    for (int j = 1; j <= numNodesAtEachLevel; ++j) {
                        Node child = node.addNode("child" + j, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                        child.setProperty("prop", "Property value for " + child.getIdentifier());
                        if (print) {
                            log.info((Object)("Populating " + child.getPath()));
                        }
                        for (int k = 1; k <= numNodesAtEachLevel; ++k) {
                            Node grandChild = child.addNode("grandchild" + k, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
                            grandChild.setProperty("prop", "Property value for " + grandChild.getIdentifier());
                        }
                    }
                    if (i == numNodesAtEachLevel) continue;
                    if (print) {
                        log.info((Object)"Saving session");
                    }
                    session.save();
                    if (print) {
                        log.info((Object)"Committing transaction");
                    }
                    this.utxn.commit();
                    this.utxn.begin();
                }
                if (print) {
                    log.info((Object)"Saving session");
                }
                session.save();
            }
            finally {
                session.logout();
            }
        }
        finally {
            if (print) {
                log.info((Object)"Committing transaction");
            }
            this.utxn.commit();
        }
        if (print) {
            log.info((Object)"CreateNodesTest completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyNodesInTransaction(String path, int numNodesAtEachLevel, boolean print) throws Exception {
        if (path == null || path.trim().length() == 0) {
            path = "/";
        }
        this.utxn.begin();
        try {
            Session session = this.repository.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
            try {
                Node topNode = session.getNode(path);
                for (int i = 1; i <= numNodesAtEachLevel; ++i) {
                    Node node = topNode.getNode("node" + i);
                    if (print) {
                        log.info((Object)("Verifying " + node.getPath()));
                    }
                    node.getProperty("prop").getString().equals("Property value for " + node.getIdentifier());
                    for (int j = 1; j <= numNodesAtEachLevel; ++j) {
                        Node child = node.getNode("child" + j);
                        if (print) {
                            log.info((Object)("Verifying " + child.getPath()));
                        }
                        child.getProperty("prop").getString().equals("Property value for " + node.getIdentifier());
                        for (int k = 1; k <= numNodesAtEachLevel; ++k) {
                            Node grandChild = child.getNode("grandchild" + k);
                            if (print) {
                                log.info((Object)("Verifying " + grandChild.getPath()));
                            }
                            grandChild.getProperty("prop").getString().equals("Property value for " + node.getIdentifier());
                        }
                    }
                }
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            this.utxn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(String path, boolean removeChildrenOnly) throws Exception {
        this.utxn.begin();
        try {
            Session session = this.repository.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
            try {
                Node topNode = session.getNode(path);
                if (removeChildrenOnly) {
                    LinkedList<Node> children = new LinkedList<Node>();
                    NodeIterator iter = topNode.getNodes("node*");
                    while (iter.hasNext()) {
                        Node child = iter.nextNode();
                        children.addFirst(child);
                    }
                    for (Node child : children) {
                        child.remove();
                    }
                } else {
                    topNode.remove();
                }
                session.save();
            }
            finally {
                session.logout();
            }
        }
        finally {
            this.utxn.commit();
        }
    }
}

