/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.joda.time.DateTime;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.math.Duration;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.Reflection;
import org.modeshape.graph.connector.RepositoryConnectionPool;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.jboss.managed.JBossManagedI18n;
import org.modeshape.jboss.managed.ManagedConnector;
import org.modeshape.jboss.managed.ManagedLock;
import org.modeshape.jboss.managed.ManagedRepository;
import org.modeshape.jboss.managed.ManagedSession;
import org.modeshape.jboss.managed.ModeShapeManagedObject;
import org.modeshape.jboss.managed.util.ManagedUtils;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.sequencer.SequencingService;

@Immutable
@ManagementObject(isRuntime=true, name="ModeShapeEngine", description="A ModeShape engine", componentType=@ManagementComponent(type="ModeShape", subtype="Engine"), properties=ManagementProperties.EXPLICIT)
public final class ManagedEngine
implements ModeShapeManagedObject {
    private JcrEngine engine;
    private URL configurationUrl;

    public ManagedEngine() {
        this.engine = null;
    }

    public ManagedEngine(JcrEngine engine) {
        CheckArg.isNotNull((Object)engine, (String)"engine");
        this.engine = engine;
    }

    public void setConfigURL(URL configurationUrl) throws Exception {
        this.configurationUrl = configurationUrl;
        this.loadConfigurationAndCreateEngine();
    }

    protected synchronized void loadConfigurationAndCreateEngine() throws Exception {
        this.engine = new JcrConfiguration().loadFrom(this.configurationUrl).build();
    }

    protected synchronized JcrEngine getEngine() {
        return this.engine;
    }

    @ManagementOperation(description="Starts this engine", impact=ManagedOperation.Impact.Lifecycle)
    public synchronized void start() {
        if (!this.isRunning()) {
            this.engine.start();
        }
    }

    @ManagementOperation(description="Indicates if this engine is running", impact=ManagedOperation.Impact.ReadOnly)
    public synchronized boolean isRunning() {
        if (this.engine == null) {
            return false;
        }
        try {
            this.engine.getRepositoryService();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @ManagementOperation(description="Restarts this engine", impact=ManagedOperation.Impact.Lifecycle)
    public synchronized void restart() throws Exception {
        JcrEngine oldEngine = this.engine;
        try {
            this.loadConfigurationAndCreateEngine();
            this.start();
        }
        catch (Throwable e) {
            this.engine = oldEngine;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (Exception)e;
        }
        oldEngine.shutdownAndAwaitTermination(10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="Shutdowns this engine", impact=ManagedOperation.Impact.Lifecycle)
    public synchronized void shutdown() {
        if (this.isRunning()) {
            try {
                this.engine.shutdown();
            }
            finally {
                this.engine = null;
            }
        }
    }

    @ManagementOperation(description="Obtains the managed connectors of this engine", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<ManagedConnector> getConnectors() {
        if (!this.isRunning()) {
            return Collections.emptyList();
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        ArrayList<ManagedConnector> connectors = new ArrayList<ManagedConnector>();
        for (RepositorySource repositorySource : engine.getRepositoryService().getRepositoryLibrary().getSources()) {
            assert (repositorySource != null);
            connectors.add(new ManagedConnector(repositorySource));
        }
        return Collections.unmodifiableCollection(connectors);
    }

    @ManagementOperation(description="Get the number of connections currently in use", impact=ManagedOperation.Impact.ReadOnly)
    public long getInUseConnections(String connectorName) {
        if (!this.isRunning()) {
            return 0L;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        long totalConnectionsInUse = 0L;
        try {
            totalConnectionsInUse = engine.getRepositoryService().getRepositoryLibrary().getConnectionPool(connectorName).getInUseCount();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Throwable)e, JBossManagedI18n.errorDeterminingTotalInUseConnections, new Object[]{connectorName});
        }
        return totalConnectionsInUse;
    }

    @ManagementOperation(description="Get the number of sessions currently active", impact=ManagedOperation.Impact.ReadOnly)
    public long getActiveSessions(String repositoryName) {
        if (!this.isRunning()) {
            return 0L;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        int totalActiveSessions = 0;
        try {
            totalActiveSessions = this.getRepository(repositoryName).getMetrics().getActiveSessionCount();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Throwable)e, JBossManagedI18n.errorDeterminingTotalInUseConnections, new Object[]{repositoryName});
        }
        return totalActiveSessions;
    }

    @ManagementOperation(description="Obtains the properties for an object", impact=ManagedOperation.Impact.ReadOnly)
    public List<ManagedProperty> getProperties(String objectName, Component objectType) {
        if (!this.isRunning()) {
            return Collections.emptyList();
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        List<ManagedProperty> managedProps = new ArrayList<ManagedProperty>();
        if (objectType.equals((Object)Component.CONNECTOR)) {
            RepositorySource repositorySource = engine.getRepositorySource(objectName);
            assert (repositorySource != null) : "Connection '" + objectName + "' does not exist";
            managedProps = ManagedUtils.getProperties(objectType, repositorySource);
        } else if (objectType.equals((Object)Component.CONNECTIONPOOL)) {
            RepositoryConnectionPool connectionPool = engine.getRepositoryService().getRepositoryLibrary().getConnectionPool(objectName);
            assert (connectionPool != null) : "Repository Connection Pool for repository '" + objectName + "' does not exist";
            managedProps = ManagedUtils.getProperties(objectType, connectionPool);
        }
        return managedProps;
    }

    @ManagementOperation(description="Obtains the managed repositories of this engine", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<ManagedRepository> getRepositories() {
        if (!this.isRunning()) {
            return Collections.emptyList();
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        ArrayList<ManagedRepository> repositories = new ArrayList<ManagedRepository>();
        for (String repositoryName : engine.getRepositoryNames()) {
            repositories.add(new ManagedRepository(repositoryName));
        }
        return repositories;
    }

    public JcrRepository getRepository(String repositoryName) {
        if (!this.isRunning()) {
            return null;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        try {
            return engine.getRepository(repositoryName);
        }
        catch (RepositoryException e) {
            Logger.getLogger(this.getClass()).error((Throwable)e, JBossManagedI18n.errorGettingRepositoryFromEngine, new Object[]{repositoryName});
            return null;
        }
    }

    @ManagementOperation(description="The JCR version supported by this repository", impact=ManagedOperation.Impact.ReadOnly)
    public String getRepositoryVersion(String repositoryName) {
        String version = null;
        JcrRepository repository = this.getRepository(repositoryName);
        if (repository != null) {
            version = repository.getDescriptor("jcr.specification.name") + " " + repository.getDescriptor("jcr.specification.version");
        }
        return version;
    }

    @ManagementProperty(name="Query Activity", description="The number of queries executed", use={ViewUse.STATISTIC})
    public int getQueryActivity() {
        if (!this.isRunning()) {
            return 0;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return 0;
    }

    @ManagementProperty(name="Save Activity", description="The number of nodes saved", use={ViewUse.STATISTIC})
    public int getSaveActivity() {
        if (!this.isRunning()) {
            return 0;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return 0;
    }

    @ManagementProperty(name="Session Activity", description="The number of sessions created", use={ViewUse.STATISTIC})
    public Object getSessionActivity() {
        if (!this.isRunning()) {
            return null;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return 0;
    }

    @ManagementOperation(description="Obtains all the managed locks sorted by the owner", impact=ManagedOperation.Impact.ReadOnly)
    public List<ManagedLock> listLocks() {
        return this.listLocks(ManagedLock.SORT_BY_OWNER);
    }

    public List<ManagedLock> listLocks(Comparator<ManagedLock> lockSorter) {
        CheckArg.isNotNull(lockSorter, (String)"lockSorter");
        if (!this.isRunning()) {
            return Collections.emptyList();
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        ArrayList<ManagedLock> locks = new ArrayList<ManagedLock>();
        for (int i = 0; i < 5; ++i) {
            locks.add(new ManagedLock("workspace-" + i, true, "sessionId-1", new DateTime(), "id-" + i, "owner-" + i, true));
        }
        Collections.sort(locks, lockSorter);
        return locks;
    }

    @ManagementOperation(description="Obtains the managed sessions sorted by user name", impact=ManagedOperation.Impact.ReadOnly)
    public List<ManagedSession> listSessions() {
        return this.listSessions(ManagedSession.SORT_BY_USER);
    }

    public List<ManagedSession> listSessions(Comparator<ManagedSession> sessionSorter) {
        CheckArg.isNotNull(sessionSorter, (String)"sessionSorter");
        if (!this.isRunning()) {
            return Collections.emptyList();
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        ArrayList<ManagedSession> sessions = new ArrayList<ManagedSession>();
        for (int i = 0; i < 5; ++i) {
            sessions.add(new ManagedSession("workspace-" + i, "userName-" + i, "sessionId-1", new DateTime()));
        }
        Collections.sort(sessions, sessionSorter);
        return sessions;
    }

    @ManagementOperation(description="Removes the lock with the specified ID", impact=ManagedOperation.Impact.WriteOnly, params={@ManagementParameter(name="lockId", description="The lock identifier")})
    public boolean removeLock(String lockId) {
        if (!this.isRunning()) {
            return false;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return false;
    }

    @ManagementOperation(description="Terminates the session with the specified ID", impact=ManagedOperation.Impact.WriteOnly, params={@ManagementParameter(name="sessionId", description="The session identifier")})
    public boolean terminateSession(String sessionId) {
        if (!this.isRunning()) {
            return false;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        return false;
    }

    public RepositorySource getConnector(String connectorName) {
        if (!this.isRunning()) {
            return null;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        RepositorySource repositorySource = engine.getRepositorySource(connectorName);
        assert (repositorySource != null) : "Connector '" + connectorName + "' does not exist";
        return repositorySource;
    }

    @ManagementOperation(description="Pings a connector by name", impact=ManagedOperation.Impact.ReadOnly)
    public boolean pingConnector(String connectorName) {
        if (!this.isRunning()) {
            return false;
        }
        JcrEngine engine = this.getEngine();
        assert (engine != null);
        boolean success = false;
        String pingDuration = null;
        try {
            RepositoryConnectionPool pool = engine.getRepositoryService().getRepositoryLibrary().getConnectionPool(connectorName);
            if (pool != null) {
                Stopwatch sw = new Stopwatch();
                sw.start();
                success = pool.ping();
                sw.stop();
                pingDuration = sw.getTotalDuration().toString();
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Throwable)e, JBossManagedI18n.errorDeterminingIfConnectionIsAlive, new Object[]{connectorName});
        }
        if (pingDuration == null) {
            pingDuration = new Duration(0L).toString();
        }
        return success;
    }

    @ManagementOperation(description="Obtains the managed sequencing service of this engine", impact=ManagedOperation.Impact.ReadOnly)
    public SequencingService getSequencingService() {
        if (!this.isRunning()) {
            return null;
        }
        return this.getEngine().getSequencingService();
    }

    @ManagementOperation(description="Obtains the descriptors for a JCRRepository as ManagedProperties", impact=ManagedOperation.Impact.ReadOnly)
    public List<ManagedProperty> getRepositoryProperties(String repositoryName) {
        String[] descriptorKeys;
        if (!this.isRunning()) {
            return null;
        }
        ArrayList<ManagedProperty> propertyList = new ArrayList<ManagedProperty>();
        JcrRepository repository = this.getRepository(repositoryName);
        for (String key : descriptorKeys = repository.getDescriptorKeys()) {
            String value = repository.getDescriptor(key);
            propertyList.add(new ManagedProperty(ManagedUtils.createLabel(key), value));
        }
        return propertyList;
    }

    @ManagementOperation(description="Obtains the version of this ModeShape instance", impact=ManagedOperation.Impact.ReadOnly)
    public synchronized String getVersion() {
        if (!this.isRunning()) {
            return "";
        }
        return this.getEngine().getEngineVersion();
    }

    public static class ManagedProperty {
        private static final long serialVersionUID = 1L;
        private String name;
        private String label;
        private String description;
        private String value;

        public ManagedProperty() {
        }

        public ManagedProperty(String label, String currentValue) {
            this.setLabel(label);
            this.value = currentValue;
        }

        public ManagedProperty(Reflection.Property property, String currentValue) {
            this.setName(property.getName());
            this.setLabel(property.getLabel());
            this.setDescription(property.getDescription());
            this.value = currentValue;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum Component {
        CONNECTOR,
        SEQUENCER,
        CONNECTIONPOOL,
        SEQUENCINGSERVICE,
        REPOSITORY;

    }
}

