/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed.util;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.Reflection;
import org.modeshape.jboss.managed.JBossManagedI18n;
import org.modeshape.jboss.managed.ManagedEngine;

public class ManagedUtils {
    private static final Logger LOGGER = Logger.getLogger(ManagedUtils.class);

    public static List<ManagedEngine.ManagedProperty> getProperties(ManagedEngine.Component objectType, Object object) {
        Reflection reflection = new Reflection(object.getClass());
        ArrayList<ManagedEngine.ManagedProperty> managedProps = new ArrayList<ManagedEngine.ManagedProperty>();
        List props = new ArrayList();
        boolean allInferred = true;
        try {
            String valueAsString;
            props = reflection.getAllPropertiesOn(object);
            for (Reflection.Property prop : props) {
                if (prop.isInferred()) continue;
                allInferred = false;
                if (!prop.isPrimitive() && !prop.getType().toString().contains("java.lang.String")) continue;
                valueAsString = reflection.getPropertyAsString(object, prop);
                managedProps.add(new ManagedEngine.ManagedProperty(prop, valueAsString));
            }
            if (allInferred) {
                for (Reflection.Property prop : props) {
                    if (!prop.isPrimitive() && !prop.getType().toString().contains("java.lang.String")) continue;
                    valueAsString = reflection.getPropertyAsString(object, prop);
                    managedProps.add(new ManagedEngine.ManagedProperty(prop, valueAsString));
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error(e, JBossManagedI18n.errorGettingPropertiesFromManagedObject, new Object[]{objectType});
        }
        return managedProps;
    }

    public static String createLabel(String name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        name = name.replaceFirst("option.", "");
        name = name.replaceFirst("custom.", "");
        name = name.replace(".", " ");
        String label = null;
        Inflector inflector = Inflector.getInstance();
        if (name != null) {
            label = inflector.titleCase(inflector.humanize(name, new String[0]), new String[0]);
            label = label.replaceFirst("Jcr", "JCR");
        }
        return label;
    }
}

