/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.util.Comparator;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.joda.time.DateTime;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jboss.managed.ModeShapeManagedObject;

@Immutable
@ManagementObject(description="A ModeShape node lock", componentType=@ManagementComponent(type="ModeShape", subtype="Lock"), properties=ManagementProperties.EXPLICIT)
public final class ManagedLock
implements ModeShapeManagedObject {
    public static final Comparator<ManagedLock> SORT_BY_OWNER = new Comparator<ManagedLock>(){

        @Override
        public int compare(ManagedLock thisLock, ManagedLock thatLock) {
            return thisLock.getOwner().compareTo(thatLock.getOwner());
        }
    };
    private final boolean deep;
    private final DateTime expiration;
    private final String id;
    private final String sessionId;
    private final String owner;
    private final boolean sessionBased;
    private final String workspaceName;

    public ManagedLock(String workspaceName, boolean sessionBased, String sessionId, DateTime expiration, String id, String owner, boolean deep) {
        CheckArg.isNotEmpty((String)workspaceName, (String)"workspaceName");
        CheckArg.isNotEmpty((String)sessionId, (String)"sessionId");
        CheckArg.isNotNull((Object)expiration, (String)"expiration");
        CheckArg.isNotEmpty((String)id, (String)"id");
        CheckArg.isNotEmpty((String)owner, (String)"owner");
        this.deep = deep;
        this.expiration = expiration;
        this.id = id;
        this.sessionId = sessionId;
        this.owner = owner;
        this.sessionBased = sessionBased;
        this.workspaceName = workspaceName;
    }

    @ManagementProperty(name="Expiration Time", description="The time this lock will expire", readOnly=true, use={ViewUse.RUNTIME})
    public DateTime getExpiration() {
        return this.expiration;
    }

    @ManagementProperty(name="Lock ID", description="The lock's unique identifier", readOnly=true, use={ViewUse.RUNTIME})
    @ManagementObjectID(prefix="ModeShapeLock-")
    public String getId() {
        return this.id;
    }

    @ManagementProperty(name="Owner", description="The owner of the lock", readOnly=true, use={ViewUse.RUNTIME})
    public String getOwner() {
        return this.owner;
    }

    @ManagementProperty(name="Session ID", description="The identifier of the session this lock belongs to", readOnly=true, use={ViewUse.RUNTIME})
    public String getSessionId() {
        return this.sessionId;
    }

    @ManagementProperty(name="Workspace", description="The name of the workspace lock belongs to", readOnly=true, use={ViewUse.RUNTIME})
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    @ManagementProperty(name="Deep", description="Indicates if this lock is a deep lock", readOnly=true, use={ViewUse.RUNTIME})
    public boolean isDeep() {
        return this.deep;
    }

    @ManagementProperty(name="Session-Based", description="Indicates if this lock is a session-based lock", readOnly=true, use={ViewUse.RUNTIME})
    public boolean isSessionBased() {
        return this.sessionBased;
    }
}

